/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.realtime.frame.RtModelFrame;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.BandCount;

public class BandNames
implements Iterable<String> {
    private final List<String> bandNames;

    public BandNames(List<String> list) {
        this.bandNames = new ArrayList<String>(list);
    }

    public BandNames(String ... stringArray) {
        this(Arrays.asList(stringArray));
    }

    public BandNames(BandCount bandCount, double d, double d2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        double d3 = (d2 - d) / (double)(bandCount.value - 1);
        for (int i = 0; i < bandCount.value; ++i) {
            arrayList.add(RtDataFormat.toString(d + (double)i * d3));
        }
        this.bandNames = arrayList;
    }

    public String getOrInterpolate(int n) {
        if (n < this.bandNames.size()) {
            return this.bandNames.get(n);
        }
        if (this.bandNames.size() >= 2) {
            int n2 = this.bandNames.size() - 2;
            int n3 = this.bandNames.size() - 1;
            double d = RtDataFormat.toNumber(this.bandNames.get(n2));
            double d2 = RtDataFormat.toNumber(this.bandNames.get(n3));
            if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                double d3 = d2 - d;
                int n4 = n - n3;
                return RtDataFormat.toString(d2 + d3 * (double)n4);
            }
        }
        return "Band " + (n + 1);
    }

    public void add(String string) {
        this.bandNames.add(string);
    }

    public String get(int n) {
        if (n >= 0 && n < this.bandNames.size()) {
            return this.bandNames.get(n);
        }
        return "Band " + (n + 1);
    }

    public float getValue(int n) {
        String string = this.get(n);
        if (RtDataFormat.isNumber(string)) {
            return RtDataFormat.toNumberFloat(string);
        }
        return n;
    }

    public String getFormated(int n) {
        if (n >= 0 && n < this.bandNames.size()) {
            String string = this.bandNames.get(n);
            if (RtDataFormat.isNumber(string)) {
                return RtDataFormat.toString(RtDataFormat.toNumber(string));
            }
            return string;
        }
        return "Band " + (n + 1);
    }

    public String getFormatedRange(int n) {
        if (n >= 0 && n < this.bandNames.size()) {
            String string = this.bandNames.get(n);
            if (RtDataFormat.isNumber(string)) {
                double d = RtDataFormat.toNumber(string);
                if (d > 100.0 && d < 10000.0) {
                    return RtDataFormat.toString(d) + " nm";
                }
                return RtDataFormat.toString(d);
            }
            return string;
        }
        return "Band " + (n + 1);
    }

    public void set(int n, String string) {
        this.bandNames.set(n, string);
    }

    public BandCount count() {
        return new BandCount(this.bandNames.size());
    }

    public int size() {
        return this.bandNames.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.bandNames.iterator();
    }

    public int indexOf(String string) {
        return this.bandNames.indexOf(string);
    }

    public String toEnviHdrString() {
        return this.toEnviHdrString("Wavelength");
    }

    public String toEnviHdrString(String string) {
        return String.format(string + " = {\r\n%s\r\n}", String.join((CharSequence)",\r\n", this.bandNames));
    }

    public String toWavelength() {
        return String.join((CharSequence)";", this.bandNames);
    }

    public String toString() {
        return String.format("BandNames(%s)", String.join((CharSequence)", ", this.bandNames));
    }

    public String[] toArray() {
        return this.bandNames.toArray(new String[0]);
    }

    public List<String> getList() {
        return this.bandNames;
    }

    public float[] toFloatArray() {
        float[] fArray = new float[this.bandNames.size()];
        for (int i = 0; i < this.bandNames.size(); ++i) {
            fArray[i] = this.getValue(i);
        }
        return fArray;
    }

    public int[] toBandMap() {
        return null;
    }

    public int closestIndexOf(String string) {
        return this.closestIndexOf(RtDataFormat.toNumber(string));
    }

    private int closestIndexOf(double d) {
        double d2 = RtDataFormat.toNumber(this.get(0));
        for (int i = 1; i < this.bandNames.size(); ++i) {
            if (d <= d2) {
                return i - 1;
            }
            double d3 = RtDataFormat.toNumber(this.get(i));
            if (d < d3) {
                double d4 = d - d2;
                double d5 = d3 - d;
                return d4 < d5 ? i - 1 : i;
            }
            d2 = d3;
        }
        return this.bandNames.size() - 1;
    }

    public Pair<Integer, Integer> getStartStop(float f, float f2) {
        return this.getStartStop(f, f2, this.toFloatArray());
    }

    public Pair<Integer, Integer> getStartStop(float f, float f2, float[] fArray) {
        if (f >= 0.0f && f2 >= 0.0f) {
            int n = -1;
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] >= f && n < 0) {
                    n = i > 0 && fArray[i] > f ? i - 1 : i;
                }
                if (!(fArray[i] >= f2)) continue;
                return Pair.of((Object)n, (Object)i);
            }
        }
        return Pair.of((Object)0, (Object)(fArray.length - 1));
    }

    public Pair<Float, Float> getStartStopWavelength(float f, float f2) {
        float[] fArray = this.toFloatArray();
        Pair<Integer, Integer> pair = this.getStartStop(f, f2, fArray);
        return Pair.of((Object)Float.valueOf(fArray[(Integer)pair.getLeft()]), (Object)Float.valueOf(fArray[(Integer)pair.getRight()]));
    }

    public BandNames getWithin(float f, float f2) {
        Pair<Integer, Integer> pair = this.getStartStop(f, f2);
        BandNames bandNames = new BandNames(new String[0]);
        Integer n = (Integer)pair.getLeft();
        while (n <= (Integer)pair.getRight()) {
            bandNames.add(this.get(n));
            Integer n2 = n;
            n = n + 1;
        }
        return bandNames;
    }

    public String getFormatedRange() {
        if (this.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getFormated(0));
        stringBuilder.append(" - ");
        stringBuilder.append(this.getFormated(this.size() - 1));
        if (this.isNumber() && this.isNm()) {
            stringBuilder.append(" nm");
        }
        return stringBuilder.toString();
    }

    public boolean isNm() {
        String string;
        if (this.bandNames.size() > 0 && RtDataFormat.isNumber(string = this.bandNames.get(0))) {
            double d = RtDataFormat.toNumber(string);
            return d > 100.0 && d < 10000.0;
        }
        return false;
    }

    public boolean isNumber() {
        for (String string : this) {
            if (RtDataFormat.isNumber(string)) continue;
            return false;
        }
        return true;
    }

    public BandNames getClosestRange(String string, String string2) {
        int n = this.closestIndexOf(string);
        int n2 = this.closestIndexOf(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = n; i <= n2; ++i) {
            arrayList.add(this.get(i));
        }
        return new BandNames(arrayList);
    }

    public boolean[] getWaterAbsoptionIndexes() {
        int[][] nArrayArray = new int[][]{{960, 990}, {1320, 1500}, {1780, 2050}, {2450, 2500}};
        float[] fArray = this.toFloatArray();
        boolean[] blArray = new boolean[fArray.length];
        block0: for (int i = 0; i < fArray.length; ++i) {
            float f = fArray[i];
            if (f < 10.0f) {
                f *= 1000.0f;
            }
            for (int[] nArray : nArrayArray) {
                if (!(f >= (float)nArray[0]) || !(f <= (float)nArray[1])) continue;
                blArray[i] = true;
                continue block0;
            }
        }
        return blArray;
    }

    public BandNames fromBands(int[] nArray) {
        if (nArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(this.get(nArray[i]));
            }
            return new BandNames(arrayList);
        }
        return this;
    }

    public static BandNames fromWavelength(float[] fArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fArray.length; ++i) {
            arrayList.add(RtDataFormat.toString(fArray[i]));
        }
        return new BandNames(arrayList);
    }

    public static BandNames fromEvinceLayerNames(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        return new BandNames(Arrays.asList(stringArray));
    }

    public static BandNames fromBandFile(File file) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                object = string.split("\\s+");
                if (((String[])object).length == 1) {
                    arrayList.add(object[0]);
                    continue;
                }
                arrayList.add(object[1]);
            }
            object = new BandNames(arrayList);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        bufferedReader.close();
        return object;
    }

    public static BandNames fromModelFrames(RtFrameStackList rtFrameStackList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (RtModelFrame rtModelFrame : rtFrameStackList.getFrameStack(0).getModelFrames()) {
            arrayList.addAll(rtModelFrame.getBandNames().bandNames);
        }
        return new BandNames(arrayList);
    }

    public static BandNames fromSemiColonSeparatedWavelengthList(String string) {
        return new BandNames(Arrays.asList(string.split(";")).stream().map(String::trim).collect(Collectors.toList()));
    }

    public static BandNames fromIndex(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add("" + i);
        }
        return new BandNames(arrayList);
    }

    public static BandNames fromRange(float f, float f2, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        float f3 = (f2 - f) / (float)(n - 1);
        for (int i = 0; i < n; ++i) {
            arrayList.add(RtDataFormat.toString(f + f3 * (float)i));
        }
        return new BandNames(arrayList);
    }
}

