/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

public enum DataSize {
    BYTE_1(1, "byte"),
    SHORT_2(2, "short"),
    FLOAT_4(4, "float"),
    DOUBLE_8(8, "double");

    public int size;
    private final String name;

    private DataSize(int n2, String string2) {
        this.size = n2;
        this.name = string2;
    }

    public static DataSize fromEvinceDataSize(int n) {
        if (n == 1) {
            return BYTE_1;
        }
        if (n == 2) {
            return SHORT_2;
        }
        if (n == 4) {
            return FLOAT_4;
        }
        if (n == 8) {
            return DOUBLE_8;
        }
        throw new RuntimeException(String.format("Unsupported data size: %d", n));
    }

    public int toHdrDataType() {
        if (this.size == 1) {
            return 1;
        }
        if (this.size == 2) {
            return 12;
        }
        if (this.size == 4) {
            return 4;
        }
        if (this.size == 8) {
            return 5;
        }
        throw new RuntimeException(String.format("Unsupported data size: %d", this.size));
    }

    public String getName() {
        return this.name;
    }

    public static DataSize fromBreezeRuntime(String string) {
        for (DataSize dataSize : DataSize.values()) {
            if (!dataSize.name.equalsIgnoreCase(string)) continue;
            return dataSize;
        }
        throw new RuntimeException("DataSize not supported: " + string);
    }

    public String toString() {
        return this.name;
    }

    public int maxSize() {
        return switch (this.ordinal()) {
            case 0 -> 255;
            case 1 -> 65535;
            default -> Integer.MAX_VALUE;
        };
    }
}

