/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.Resolution;

public class FieldOfView {
    public final float value;

    public FieldOfView(float f) {
        this.value = f;
    }

    public FieldOfView(Resolution resolution, PixelWidth pixelWidth) {
        this(resolution.value * (float)pixelWidth.value);
    }

    public boolean equals(Object object) {
        return object instanceof FieldOfView && ((FieldOfView)object).value == this.value;
    }

    public String toString() {
        return RtDataFormat.toString(this.value) + " mm";
    }

    public static FieldOfView fromMeasurementMetaValue(String string) {
        if (string != null && !string.equals("NA") && !string.equals("NaN")) {
            return new FieldOfView(RtDataFormat.toNumberFloat(string));
        }
        throw new FieldOfViewFromMetaValueException(string);
    }

    public static class FieldOfViewFromMetaValueException
    extends RuntimeException {
        public FieldOfViewFromMetaValueException(String string) {
            super(String.format("Could not create field of view from metavalue '%s'", string));
        }
    }
}

