/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import java.util.List;
import se.prediktera.breeze.common.util.IFramesToAverage;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.hardware.Camera;

public class FrameCount
implements Comparable<FrameCount> {
    public static final FrameCount Continuously = new FrameCount(-1);
    public final int value;

    public FrameCount(int n) {
        this.value = n;
    }

    public FrameCount(Time time, Camera camera) {
        this((int)FrameCount.getFrameCount(time, camera));
    }

    public FrameCount(LengthValue lengthValue, Camera camera) {
        this((int)FrameCount.getFrameCount(lengthValue, camera));
    }

    public FrameCount(LengthValue lengthValue, Speed speed, FrameRate frameRate, int n) {
        this((int)FrameCount.getFrameCount(lengthValue, speed, frameRate, n));
    }

    public boolean equals(Object object) {
        return object instanceof FrameCount && ((FrameCount)object).value == this.value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isFixed() {
        return !this.isContinuously();
    }

    public boolean isContinuously() {
        return this.value == -1;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public FrameCount added(int n) {
        return new FrameCount(this.value + n);
    }

    public FrameCount multiplied(int n) {
        return new FrameCount(this.value * n);
    }

    @Override
    public int compareTo(FrameCount frameCount) {
        if (this.equals(Continuously)) {
            return 1;
        }
        return Integer.compare(this.value, frameCount.value);
    }

    public static FrameCount fromReference(MeasurementLength measurementLength, Camera camera, Camera camera2) {
        float f = measurementLength.getFrameCountValue(camera);
        if (camera2 != null && camera2 != camera) {
            float f2 = camera2.getFrameRate().value / (float)IFramesToAverage.get(camera2) / (camera.getFrameRate().value / (float)IFramesToAverage.get(camera));
            return new FrameCount((int)Math.ceil(f * f2));
        }
        return new FrameCount((int)f);
    }

    public static String toArgument(List<FrameCount> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get((int)i).value);
        }
        return stringBuilder.toString();
    }

    public static float getFrameCount(Camera camera, MeasurementLength.LengthUnit lengthUnit, float f) {
        if (lengthUnit.isScale()) {
            return FrameCount.getFrameCount(new LengthValue(f * lengthUnit.getScale()), camera);
        }
        if (lengthUnit.equals((Object)MeasurementLength.LengthUnit.sec)) {
            return FrameCount.getFrameCount(new Time.Seconds(f), camera);
        }
        return f;
    }

    public static float getFrameCount(Time time, Camera camera) {
        return time.toSeconds() * camera.getFrameRate().value;
    }

    public static float getFrameCount(LengthValue lengthValue, Camera camera) {
        return FrameCount.getFrameCount(lengthValue, new Speed(camera), camera.getFrameRate(), IFramesToAverage.get(camera));
    }

    public static float getFrameCount(LengthValue lengthValue, Speed speed, FrameRate frameRate, int n) {
        return lengthValue.value / speed.value * frameRate.value / (float)n;
    }
}

