/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import se.prediktera.breeze.common.util.IFramesToAverage;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.hardware.Camera;

public class FrameRate {
    public final float value;
    public final float interval;

    public FrameRate(float f) {
        this.value = f;
        this.interval = f > 0.0f ? 1000.0f / f : 0.0f;
    }

    public FrameRate(Speed speed, LengthValue lengthValue, FrameCount frameCount) {
        this((float)frameCount.value / (lengthValue.value / speed.value));
    }

    public boolean equals(Object object) {
        return object instanceof FrameRate && ((FrameRate)object).value == this.value;
    }

    public float timeMs(int n) {
        return this.interval * (float)n;
    }

    public String toString() {
        return RtDataFormat.toString(this.value) + " fps";
    }

    public Time frameTime() {
        return new Time.MilliSeconds((long)this.frameTimeFloat());
    }

    public float frameTimeFloat() {
        return 1000.0f / this.value;
    }

    public static FrameRate fromFrameTime(float f) {
        return new FrameRate(1000.0f / f);
    }

    public float framePeriodFloat() {
        return 1000000.0f / this.value;
    }

    public static FrameRate fromFramePeriod(float f) {
        return new FrameRate(1000000.0f / f);
    }

    public static FrameRate calculateTargetFrameRate(Camera camera, Camera camera2) {
        return new FrameRate(new Speed((Camera)camera).value * (float)IFramesToAverage.get(camera2) / camera2.getResolution().value);
    }
}

