/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.IntHolder;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.raw.FrameReader;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.RtThreader;

public class IntegrationTime {
    public final float value;

    public IntegrationTime(float f) {
        this.value = f;
    }

    public boolean equals(Object object) {
        return object instanceof IntegrationTime && ((IntegrationTime)object).value == this.value;
    }

    public String toString() {
        if (Double.isNaN(this.value)) {
            return "Unknown integration time";
        }
        return RtDataFormat.toString(this.value) + " \u00b5s";
    }

    public static IntegrationTime getRecommendedValue(BreezeProgress breezeProgress, FrameReader.RawFrameIterator rawFrameIterator, IntegrationTime integrationTime, MaxSignal maxSignal, float f) {
        double d;
        double d2 = IntegrationTime.calcMaxValue(breezeProgress, rawFrameIterator, maxSignal.value, 0.99f);
        double d3 = d2 / (d = (double)(maxSignal.value * f));
        if (d3 > 0.0) {
            double d4 = 1.0 / d3 * (double)integrationTime.value;
            int n = (int)Math.round(d4 / 100.0) * 100;
            return new IntegrationTime(n);
        }
        return integrationTime;
    }

    private static double calcMaxValue(BreezeProgress breezeProgress, FrameReader.RawFrameIterator rawFrameIterator, float f, float f2) {
        int n;
        final int[] nArray = new int[(int)Math.ceil(f) + 1];
        final IntHolder intHolder = new IntHolder();
        breezeProgress.setInfoText("Calculating");
        breezeProgress.setMaximumAndReset(rawFrameIterator.size());
        while (rawFrameIterator.hasNext()) {
            final RawFrame rawFrame = (RawFrame)rawFrameIterator.next();
            n = rawFrame.getColumns().value;
            new RtThreader(){

                @Override
                protected void doOp(boolean bl, int n5, int n2) {
                    for (int i = n5; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            int n3 = (int)rawFrame.getFrameValue(i, j);
                            if (n3 >= nArray.length) continue;
                            int n4 = n3;
                            nArray[n4] = nArray[n4] + 1;
                            intHolder.increase();
                        }
                    }
                }
            }.execute(rawFrame.getRows().value);
            breezeProgress.incStep();
        }
        int n2 = (int)Math.ceil((1.0f - f2) * (float)intHolder.getValue());
        n = 0;
        for (int i = nArray.length - 1; i >= 0; --i) {
            if ((n += nArray[i]) < n2) continue;
            return i;
        }
        return 0.0;
    }
}

