/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.Resolution;
import se.prediktera.breeze.common.util.type.Speed;

public class LengthValue {
    public final float value;
    private String unit;

    public LengthValue(float f) {
        this(f, "mm");
    }

    public LengthValue(float f, String string) {
        this.value = f;
        this.unit = string;
    }

    public LengthValue(Resolution resolution, FrameCount frameCount) {
        this.value = resolution.value * (float)frameCount.value;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public boolean equals(Object object) {
        return object instanceof LengthValue && ((LengthValue)object).value == this.value;
    }

    public LengthValue multiplied(float f) {
        return new LengthValue(this.value * f);
    }

    public String toString() {
        return RtDataFormat.toString(this.value) + " " + this.unit;
    }

    public LengthValue withScanMarginal() {
        return this.withScanMarginal(0.1f);
    }

    public LengthValue withScanMarginal(float f) {
        float f2 = f;
        return new LengthValue(this.value * (1.0f + f2));
    }

    public LengthValue withOffset(LengthValue lengthValue) {
        return new LengthValue(this.value + lengthValue.value);
    }

    public Time timeToTravel(Speed speed) {
        return new Time.MilliSeconds((long)(1000.0f * this.value / speed.value));
    }

    public FrameCount toFrames(Resolution resolution) {
        if (resolution.value > 0.0f) {
            return new FrameCount((int)(this.value / resolution.value));
        }
        return new FrameCount((int)this.value);
    }
}

