/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import java.util.List;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.FrameReader;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.type.RgbBands;

public class MaxSignal {
    public static final MaxSignal DEFAULT = new MaxSignal(16384.0f);
    public static final MaxSignal ForVisalization = new MaxSignal(10.0f);
    public final float value;

    public MaxSignal(float f) {
        this.value = f;
    }

    public MaxSignal(List<? extends Frame> list, RgbBands rgbBands, boolean bl) {
        this.value = MaxSignal.calcMaxValue(list, rgbBands, bl);
    }

    private static float calcMaxValue(List<? extends Frame> list, RgbBands rgbBands, boolean bl) {
        float f = 0.0f;
        for (Frame frame : list) {
            for (int i = 0; i < frame.columns.value; ++i) {
                for (int j = 0; j < rgbBands.size(); ++j) {
                    f = Math.max(f, frame.getReferenceValue(rgbBands.get(j), i));
                }
            }
        }
        if (bl) {
            if (f <= 255.0f) {
                return 255.0f;
            }
            if (f <= 4095.0f) {
                return 4095.0f;
            }
            if (f <= 16383.0f) {
                return 16383.0f;
            }
            if (f <= 65535.0f) {
                return 65535.0f;
            }
        }
        return f;
    }

    public MaxSignal(List<? extends Frame> list, RgbBands rgbBands) {
        this.value = MaxSignal.calcMaxValue(list, rgbBands);
    }

    private static float calcMaxValue(List<? extends Frame> list, RgbBands rgbBands) {
        float f = 0.0f;
        for (Frame frame : list) {
            for (int i = 0; i < frame.columns.value; ++i) {
                for (int j = 0; j < 3; ++j) {
                    f = Math.max(f, frame.getFrameValue(rgbBands.get(j), i));
                }
            }
        }
        return f;
    }

    public MaxSignal(RawFile rawFile, RgbBands rgbBands) {
        this.value = MaxSignal.calcMaxValue(rawFile, rgbBands);
    }

    public static float calcMaxValue(RawFile rawFile, RgbBands rgbBands) {
        float f = 0.0f;
        try (FrameReader.FrameIterator frameIterator = new FrameReader(rawFile.file(), rawFile.header(), rgbBands.getArray(), false, FrameListFromRaw.Reduce.Original).iterator();){
            while (frameIterator.hasNext()) {
                RawFrame rawFrame = frameIterator.next();
                for (int i = 0; i < rawFrame.columns.value; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        f = Math.max(f, rawFrame.getFrameValue(j, i));
                    }
                }
            }
        }
        return f;
    }

    public boolean equals(Object object) {
        return object instanceof MaxSignal && ((MaxSignal)object).value == this.value;
    }

    public String toString() {
        return RtDataFormat.toString(this.value);
    }

    public float inverted() {
        if (this.value > 0.0f) {
            return 1.0f / this.value;
        }
        return 0.0f;
    }

    public float invertedSquare() {
        if (this.value > 0.0f) {
            return (float)(1.0 / Math.sqrt(this.value));
        }
        return 0.0f;
    }

    public static MaxSignal getDefaultIfNull(MaxSignal maxSignal) {
        return maxSignal == null ? DEFAULT : maxSignal;
    }

    public static MaxSignal fromMeasurementMetaValue(String string) {
        if (string != null && !string.equals("NA")) {
            return new MaxSignal(RtDataFormat.toNumberFloat(string));
        }
        return DEFAULT;
    }

    public static boolean isValid(MaxSignal maxSignal) {
        return maxSignal != null && maxSignal.value > 0.0f && maxSignal.value <= 65536.0f;
    }
}

