/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import java.util.List;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;

public class MeasurementLength {
    public float value;
    private final LengthUnit unit;

    public MeasurementLength(float f) {
        this(f, LengthUnit.mm);
    }

    public MeasurementLength(float f, LengthUnit lengthUnit) {
        this.value = f;
        this.unit = lengthUnit;
    }

    public FrameCount getFrameCount(Camera camera) {
        return new FrameCount((int)this.getFrameCountValue(camera));
    }

    public float getFrameCountValue(Camera camera) {
        return FrameCount.getFrameCount(camera, this.unit, this.value);
    }

    public LengthValue getLength(Camera camera) {
        if (this.unit.isScale()) {
            return new LengthValue(this.value * this.unit.getScale());
        }
        if (this.unit.equals((Object)LengthUnit.sec)) {
            return MeasurementLength.getLength(this.value * camera.getFrameRate().value, camera);
        }
        return MeasurementLength.getLength(this.value, camera);
    }

    private static LengthValue getLength(float f, Camera camera) {
        return new LengthValue(f * camera.getResolution().value);
    }

    public boolean equals(Object object) {
        return object instanceof MeasurementLength && ((MeasurementLength)object).value == this.value;
    }

    public static MeasurementLength convertTo(MeasurementLength measurementLength, LengthUnit lengthUnit, Camera camera) {
        if (camera.isConnected()) {
            float f = measurementLength.getFrameCountValue(camera);
            if (lengthUnit.equals((Object)LengthUnit.frames)) {
                return new MeasurementLength(f, lengthUnit);
            }
            if (lengthUnit.isScale()) {
                return new MeasurementLength(MeasurementLength.getLength((float)f, (Camera)camera).value / lengthUnit.getScale(), lengthUnit);
            }
            if (lengthUnit.equals((Object)LengthUnit.sec)) {
                return new MeasurementLength(f / camera.getFrameRate().value, lengthUnit);
            }
        }
        return new MeasurementLength(measurementLength.value, lengthUnit);
    }

    public LengthUnit getUnit() {
        return this.unit;
    }

    public String toString() {
        return RtDataFormat.toString(this.value) + " " + this.unit.name();
    }

    public static enum LengthUnit {
        mm(1.0f),
        cm(10.0f),
        degree(1.0f),
        frames(1.0f),
        sec(1.0f);

        private final float scale;

        private LengthUnit(float f) {
            this.scale = f;
        }

        public boolean isScale() {
            return this.equals((Object)mm) || this.equals((Object)cm) || this.equals((Object)degree);
        }

        public float getScale() {
            return this.scale;
        }

        public boolean support(RemoteSampleMoverSettings.MoverType moverType) {
            if (moverType.equals((Object)RemoteSampleMoverSettings.MoverType.Rotation)) {
                return this.equals((Object)degree) || this.equals((Object)frames) || this.equals((Object)sec);
            }
            return !this.equals((Object)degree);
        }

        public static List<LengthUnit> values(SampleMover sampleMover) {
            List<LengthUnit> list = List.of(LengthUnit.values());
            if (sampleMover != null) {
                RemoteSampleMoverSettings.MoverType moverType = sampleMover.getType();
                return list.stream().filter(lengthUnit -> lengthUnit.support(moverType)).toList();
            }
            return list;
        }

        public static LengthUnit parseUnit(String string) {
            if (string != null) {
                for (LengthUnit lengthUnit : LengthUnit.values()) {
                    if (!lengthUnit.name().equalsIgnoreCase(string)) continue;
                    return lengthUnit;
                }
            }
            return mm;
        }
    }
}

