/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.FakeCamera;

public class MeasurementLengthTest {
    @Test
    public void testConvertValue() {
        FakeCamera.FakeCameraWithSetFieldOfView fakeCameraWithSetFieldOfView = new FakeCamera.FakeCameraWithSetFieldOfView();
        fakeCameraWithSetFieldOfView.setFrameRate(new FrameRate(25.0f));
        fakeCameraWithSetFieldOfView.setFieldOfView(new FieldOfView(50.0f));
        fakeCameraWithSetFieldOfView.setWidth(new PixelWidth(100));
        MatcherAssert.assertThat((Object)new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.frames).getFrameCount((Camera)fakeCameraWithSetFieldOfView).value, (Matcher)CoreMatchers.equalTo((Object)100));
        MatcherAssert.assertThat((Object)new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.mm).getFrameCount((Camera)fakeCameraWithSetFieldOfView).value, (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.sec).getFrameCount((Camera)fakeCameraWithSetFieldOfView).value, (Matcher)CoreMatchers.equalTo((Object)2500));
        MatcherAssert.assertThat((Object)Float.valueOf(new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.frames).getLength((Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(50.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.mm).getLength((Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(100.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.sec).getLength((Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(1250.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(MeasurementLength.convertTo((MeasurementLength)new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.frames), (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.frames, (Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(100.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(MeasurementLength.convertTo((MeasurementLength)new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.frames), (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.mm, (Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(50.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(MeasurementLength.convertTo((MeasurementLength)new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.frames), (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.sec, (Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(4.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(MeasurementLength.convertTo((MeasurementLength)new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.mm), (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.mm, (Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(100.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(MeasurementLength.convertTo((MeasurementLength)new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.mm), (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.frames, (Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(200.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(MeasurementLength.convertTo((MeasurementLength)new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.mm), (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.sec, (Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(8.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(MeasurementLength.convertTo((MeasurementLength)new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.sec), (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.sec, (Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(100.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(MeasurementLength.convertTo((MeasurementLength)new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.sec), (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.frames, (Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(2500.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(MeasurementLength.convertTo((MeasurementLength)new MeasurementLength((float)100.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.sec), (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.mm, (Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(1250.0f)));
    }

    @Test
    public void testConvertValueDecimals() {
        FakeCamera.FakeCameraWithSetFieldOfView fakeCameraWithSetFieldOfView = new FakeCamera.FakeCameraWithSetFieldOfView();
        fakeCameraWithSetFieldOfView.setFrameRate(new FrameRate(25.0f));
        fakeCameraWithSetFieldOfView.setFieldOfView(new FieldOfView(50.0f));
        fakeCameraWithSetFieldOfView.setWidth(new PixelWidth(100));
        MatcherAssert.assertThat((Object)new MeasurementLength((float)101.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.mm).getFrameCount((Camera)fakeCameraWithSetFieldOfView).value, (Matcher)CoreMatchers.equalTo((Object)202));
        MatcherAssert.assertThat((Object)Float.valueOf(MeasurementLength.convertTo((MeasurementLength)new MeasurementLength((float)101.0f, (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.mm), (MeasurementLength.LengthUnit)MeasurementLength.LengthUnit.mm, (Camera)fakeCameraWithSetFieldOfView).value), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(101.0f)));
    }
}

