/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;

public class RgbBands
implements Iterable<Integer> {
    public static Color[] RgbColors = new Color[]{Color.red, Color.green, Color.blue};
    private final List<Integer> bands;

    public RgbBands(List<Integer> list) {
        this.bands = new ArrayList<Integer>(list);
    }

    public RgbBands(int n, int n2, int n3) {
        this(Arrays.asList(n, n2, n3));
    }

    public static RgbBands fromEvinceDefaultBands(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : nArray) {
            arrayList.add(n);
        }
        return new RgbBands(arrayList);
    }

    public String toCommaSeparatedString() {
        return String.join((CharSequence)";", this.bands.stream().map(n -> n.toString()).collect(Collectors.toList()));
    }

    public String toEnviHdrString() {
        return String.format("default bands = {%s}", String.join((CharSequence)", ", this.bands.stream().map(n -> n.toString()).collect(Collectors.toList())));
    }

    public int[] getArray() {
        return this.getArray(this.bands.size());
    }

    public int[] getArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.get(i);
        }
        return nArray;
    }

    public float[] getValueArray(BandNames bandNames, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = bandNames.getValue(this.get(i));
        }
        return fArray;
    }

    public int get(int n) {
        if (n < this.bands.size()) {
            return this.bands.get(n);
        }
        if (this.bands.size() > 0) {
            return this.bands.get(this.bands.size() - 1);
        }
        return 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.bands.iterator();
    }

    public int size() {
        return this.bands.size();
    }

    public static RgbBands fromBandCount(BandCount bandCount) {
        return RgbBands.fromBandCount(bandCount, null);
    }

    public int[] getWithin(int n) {
        int[] nArray = this.getArray(3);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                nArray[i] = 0;
                continue;
            }
            if (nArray[i] < n) continue;
            nArray[i] = n - 1;
        }
        return nArray;
    }

    public static RgbBands fromBandCount(BandCount bandCount, BandNames bandNames) {
        if (bandNames != null && bandNames.size() > 0) {
            double d = RtDataFormat.toNumber(bandNames.get(0));
            double d2 = RtDataFormat.toNumber(bandNames.get(bandNames.size() - 1));
            if (d <= 458.0 && d2 >= 640.0) {
                return new RgbBands(bandNames.closestIndexOf("640"), bandNames.closestIndexOf("549"), bandNames.closestIndexOf("458"));
            }
        }
        int n = Math.min(bandCount.value, 3);
        int n2 = bandCount.value / 4;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(n2 * i + n2);
        }
        return new RgbBands(arrayList);
    }

    public static RgbBands fromCommaSeparatedString(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String[] stringArray = string.split(";");
        String[] stringArray2 = string.split(",");
        if (stringArray2.length > stringArray.length) {
            stringArray = stringArray2;
        }
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            if (string3.length() <= 0) continue;
            arrayList.add(RtDataFormat.toNumberInt(string2));
        }
        return new RgbBands(arrayList);
    }
}

