/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import java.nio.ByteOrder;
import se.prediktera.breeze.common.util.type.HdrByteOrder;

public enum RtByteOrder {
    LittleEndian(ByteOrder.LITTLE_ENDIAN),
    BigEndian(ByteOrder.BIG_ENDIAN);

    private ByteOrder byteOrder;

    private RtByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public ByteOrder getNioOrder() {
        return this.byteOrder;
    }

    public static RtByteOrder fromBreezeRuntime(String string) {
        for (RtByteOrder rtByteOrder : RtByteOrder.values()) {
            if (!rtByteOrder.toString().equalsIgnoreCase(string)) continue;
            return rtByteOrder;
        }
        throw new RuntimeException("ByteOrder not supported: " + string);
    }

    public static RtByteOrder fromHeader(HdrByteOrder hdrByteOrder) {
        if (hdrByteOrder.getOrder() == 0) {
            return LittleEndian;
        }
        return BigEndian;
    }
}

