/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class RtThreader {
    private static ExecutorService pool;
    private static int DEFAULT_NOTHREADS;
    private int nothreads = 1;

    public RtThreader() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public RtThreader(int n) {
        this.nothreads = DEFAULT_NOTHREADS < 0 ? n : DEFAULT_NOTHREADS;
        if (pool == null) {
            pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        }
    }

    public void execute(int n) {
        if (this.nothreads > 1 && n >= this.nothreads) {
            int n2 = n / this.nothreads;
            this.init(this.nothreads, n2);
            Future[] futureArray = new Future[this.nothreads - 1];
            for (int i = 0; i < this.nothreads - 1; ++i) {
                int n3 = n2 * i;
                int n4 = n2 * (i + 1);
                Thread object = new Thread(() -> {
                    try {
                        this.doOp(false, n3, n4);
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                });
                futureArray[i] = pool.submit(object);
            }
            this.doOp(true, n2 * (this.nothreads - 1), n);
            for (Future future : futureArray) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    throw new RuntimeException(exception);
                }
            }
        } else {
            this.init(1, n);
            this.doOp(true, 0, n);
        }
    }

    protected abstract void doOp(boolean var1, int var2, int var3);

    protected void init(int n, int n2) {
    }

    static {
        DEFAULT_NOTHREADS = -1;
    }
}

