/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.type;

import lombok.Generated;
import se.prediktera.breeze.common.util.IFramesToAverage;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.Resolution;
import se.prediktera.breeze.hardware.Camera;

public class Speed {
    public final float value;
    private String unit;

    public Speed(float f) {
        this(f, "mm");
    }

    public Speed(float f, String string) {
        this.value = f;
        this.unit = string;
    }

    public Speed(Resolution resolution, FrameRate frameRate, int n) {
        this(resolution.value * frameRate.value / (float)n);
    }

    public Speed(Camera camera) {
        this(camera.getResolution(), camera.getFrameRate(), IFramesToAverage.get(camera));
    }

    public Speed(Camera camera, FrameCount frameCount, float f) {
        this(new Resolution(f / (float)frameCount.value), camera.getFrameRate(), IFramesToAverage.get(camera));
    }

    public boolean equals(Object object) {
        return object instanceof Speed && ((Speed)object).value == this.value;
    }

    public String toString() {
        return RtDataFormat.toString(this.value, 4) + " " + this.unit + "/s";
    }

    public int intValue() {
        return (int)this.value;
    }

    public Speed limitByMaxSpeed(float f) {
        return new Speed(Math.min(this.value, f));
    }

    public static Speed withUnit(Camera camera, String string) {
        Speed speed = new Speed(camera);
        speed.setUnit(string);
        return speed;
    }

    @Generated
    public void setUnit(String string) {
        this.unit = string;
    }
}

