/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.xmlproperties;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import se.prediktera.breeze.common.util.RtDataFormat;

public class XmlParserHelper {
    static final DocumentBuilder documentBuilder;

    public static NodeList parseXML(File file) {
        NodeList nodeList;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            nodeList = XmlParserHelper.parseXML(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new XmlParseException(file, exception);
            }
        }
        ((InputStream)fileInputStream).close();
        return nodeList;
    }

    public static Node parseXMLRoot(File file, String ... stringArray) {
        if (!file.exists()) {
            throw new XmlFileNotFoundException(file);
        }
        NodeList nodeList = XmlParserHelper.parseXML(file);
        NodeList nodeList2 = nodeList.item(0).getChildNodes();
        Node node = nodeList2.item(0);
        if (stringArray.length > 0 && !Arrays.asList(stringArray).contains(node.getNodeName())) {
            throw new XmlInvalidRootNodeException(node.getNodeName(), stringArray);
        }
        return node;
    }

    public static NodeList parseXML(InputStream inputStream) {
        try {
            InputSource inputSource = new InputSource(inputStream);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            return (NodeList)xPath.evaluate("/", inputSource, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new RuntimeException(xPathExpressionException);
        }
    }

    public static Document createXMLdoc() {
        return documentBuilder.newDocument();
    }

    public static Element addRoot(String string, Document document) {
        return XmlParserHelper.addElement(document, string, null, document);
    }

    public static Element addElement(Node node, String string) {
        return XmlParserHelper.addElement(node, string, node.getOwnerDocument());
    }

    public static Element addElement(Node node, String string, String string2) {
        return XmlParserHelper.addElement(node, string, string2, node.getOwnerDocument());
    }

    public static Element addElement(Node node, String string, Document document) {
        return XmlParserHelper.addElement(node, string, null, document);
    }

    public static Element addElement(Node node, String string, String string2, Document document) {
        Element element = document.createElement(string);
        if (string2 != null && string2.length() > 0) {
            element.setTextContent(string2);
        }
        node.appendChild(element);
        return element;
    }

    public static boolean getBooleanAttribute(Node node, String string, boolean bl) {
        String string2 = XmlParserHelper.getAttribute(node, string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public static int getIntAttribute(Node node, String string, int n) {
        return (int)XmlParserHelper.getDoubleAttribute(node, string, n);
    }

    public static float getFloatAttribute(Node node, String string, float f) {
        String string2 = XmlParserHelper.getAttribute(node, string);
        if (string2 != null) {
            return RtDataFormat.toNumberFloat(string2);
        }
        return f;
    }

    public static double getDoubleAttribute(Node node, String string, double d) {
        String string2 = XmlParserHelper.getAttribute(node, string);
        if (string2 != null) {
            return RtDataFormat.toNumber(string2);
        }
        return d;
    }

    public static Float getFloatObjectAttribute(Node node, String string) {
        String string2 = XmlParserHelper.getAttribute(node, string);
        if (string2 != null) {
            return Float.valueOf(RtDataFormat.toNumberFloat(string2));
        }
        return null;
    }

    public static String getAttribute(Node node, String string) {
        return XmlParserHelper.getAttribute(node, string, null);
    }

    public static String getAttribute(Node node, String string, String string2) {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return string2;
    }

    public static float getFloatValue(Node node) {
        String string = node.getTextContent();
        if (string != null) {
            return RtDataFormat.toNumberFloat(string);
        }
        return -1.0f;
    }

    public static String getId(Node node) {
        return XmlParserHelper.getAttribute(node, "id");
    }

    public static String getName(Node node) {
        return XmlParserHelper.getAttribute(node, "name");
    }

    public static Node getNode(Node node, String string) {
        return XmlParserHelper.getNode(node, string, null);
    }

    public static Node getNode(Node node, String string, String string2) {
        Object object;
        Object object2 = "name";
        Object object3 = "";
        if (string2 != null) {
            object = string2.split("=");
            object3 = object[((String[])object).length - 1];
            if (((Object)object).length > 1) {
                object2 = object[0];
            }
        }
        try {
            object = node.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node2 = object.item(i);
                if (node2 == null || node2.getNodeName() == null || !node2.getNodeName().equalsIgnoreCase(string)) continue;
                if (string2 != null) {
                    Node node3;
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    if (namedNodeMap == null || (node3 = namedNodeMap.getNamedItem((String)object2)) == null || !node3.getNodeValue().equalsIgnoreCase((String)object3)) continue;
                    return node2;
                }
                return node2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static List<Node> parseChildNodes(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static boolean hasNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static List<Node> getNodeList(Node node) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(nodeList.item(i));
        }
        return arrayList;
    }

    public static List<Node> getNodeList(Node node, String string) {
        return XmlParserHelper.getNodeList(node, string, null);
    }

    public static List<Node> getNodeList(Node node, String string, String string2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2 == null || !node2.getNodeName().equalsIgnoreCase(string)) continue;
                if (string2 != null) {
                    Node node3;
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    if (namedNodeMap == null || (node3 = namedNodeMap.getNamedItem("name")) == null || !node3.getNodeValue().equalsIgnoreCase(string2)) continue;
                    arrayList.add(node2);
                    continue;
                }
                arrayList.add(node2);
            }
        }
        return arrayList;
    }

    public static Node getNodeRecursive(NodeList nodeList, String string) {
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeName().equals(string)) {
                    return node;
                }
                Node node2 = XmlParserHelper.getNodeRecursive(node.getChildNodes(), string);
                if (node2 == null) continue;
                return node2;
            }
        }
        return null;
    }

    public static Node getNode(List<Node> list, String string) {
        for (Node node : list) {
            if (!node.getNodeName().equals(string)) continue;
            return node;
        }
        return null;
    }

    public static boolean isFloatMissing(Node node) {
        String string = node.getTextContent();
        return string == null || string.length() == 0;
    }

    public static void setAttribute(Node node, String string, String string2) {
        ((Element)node).setAttribute(string, string2);
    }

    public static void setAttribute(Node node, String string, double d) {
        ((Element)node).setAttribute(string, String.valueOf(d));
    }

    public static void setAttribute(Node node, String string, int n) {
        ((Element)node).setAttribute(string, String.valueOf(n));
    }

    public static void setAttribute(Node node, String string, boolean bl) {
        ((Element)node).setAttribute(string, String.valueOf(bl));
    }

    public static void setValue(Node node, float f) {
        node.setTextContent(RtDataFormat.toStringAll(f));
    }

    public static void setValue(Node node, double d) {
        node.setTextContent(RtDataFormat.toStringAll(d));
    }

    public static void copyChildren(Node node, Element element) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = element.getOwnerDocument().importNode(nodeList.item(i), true);
            element.appendChild(node2);
        }
    }

    public static void addCDATA(Element element, String string) {
        if (string != null) {
            element.appendChild(element.getOwnerDocument().createCDATASection(string));
        }
    }

    static {
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    public static class XmlParseException
    extends RuntimeException {
        public XmlParseException(File file, Exception exception) {
            super("Error parsing file: " + file.getAbsolutePath(), exception);
        }
    }

    public static class XmlFileNotFoundException
    extends RuntimeException {
        public XmlFileNotFoundException(File file) {
            super("Xml not found: " + file.getAbsolutePath());
        }
    }

    public static class XmlInvalidRootNodeException
    extends RuntimeException {
        private final String nodeName;

        public XmlInvalidRootNodeException(String string, String[] stringArray) {
            super(String.format("Xml root node has invalid name: %s, valid alternatives: %s", string, String.join((CharSequence)", ", stringArray)));
            this.nodeName = string;
        }

        public String nodeName() {
            return this.nodeName;
        }
    }
}

