/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.main.AbstractMainPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;

public class BreezeRecycleBin {
    private static final long recycleBinWarningSize = 524288000L;

    public static boolean delete(Entry entry, Entry.EntryType entryType, boolean bl) {
        try {
            if (bl) {
                return BreezeRecycleBin.moveToRecycle(entry, entryType);
            }
            FileUtils.deleteDirectory((File)entry.getFolder());
            return true;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static boolean moveToRecycle(Entry entry, Entry.EntryType entryType) {
        File file = WorkspaceManager.getInstance().getWorkspace().getRecyclePath();
        file.mkdirs();
        File file2 = new File(file, new SimpleDateFormat("yyyyMMdd").format(new Date()));
        return BreezeRecycleBin.moveToFolder(entry.getFolder(), new File(file2, entryType.getPath(entry)));
    }

    private static boolean moveToFolder(File file, File file2) {
        try {
            if (file2.exists()) {
                FileUtils.deleteDirectory((File)file2);
            }
            file2.mkdirs();
            Files.move(Paths.get(file.getPath(), new String[0]), Paths.get(file2.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (NoSuchFileException noSuchFileException) {
            return true;
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new ErrorHandler.WarningMessageException("Cannot move directory, it is being used by another process");
        }
        catch (IOException iOException) {
            Logg.trace((String)"Failed to move", (Throwable)iOException);
            return false;
        }
    }

    public static long recycleFolderSize() {
        File file;
        WorkspaceManager.Workspace workspace = WorkspaceManager.getInstance().getWorkspace();
        if (workspace != null && (file = workspace.getRecyclePath()).exists()) {
            return BreezeRecycleBin.folderSize(file);
        }
        return 0L;
    }

    public static long folderSize(File file) {
        long l = 0L;
        for (File file2 : file.listFiles()) {
            if (file2.isFile()) {
                l += file2.length();
                continue;
            }
            l += BreezeRecycleBin.folderSize(file2);
        }
        return l;
    }

    public static void clear(final AbstractMainPanel abstractMainPanel) {
        BreezeOptionDialog.showDialog(abstractMainPanel.getFrame(), BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Empty Recycle Bin", "The recycle bin contains " + UpdateHelper.formatSize((long)BreezeRecycleBin.recycleFolderSize()) + " deleted measurements.\n\nThese can be recovered manually using File Explorer from the folder [Workspace]\\Data\\Recycled.\n\nDo you want to permanently remove all items in the Recycle?", null, breezeActionEvent -> BreezeProgressDialog.startProgress(abstractMainPanel.getFrame(), new ProgressAction(){

            @Override
            public void runAction() {
                this.setInfoText("Removing data from Recycle Bin");
                BreezeRecycleBin.clear();
                abstractMainPanel.showSelectedEntry(false);
            }
        }, "Progress"));
    }

    private static void clear() {
        File file = WorkspaceManager.getInstance().getWorkspace().getRecyclePath();
        if (file.exists()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public static boolean shouldBeEmptied() {
        return BreezeRecycleBin.recycleFolderSize() > 524288000L;
    }
}

