/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry;

import java.io.File;
import java.io.IOException;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.entry.EntryWithSave;
import se.prediktera.breeze.common.entry.ThingWithName;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.comment.CommentList;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;

public interface Entry
extends BasicEntry,
EntryWithSave,
ThingWithName {
    public CommentList getComments();

    public XmlProperties getProperties();

    @Override
    public void save();

    public File getFolder();

    default public boolean exists() {
        File file = this.getFolder();
        return file != null && file.exists();
    }

    public boolean applyChangesNeeded();

    @Override
    public String getUid();

    @Override
    public boolean delete(boolean var1);

    public File getCustomImageFile();

    @Override
    public EntryData getEntryData();

    @Override
    public boolean isGrayed();

    public void rename(String var1) throws IOException;

    public EntryType getEntryType();

    default public String formatNumberGroupsAndMeasurements() {
        if (this instanceof Measurement) {
            return StringHelper.pluralize(1, "measurement");
        }
        Entry entry = this;
        if (entry instanceof Group) {
            Group group = (Group)entry;
            return "1 group with " + StringHelper.pluralize(group.getChildCount(), "measurement");
        }
        entry = this;
        if (entry instanceof Workflow) {
            Workflow workflow = (Workflow)entry;
            return StringHelper.pluralize(workflow.getChildCount(), "group") + " and " + StringHelper.pluralize(workflow.getAllMeasurements().size(), "measurement");
        }
        return "";
    }

    public static enum EntryType {
        Workflow(1),
        Group(2),
        Measurement(3),
        Analyse(1);

        private final int steps;

        private EntryType(int n2) {
            this.steps = n2;
        }

        public String getPath(Entry entry) {
            StringBuffer stringBuffer = new StringBuffer();
            this.addPath(stringBuffer, entry.getFolder(), this.steps);
            return stringBuffer.toString();
        }

        private void addPath(StringBuffer stringBuffer, File file, int n) {
            if (n > 0) {
                this.addPath(stringBuffer, file.getParentFile(), n - 1);
            }
            stringBuffer.append(file.getName() + "/");
        }

        public String toString() {
            if (this.equals((Object)Analyse)) {
                return "Model";
            }
            return super.toString();
        }
    }
}

