/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.ListHelper;

public class EntryData {
    public static final SimpleDateFormat viewformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
    private String uid;
    private String name;
    private Date createdDate;
    private Date modifiedDate;
    private String createdBy = "N/A";
    private boolean pinnedToStartPage;
    private static String fixedDate = null;

    public static void useFixedDateForUnitTest(String string) {
        fixedDate = string;
    }

    public EntryData(BasicEntry basicEntry, String string, File file) {
        File file2;
        FileHelper.checkValidNameOrThrow(string.trim());
        this.uid = UniqueUID.getUniqueId();
        this.name = string.trim();
        if (basicEntry != null && !basicEntry.noIO() && (file2 = new File(file, this.name)).exists() && Objects.requireNonNull(file2.listFiles()).length > 0) {
            throw new RuntimeException(String.format("Entry with name %s already exist", this.name), new FileAlreadyExistsException(file2.getAbsolutePath()));
        }
        this.createdDate = this.getDateNow();
        this.modifiedDate = this.getDateNow();
        this.createdBy = BreezeProperties.getInstance().getLoginUser().getUsername();
    }

    public EntryData(String string) {
        this.name = string;
    }

    public void setAttributesAndNewName(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        this.uid = namedNodeMap.getNamedItem("id").getNodeValue();
        if (namedNodeMap.getNamedItem("createdby") != null) {
            this.setCreatedBy(namedNodeMap.getNamedItem("createdby").getNodeValue());
        }
        if (namedNodeMap.getNamedItem("createddate") != null) {
            this.setCreatedDate(namedNodeMap.getNamedItem("createddate").getNodeValue());
        }
        if (namedNodeMap.getNamedItem("modifieddate") != null) {
            this.setModifiedDate(namedNodeMap.getNamedItem("modifieddate").getNodeValue());
        }
        if (namedNodeMap.getNamedItem("pinnedToStartPage") != null) {
            this.setPinnedToStartPage(true);
        }
        if (string != null) {
            this.uid = UniqueUID.getUniqueId();
            this.name = string;
            this.setCreatedDate();
            this.setModifiedDate();
        }
    }

    private Date getDateNow() {
        if (fixedDate != null) {
            return this.parseSimpleDate(fixedDate);
        }
        return new Date();
    }

    public void reload(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap.getNamedItem("modifieddate") != null) {
            this.setModifiedDate(namedNodeMap.getNamedItem("modifieddate").getNodeValue());
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getSimpleCreatedDate() {
        if (this.createdDate == null) {
            return "NA";
        }
        return format.format(this.createdDate);
    }

    public void setUid(String string) {
        this.uid = string;
    }

    public void renewUid() {
        this.uid = UniqueUID.getUniqueId();
    }

    public String getViewCreatedDate() {
        if (this.createdDate == null) {
            return "NA";
        }
        return viewformat.format(this.createdDate);
    }

    public Date getModifiedOrCreatedDate() {
        if (this.modifiedDate != null) {
            return this.modifiedDate;
        }
        return this.createdDate;
    }

    public String getViewModifiedDate() {
        if (this.modifiedDate == null) {
            return "NA";
        }
        return viewformat.format(this.modifiedDate);
    }

    private Date parseSimpleDate(String string) {
        try {
            return format.parse(string);
        }
        catch (Exception exception) {
            return new Date();
        }
    }

    public void setCreatedBy(String string) {
        this.createdBy = string;
    }

    public void setCreatedDate() {
        this.setCreatedDate(this.getDateNow());
    }

    public void setCreatedDate(Date date) {
        this.createdDate = date;
    }

    public void setCreatedDate(String string) {
        this.setCreatedDate(this.parseSimpleDate(string));
    }

    public void setModifiedDate() {
        this.setModifiedDate(this.getDateNow());
    }

    public void setModifiedDate(Date date) {
        this.modifiedDate = date;
    }

    public void setModifiedDate(String string) {
        this.setModifiedDate(this.parseSimpleDate(string));
    }

    public void setPinnedToStartPage(String string) {
        this.setPinnedToStartPage(Boolean.parseBoolean(string));
    }

    public void setPinnedToStartPage(boolean bl) {
        this.pinnedToStartPage = bl;
    }

    public void setNameAndNewDate(String string) {
        this.name = string;
        this.createdDate = this.getDateNow();
        this.modifiedDate = this.getDateNow();
    }

    public void rename(String string, File file, File file2) throws IOException {
        String string2 = string.trim();
        Files.move(file.toPath(), new File(file2, string2).toPath(), new CopyOption[0]);
        this.name = string2;
    }

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }

    public void writeXmlAttributes(Element element, String string) {
        element.setAttribute("id", this.getUid());
        element.setAttribute("createdby", this.getCreatedBy());
        element.setAttribute("createddate", this.getSimpleCreatedDate());
        this.modifiedDate = this.getDateNow();
        element.setAttribute("modifieddate", format.format(this.modifiedDate));
        if (this.pinnedToStartPage) {
            element.setAttribute("pinnedToStartPage", "true");
        }
        if (string != null) {
            element.setAttribute("xmlns:xsi", "Prediktera.XML." + string + "Xml");
        }
    }

    public int compareTo(ListHelper.SortType sortType, EntryData entryData) {
        int n = 0;
        if (sortType.equals((Object)ListHelper.SortType.Created) && this.getCreatedDate() != null && entryData.getCreatedDate() != null) {
            n = this.getCreatedDate().compareTo(entryData.getCreatedDate());
        }
        if (sortType.equals((Object)ListHelper.SortType.Modified) && this.getModifiedDate() != null && entryData.getModifiedDate() != null) {
            n = this.getModifiedDate().compareTo(entryData.getModifiedDate());
        }
        return n != 0 ? n : this.getName().compareToIgnoreCase(entryData.getName());
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public boolean isPinnedToStartPage() {
        return this.pinnedToStartPage;
    }
}

