/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.GrayFilter;
import lombok.Generated;
import no.uib.cipr.matrix.DenseVector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationDescriptor;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.BreezeRecycleBin;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.EntryHolder;
import se.prediktera.breeze.entry.analyse.AnalyseSample;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.analyse.ModelInformation;
import se.prediktera.breeze.entry.analyse.RecordGroupHolder;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.entry.analyse.model.ClassificationModel;
import se.prediktera.breeze.entry.analyse.model.CurveSeparationModel;
import se.prediktera.breeze.entry.analyse.model.EvinceModelParameters;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.analyse.model.ModelVariableSettings;
import se.prediktera.breeze.entry.analyse.model.QuantificationModel;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.comment.CommentList;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.legacy.LegacyFileFormat;
import se.prediktera.breeze.entry.sample.SamplePredictionList;
import se.prediktera.breeze.entry.util.PPModelInfo;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.data.AnalyseDataHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.util.xmlproperties.DefaultXmlProperties;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.frontend.main.model.table.PredictionTableViewContainer;
import se.prediktera.breeze.frontend.wizard.model.AbstractModelWizard;
import se.prediktera.breeze.frontend.wizard.model.panel.ml.MachineLearningModelPanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.ml.RuntimeModelPanel;
import se.prediktera.breeze.util.ModelVersionHelper;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.predictiontable.SharedPredictionTable;

public class Analyse
extends BasicAnalyse
implements EntryHolder {
    private final EntryData entryData;
    private final RecordGroupHolder recordGroupHolder = new RecordGroupHolder(false);
    private final RecordGroupHolder externalRecordGroupHolder = new RecordGroupHolder(true);
    private AbstractModel cachedModel = null;
    private SegmentationIdentifier segmentationIdentifier = null;
    private AnalyseSample analyseSample;
    private Node cachedSetupXmlNode;
    private final CommentList comments = new CommentList();
    private final DefaultXmlProperties properties = new DefaultXmlProperties("settings");
    private BasicAnalyse.ModelMethod modelMethod;
    private ModelInformation modelInformation;

    public Analyse(String string) {
        this(string, BasicAnalyse.ModelMethod.SamplePca);
    }

    public Analyse(String string, BasicAnalyse.ModelMethod modelMethod) {
        this.modelMethod = modelMethod;
        this.entryData = new EntryData(this, string, this.getParentFolder());
        this.getProperties().setPropertyLocal("method", modelMethod.name());
    }

    public Analyse(File file) {
        this(file, null);
    }

    public Analyse(File file, String string) {
        File file2 = new LegacyFileFormat.AnalyseLegacyFileFormat().renameIfNeeded(file);
        this.entryData = new EntryData(file2.getName());
        Node node = XmlParserHelper.parseXMLRoot(this.getXml(), "model", "workflow");
        this.entryData.setAttributesAndNewName(node, string);
        this.parse(node);
    }

    public void reload() {
        this.comments.clear();
        this.factorHolder.clear();
        this.cachedSetupXmlNode = null;
        this.modelInformation = null;
        this.recordGroupHolder.clear();
        this.externalRecordGroupHolder.clear();
        this.clearCachedModel();
        File file = new File(this.getFolder(), "model.xml");
        Node node = XmlParserHelper.parseXMLRoot(file, "model", "workflow");
        this.parse(node);
    }

    private void parse(Node node) {
        boolean bl = false;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName().toLowerCase();
            if (string.equals("comments")) {
                this.comments.parseComments(node2);
                continue;
            }
            if (string.equals("settings")) {
                this.properties.setRootProperty(node2);
                bl = true;
                continue;
            }
            if (string.equals("variables")) {
                this.factorHolder.parseVariables(node2);
                continue;
            }
            if (string.equals("setup")) {
                this.cachedSetupXmlNode = node2;
                continue;
            }
            if (string.equals(this.recordGroupHolder.getXmlNodeType())) {
                this.recordGroupHolder.parse(node2);
                continue;
            }
            if (!string.equals(this.externalRecordGroupHolder.getXmlNodeType())) continue;
            this.externalRecordGroupHolder.parse(node2);
        }
        this.modelMethod = PPModelInfo.fromAnalyseProperties(this);
        this.modelInformation = ModelInformation.parse(this.cachedSetupXmlNode, this.modelMethod);
        XmlProperties.ensureThatSettingsExists(this.getProperties(), node, bl);
    }

    public Analyse createDuplicateAndSave(String string) {
        Analyse analyse = new Analyse(this.getFolder(), string);
        analyse.save();
        Analyse.copyFileIfExists(this.getProjectFile(), analyse.getProjectFile());
        Analyse.copyFileIfExists(this.getOnnxFile(), analyse.getOnnxFile());
        return analyse;
    }

    private static void copyFileIfExists(File file, File file2) {
        if (file.exists()) {
            FileUtils.copyFile((File)file, (File)file2);
        }
    }

    @Override
    public File getFolder() {
        return new File(this.getParentFolder(), this.getName());
    }

    protected File getParentFolder() {
        return WorkspaceManager.getInstance().getWorkspace().getModelPath();
    }

    @Override
    public File getXml() {
        return new File(this.getFolder(), "model.xml");
    }

    @Override
    public boolean delete(boolean bl) {
        return BreezeRecycleBin.delete(this, Entry.EntryType.Analyse, bl);
    }

    public AnalyseSpectralGroup.AnalyseSpectralGroups getGroups(boolean bl) {
        if (bl) {
            return this.getExternalGroups();
        }
        return this.getGroups();
    }

    public AnalyseSpectralGroup.AnalyseSpectralGroups getGroups() {
        return this.recordGroupHolder.getGroups();
    }

    public AnalyseSpectralGroup.AnalyseSpectralGroups getExternalGroups() {
        return this.externalRecordGroupHolder.getGroups();
    }

    public Workflow getWorkflow() {
        Workflow workflow = this.getWorkflowElseNull();
        if (workflow != null) {
            return workflow;
        }
        throw new RuntimeException("Cannot find Project for analysis " + this.getName());
    }

    public Workflow getWorkflowElseNull() {
        this.checkFullyParsed();
        Group group = this.getFirstGroup();
        if (group != null) {
            return group.getParent();
        }
        return BreezeMasterCache.getInstance().getStudyList().byId(this.getStudyId());
    }

    public Group getFirstGroup() {
        return AnalyseSpectralGroup.getFirstGroup(this.getGroups());
    }

    @Override
    public BasicAnalyse.ModelMethod getModelMethod() {
        return this.modelMethod;
    }

    public void setModelMethod(BasicAnalyse.ModelMethod modelMethod) {
        this.modelMethod = modelMethod;
        this.getProperties().setPropertyLocal("method", modelMethod.toString());
    }

    public AbstractModel getBaseModel(ProgressManager progressManager) {
        if (this.cachedModel == null) {
            this.cachedModel = this.getModels(progressManager).getFirst();
        }
        return this.cachedModel;
    }

    public synchronized List<AbstractModel> getModels(ProgressManager progressManager) {
        File file = this.getProjectFile();
        if (!file.exists()) {
            throw new ModelFileNotFoundException("No model project found at " + file.getAbsolutePath());
        }
        AbstractModel[] abstractModelArray = EvinceScriptCommands.loadModels((ProgressManager)progressManager, (String)file.getAbsolutePath());
        Logg.trace((String)"EvinceScriptCommands.loadModels(pManager, {}) returned {}", (Object[])new Object[]{file.getAbsolutePath(), abstractModelArray});
        if (abstractModelArray.length == 0) {
            throw new ModelFileNotFoundException("No model found in project at " + file.getAbsolutePath());
        }
        return Arrays.asList(abstractModelArray);
    }

    public boolean hasModel() {
        return this.getProjectFile().exists();
    }

    public void clearCachedModel() {
        if (this.cachedModel != null) {
            DataSet dataSet = this.cachedModel.getDataSet();
            if (dataSet != null && !dataSet.isCleaned()) {
                dataSet.close();
            }
            this.cachedModel = null;
        }
        this.segmentationIdentifier = null;
        this.analyseSample = null;
    }

    public File getProjectFile() {
        return new File(this.getFolder(), "model.map");
    }

    public File getOnnxFile() {
        return new File(this.getFolder(), "model.onnx");
    }

    public File getModelDataFile() {
        return new File(this.getFolder(), "model.data");
    }

    @Override
    public void save() {
        this.save(null);
    }

    public void save(Model model) {
        Document document = XmlParserHelper.createXMLdoc();
        Element element = XmlParserHelper.addRoot("model", document);
        this.entryData.writeXmlAttributes(element, "Model");
        XmlProperties.addProperties(this.getProperties(), document, element);
        this.getComments().addComments(element);
        this.factorHolder.addVariableDef(element);
        Element element2 = XmlParserHelper.addElement(element, "setup");
        if (model != null) {
            model.saveXml(element2);
        } else if (this.cachedSetupXmlNode != null) {
            XmlParserHelper.copyChildren(this.cachedSetupXmlNode, element2);
        }
        this.cachedSetupXmlNode = element2;
        this.getRecordGroupHolder().save(element);
        this.getExternalRecordGroupHolder().save(element);
        XmlProperties.createDirectoriesAndOutputXML(this.getXml(), document);
    }

    @Override
    public boolean isGrayed() {
        return !this.getProjectFile().exists();
    }

    @Override
    public FactorHolder getFactorHolder() {
        return this.factorHolder;
    }

    public void setDefaultProperties(Workflow workflow) {
        if (this.getModelMethod().equals((Object)BasicAnalyse.ModelMethod.SamplePca)) {
            this.getDefaultReduce();
            this.getDefaultNumberOfSamples();
        }
        this.isDefault(Model.Transformation.SNV);
        this.getDefaultExcludeBeginningPercent(workflow);
        this.getDefaultExcludeEndPercent(workflow);
    }

    public int getDefaultReduce() {
        return this.getProperties().getPropertyIntLocal("modelling/reduce", 0);
    }

    public int getDefaultNumberOfSamples() {
        int n = BreezeProperties.getInstance().getModellingDefaultNumberOfSamplesToInclude();
        return this.getProperties().getPropertyIntLocal("modelling/numberOfSamplesToInclude", n);
    }

    public boolean isDefault(Model.Transformation transformation) {
        return this.getProperties().getPropertyBoolLocal("modelling/" + transformation.getXmlName(), this.getModelMethod().isDefault(transformation));
    }

    public double getDefaultExcludeBeginningPercent(Workflow workflow) {
        double d = workflow != null ? workflow.getModellingDefaultExcludeWavelengthsBeginningPercent() : BreezeProperties.getInstance().getModellingDefaultExcludeWavelengthsBeginningPercent();
        return this.getProperties().getPropertyDoubleLocal("modelling/excludeWavelengthsBeginningPercent", d);
    }

    public double getDefaultExcludeEndPercent(Workflow workflow) {
        double d = workflow != null ? workflow.getModellingDefaultExcludeWavelengthsEndPercent() : BreezeProperties.getInstance().getModellingDefaultExcludeWavelengthsEndPercent();
        return this.getProperties().getPropertyDoubleLocal("modelling/excludeWavelengthsEndPercent", d);
    }

    public Node getSetupXmlNode() {
        return this.cachedSetupXmlNode;
    }

    @Override
    public CommentList getComments() {
        return this.comments;
    }

    @Override
    public XmlProperties getProperties() {
        return this.properties;
    }

    public SegmentationIdentifier getSegmentationIdentifier() {
        if (this.segmentationIdentifier == null) {
            this.segmentationIdentifier = ModelVariableSettings.parseSegmentationIdentifier(this.getSetupXmlNode());
        }
        return this.segmentationIdentifier;
    }

    @Override
    public String getName() {
        return this.entryData.getName();
    }

    @Override
    public EntryData getEntryData() {
        return this.entryData;
    }

    @Override
    public String getUid() {
        return this.entryData.getUid();
    }

    @Override
    public String getVersion() {
        String string = this.properties.getPropertyLocal("modelling/versionUid", "");
        if (string.equals("")) {
            string = UniqueUID.getUniqueId();
            this.setVersion(string);
            this.save();
        }
        return string;
    }

    public void setVersion(String string) {
        this.properties.setPropertyLocal("modelling/versionUid", string);
    }

    public int getVersionIndex() {
        return this.properties.getPropertyIntLocal("modelling/version", 1);
    }

    public void setVersionIndex(int n) {
        this.properties.setPropertyLocal("modelling/version", String.valueOf(n));
    }

    public String toString() {
        return this.entryData.toString();
    }

    @Override
    public boolean applyChangesNeeded() {
        return false;
    }

    @Override
    public File getCustomImageFile() {
        return new FileUrl(this.getCustomImageURL());
    }

    public Image getIcon() {
        BufferedImage bufferedImage = ImageHelper.read(this.getCustomImageURL());
        if (this.isGrayed()) {
            return GrayFilter.createDisabledImage(bufferedImage);
        }
        return bufferedImage;
    }

    private URL getCustomImageURL() {
        return this.getClass().getResource("/images/model/" + String.valueOf((Object)this.getModelMethod().getType()) + ".png");
    }

    @Override
    public void rename(String string) throws IOException {
        this.entryData.rename(string, this.getFolder(), this.getParentFolder());
        this.clearCachedModel();
    }

    public Collection<BasicWorkflow> getAssociatedStudies() {
        return BreezeMasterCache.getInstance().getStudyList().workflowsAssociatedToAnalyse(this);
    }

    public Collection<BasicWorkflow> getAssociatedWorkflows() {
        return BreezeMasterCache.getInstance().getWorkflowList().workflowsAssociatedToAnalyse(this);
    }

    public void setStudyId(String string) {
        this.getProperties().setPropertyLocal("studyId", string);
    }

    @Override
    public String getStudyId() {
        return this.getProperties().getPropertyLocal("studyId", "");
    }

    @Override
    public boolean partOfStudy(String string) {
        return super.partOfStudy(string) || this.getRecordGroupHolder().partOfStudy(string);
    }

    public void setParentId(String string) {
        this.getProperties().setPropertyLocal("parentId", string);
    }

    public String getParentId() {
        return this.getProperties().getPropertyLocal("parentId", null);
    }

    public void setClassId(String string) {
        this.getProperties().setPropertyLocal("classId", string);
    }

    public String getClassId() {
        return this.getProperties().getPropertyLocal("classId", null);
    }

    @Override
    public void checkFullyParsed() {
        this.getRecordGroupHolder().setGroupFromWorkflow();
        this.getExternalRecordGroupHolder().setGroupFromWorkflow();
    }

    @Override
    public RtModelParameters getModelParameters(BreezeProgress breezeProgress, Workflow workflow) {
        if (breezeProgress instanceof ProgressManager) {
            return new EvinceModelParameters(breezeProgress, workflow, this);
        }
        return new EvinceModelParameters(BreezeProgressManager.createEmpty(), workflow, this);
    }

    public Pair<String, String> getTopRuntimeMLResults() {
        List<AbstractRuntimeModel.RuntimeResult> list = new AbstractRuntimeModel.RuntimeResultList((Node)this.getSetupXmlNode()).results;
        if (list.isEmpty()) {
            return Pair.of((Object)"NO RESULT", (Object)"-1");
        }
        return Pair.of((Object)list.getFirst().toString(), (Object)RtDataFormat.toPercent(list.getFirst().accuracy.getFirst()));
    }

    public Image createRatingImage(int n, int n2, boolean bl) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(BreezeType.Analyse.getColor());
        graphics2D.fillRect(0, 0, n, n2);
        double d = bl ? 2.0 : 0.8;
        Font font = graphics2D.getFont();
        graphics2D.setFont(new Font(font.getName(), font.getStyle(), (int)(40.0 * d)));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        graphics2D.setColor(Color.white);
        String string = "" + (int)this.getRating();
        int n4 = fontMetrics.stringWidth(string);
        graphics2D.drawString(string, n / 2 - n4 / 2, n2 / 2 + (int)((double)n3 / 3.3));
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Model parseModel(BreezeProgress breezeProgress, Analyse analyse, AbstractModel abstractModel) {
        BasicAnalyse.ModelMethod modelMethod = analyse.getModelMethod();
        switch (modelMethod) {
            case QuantificationPls: {
                return new QuantificationModel(breezeProgress, analyse, abstractModel);
            }
            case ClassificationPlsDa: {
                return new ClassificationModel(breezeProgress, analyse, abstractModel);
            }
            case ClassificationCurveSeparation: {
                return new CurveSeparationModel(breezeProgress, analyse, abstractModel);
            }
        }
        return null;
    }

    public void updateModel(BreezeProgressManager breezeProgressManager) {
        this.autoReTrain(breezeProgressManager, false, false, false);
    }

    public void autoReTrain(BreezeProgressManager breezeProgressManager, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        ModelVersionHelper.archiveModelFiles(this, breezeProgressManager);
        Workflow workflow = this.getWorkflow();
        Object object2 = this.getFactor();
        if (object2 instanceof CategoryFactor) {
            object = (CategoryFactor)object2;
            object2 = (CategoryFactor)workflow.getFactorHolder().getFactorByUid(((Factor)object).getOrigUid());
            if (object2 != null) {
                this.getFactorHolder().replace((Factor)object, this.cloneForModel(workflow, (Factor)object2, this.getSegmentationIdentifier().Level));
            }
        }
        if (bl && (object2 = ((ModelProperties)(object = new ModelProperties(this))).getProperty("components")) != null) {
            ((ModelProperties)object).removeProperty((ModelProperties.Property)object2);
            ((ModelProperties)object).updateAnalyseProperties(this);
        }
        if ((object = AbstractModelWizard.createModel(breezeProgressManager, this, this.getVariables())) instanceof Model.ModelWithSample) {
            object2 = (Model.ModelWithSample)object;
            object2.createModel(breezeProgressManager);
            if (bl2) {
                object2.balanceTrainData(breezeProgressManager, bl3, false);
            }
            if (object instanceof AbstractRuntimeModel) {
                AbstractRuntimeModel abstractRuntimeModel = (AbstractRuntimeModel)object;
                if (bl) {
                    File file;
                    Object object3;
                    if (StringUtils.isNotEmpty((CharSequence)abstractRuntimeModel.getRuntimeSettings().scriptFile)) {
                        object3 = MachineLearningModelPanelStep.trainUsingExternalScriptFile(breezeProgressManager, abstractRuntimeModel, abstractRuntimeModel.getRuntimeSettings().scriptFile, abstractRuntimeModel.getRuntimeSettings().interpreter, abstractRuntimeModel.getRuntimeSettings().customInterpreter);
                        if (!((File)object3.getLeft()).exists()) {
                            throw new ErrorHandler.WarningMessageException("No trained model file found");
                        }
                        file = (File)object3.getLeft();
                    } else {
                        file = RuntimeModelPanel.trainModel(breezeProgressManager, this, abstractRuntimeModel, BreezeFrame.getInstance());
                    }
                    object3 = new File(this.getFolder(), "model.onnx");
                    Files.copy(file.toPath(), ((File)object3).toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            this.calculateAndSaveCorrectlyClassified(breezeProgressManager);
            object.finishAndSave(breezeProgressManager);
            DataSetCache.clear(this);
            this.clearCachedModel();
        }
    }

    private AnalyseSample getAnalyseSample() {
        if (this.analyseSample == null) {
            this.analyseSample = new AnalyseSample(this);
        }
        return this.analyseSample;
    }

    public Factor cloneForModel(Workflow workflow, Factor factor, int n) {
        Object f = factor.cloneStoreId();
        if (this.getModelMethod().isClassification()) {
            CategoryFactor categoryFactor = this.getCategoryFactors().getByOrigUid(((Factor)f).getOrigUid());
            if (categoryFactor != null) {
                ((CategoryFactor)f).syncAnalyseFactor(categoryFactor);
                ((Factor)f).setUid(categoryFactor.getUid());
                this.getAnalyseSample().updateIncludedClasses(workflow, (CategoryFactor)f, n);
            }
        } else {
            PropertyFactor propertyFactor = this.getPropertyFactors().getByOrigUid(((Factor)f).getOrigUid());
            if (propertyFactor != null) {
                ((Factor)f).setUid(propertyFactor.getUid());
            }
        }
        return f;
    }

    @Override
    public AnalyseSample.SampleIncluded sampleIncluded(BasicSample basicSample) {
        return this.getAnalyseSample().sampleIncluded(basicSample);
    }

    @Override
    public void sampleIncluded(BasicSample basicSample, boolean bl, boolean bl2) {
        this.getAnalyseSample().sampleIncluded(basicSample, bl, bl2);
    }

    public AnalyseSample.SampleIndex sampleIndex(BasicSample basicSample) {
        return this.getAnalyseSample().sampleIndex(basicSample);
    }

    public List<FactorOrDescriptor> getVariables() {
        BasicAnalyse.ModelMethod modelMethod = this.getModelMethod();
        if (modelMethod.isQuantification()) {
            return this.getPropertyFactors().getList();
        }
        if (modelMethod.isClassification()) {
            return Collections.singletonList(this.getCategoryFactor());
        }
        return null;
    }

    public DescriptorTreeNode createClassificationDescriptor() {
        DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)FunctionHelper.createNew(new PlsPredClassificationDescriptor.Info());
        PlsPredClassificationDescriptor plsPredClassificationDescriptor = (PlsPredClassificationDescriptor)descriptorTreeNode.getFunction();
        plsPredClassificationDescriptor.setAnalyse(this);
        plsPredClassificationDescriptor.setFactor(this.getCategoryFactor());
        return descriptorTreeNode;
    }

    @Override
    public String getFormatedRating() {
        double d = this.getRating();
        if (d > 0.0) {
            return String.valueOf((int)Math.round(100.0 * d));
        }
        return null;
    }

    public double getRating() {
        List<AbstractRuntimeModel.RuntimeResult> list;
        double d = this.getCorrectlyClassified();
        if (d > 0.0) {
            return d;
        }
        if (this.getModelMethod().isRuntime() && !(list = new AbstractRuntimeModel.RuntimeResultList((Node)this.getSetupXmlNode()).results).isEmpty()) {
            return list.getFirst().accuracy.getFirst();
        }
        double d2 = this.getQ2y();
        if (d2 > 0.0) {
            return d2;
        }
        double d3 = this.getR2y();
        if (d3 > 0.0) {
            return d3;
        }
        return this.getR2x();
    }

    public void addModelPropertiesToAnalyse(AbstractModel abstractModel) {
        Object object;
        DenseVector denseVector;
        DenseVector denseVector2;
        ModelMatrix modelMatrix = (ModelMatrix)abstractModel.getMatrixByName("q2y_cum");
        if (modelMatrix != null && (denseVector2 = modelMatrix.getLastRM()) != null && denseVector2.size() > 0) {
            this.getProperties().setPropertyLocal("rating/q2y", RtDataFormat.toString(denseVector2.get(0)));
        }
        if ((denseVector2 = (ModelMatrix)abstractModel.getMatrixByName("r2x_cum")) != null && (denseVector = denseVector2.getLastRM()) != null && denseVector.size() > 0) {
            this.getProperties().setPropertyLocal("rating/r2x", RtDataFormat.toString(denseVector.get(0)));
        }
        if ((denseVector = (ModelMatrix)abstractModel.getMatrixByName("r2y_cum")) != null && (object = denseVector.getLastRM()) != null && object.size() > 0) {
            this.getProperties().setPropertyLocal("rating/r2y", RtDataFormat.toString(object.get(0)));
        }
        this.getProperties().setPropertyLocal("rating/components", RtDataFormat.toString(abstractModel.getComponentsInt()));
        object = this.getWorkflow();
        if (object != null) {
            this.setConvertTo(((Workflow)object).getReferenceConvertTo());
        }
    }

    public void calculateAndSaveCorrectlyClassified(BreezeProgressManager breezeProgressManager) {
        if (this.getModelMethod().isClassification()) {
            AnalyseDataHelper.PredictionDataSource predictionDataSource = AnalyseDataHelper.createPredictionDataSource(breezeProgressManager, this, PredictionTableViewContainer.ClassificationViewType.Train);
            SamplePredictionList samplePredictionList = predictionDataSource.getSamplePredictionList();
            double d = 0.0;
            if (samplePredictionList.size() > 0) {
                SharedPredictionTable sharedPredictionTable = samplePredictionList.createPredictionMatrix();
                d = (double)sharedPredictionTable.getCorrectly() / (double)sharedPredictionTable.getTotal();
            }
            this.getProperties().setPropertyLocal("rating/correctly", RtDataFormat.toString(d));
            this.save();
        }
    }

    public double getCorrectlyClassified() {
        return this.getProperties().getPropertyDoubleLocal("rating/correctly", 0.0);
    }

    public double getQ2y() {
        return this.getProperties().getPropertyDoubleLocal("rating/q2y", 0.0);
    }

    public double getR2x() {
        return this.getProperties().getPropertyDoubleLocal("rating/r2x", 0.0);
    }

    public double getR2y() {
        return this.getProperties().getPropertyDoubleLocal("rating/r2y", 0.0);
    }

    public int getComponents() {
        return this.getProperties().getPropertyIntLocal("rating/components", 0);
    }

    @Override
    public RtFramePredictor.ReferenceConvertTo getConvertTo() {
        String string = this.getConvertToProperty();
        if (string.length() > 0) {
            return RtFramePredictor.ReferenceConvertTo.parse(string);
        }
        Workflow workflow = this.getWorkflowElseNull();
        if (workflow != null) {
            return workflow.getReferenceConvertTo();
        }
        return null;
    }

    public String getConvertToProperty() {
        return this.getProperties().getPropertyLocal("modelling/convertTo", "");
    }

    public void setConvertTo(RtFramePredictor.ReferenceConvertTo referenceConvertTo) {
        this.getProperties().setPropertyLocal("modelling/convertTo", referenceConvertTo.name().toLowerCase());
    }

    public List<ModelProperties.TransformationProperties> getTransformations() {
        ModelProperties modelProperties = new ModelProperties(this);
        ArrayList<ModelProperties.TransformationProperties> arrayList = new ArrayList<ModelProperties.TransformationProperties>();
        for (Model.Transformation transformation : Model.Transformation.values()) {
            boolean bl = modelProperties.getPropertyBool(transformation.getXmlName(), false);
            if (!bl) continue;
            String string = modelProperties.getProperty(transformation.getXmlName() + "_properties", "");
            arrayList.add(new ModelProperties.TransformationProperties(transformation, bl, string));
        }
        return arrayList;
    }

    @Override
    public Entry.EntryType getEntryType() {
        return Entry.EntryType.Analyse;
    }

    public static List<Analyse> getAnalysis(List<Object> list) {
        ArrayList<Analyse> arrayList = new ArrayList<Analyse>();
        for (Object object : list) {
            arrayList.addAll(Analyse.getAnalysis(object));
        }
        return arrayList;
    }

    public static List<Analyse> getAnalysis(Object object) {
        if (object instanceof Analyse) {
            return List.of((Analyse)object);
        }
        return new ArrayList<Analyse>();
    }

    @Generated
    public RecordGroupHolder getRecordGroupHolder() {
        return this.recordGroupHolder;
    }

    @Generated
    public RecordGroupHolder getExternalRecordGroupHolder() {
        return this.externalRecordGroupHolder;
    }

    @Generated
    public void setCachedModel(AbstractModel abstractModel) {
        this.cachedModel = abstractModel;
    }

    @Generated
    public AbstractModel getCachedModel() {
        return this.cachedModel;
    }

    @Generated
    public ModelInformation getModelInformation() {
        return this.modelInformation;
    }

    public static class ModelFileNotFoundException
    extends RuntimeException {
        public ModelFileNotFoundException(String string) {
            super(string);
        }
    }

    public static class FileUrl
    extends File {
        private final URL url;

        public FileUrl(URL uRL) {
            super(uRL.getPath());
            this.url = uRL;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Generated
        public URL getUrl() {
            return this.url;
        }
    }
}

