/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.analyse.model.ModelIncludedSamplesSettings;
import se.prediktera.breeze.entry.analyse.model.UidIndex;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectSamplePanelStep;
import se.prediktera.breeze.util.CompactIntegerList;

public class AnalyseSample {
    private final UidIndex.UidIndexList includeList;
    private final UidIndex.UidIndexList testList;
    private final Analyse analyse;
    private static final Color bothColor = new Color(70, 205, 197);

    public AnalyseSample(Analyse analyse) {
        this.analyse = analyse;
        this.includeList = ModelIncludedSamplesSettings.parse(analyse.getSetupXmlNode(), "sample");
        this.testList = ModelIncludedSamplesSettings.parse(analyse.getSetupXmlNode(), "test");
    }

    public SampleIncluded sampleIncluded(BasicSample basicSample) {
        if (basicSample == null) {
            return SampleIncluded.None;
        }
        Sample sample = (Sample)basicSample;
        Measurement measurement = sample.measurement();
        Integer n = this.analyse.getSegmentationIdentifier().Level;
        int n2 = sample.getSegmentationLevel();
        UidIndex.UidIndexSegMap uidIndexSegMap = this.includeList.getUidIndexSegMap(measurement.getUid());
        UidIndex.UidIndexSegMap uidIndexSegMap2 = this.testList.getUidIndexSegMap(measurement.getUid());
        if (n2 == n) {
            String string = sample.getSegmentationHashId();
            UidIndex uidIndex = uidIndexSegMap.getOrDefault(string);
            UidIndex uidIndex2 = uidIndexSegMap2.getOrDefault(string);
            int n3 = sample.getIndex(string);
            if (uidIndex != null && uidIndex.hasIndex(n3)) {
                if (uidIndex2 != null && uidIndex2.hasIndex(n3)) {
                    return SampleIncluded.AllTest;
                }
                return SampleIncluded.AllTrain;
            }
        } else if (n2 == n - 1) {
            int n4 = 0;
            int n5 = 0;
            for (BasicSample basicSample2 : sample.getChildList()) {
                String string = basicSample2.getSegmentationHashId();
                UidIndex uidIndex = uidIndexSegMap.getOrDefault(string);
                UidIndex uidIndex3 = uidIndexSegMap2.getOrDefault(string);
                int n6 = basicSample2.getIndex(string);
                if (uidIndex == null || !uidIndex.hasIndex(n6)) continue;
                ++n4;
                if (uidIndex3 == null || !uidIndex3.hasIndex(n6)) continue;
                ++n5;
            }
            if (n4 > 0) {
                if (n4 == sample.getChildCount()) {
                    if (n5 == 0) {
                        return SampleIncluded.AllTrain;
                    }
                    if (n5 == n4) {
                        return SampleIncluded.AllTest;
                    }
                    return SampleIncluded.PartialBoth;
                }
                if (n5 == 0) {
                    return SampleIncluded.PartialTrain;
                }
                if (n5 == n4) {
                    return SampleIncluded.PartialTest;
                }
                return SampleIncluded.PartialBoth;
            }
        }
        return SampleIncluded.None;
    }

    public void sampleIncluded(BasicSample basicSample, boolean bl, boolean bl2) {
        Object object;
        Sample sample = (Sample)basicSample;
        Node node = this.analyse.getSetupXmlNode();
        Measurement measurement = sample.measurement();
        String string = measurement.getUid();
        if (bl && !((AnalyseSpectralGroup.AnalyseSpectralGroups)(object = this.analyse.getGroups())).hasGroup(measurement.getParent())) {
            ((AnalyseSpectralGroup.AnalyseSpectralGroups)object).addGroup(measurement.getParent());
        }
        object = this.includeList.getUidIndexSegMap(string);
        UidIndex.UidIndexSegMap uidIndexSegMap = this.testList.getUidIndexSegMap(string);
        Integer n = this.analyse.getSegmentationIdentifier().Level;
        int n2 = sample.getSegmentationLevel();
        if (n2 == n) {
            this.sampleIncluded(bl, bl2, sample, string, (UidIndex.UidIndexSegMap)object, uidIndexSegMap);
        } else if (n2 == n - 1) {
            for (BasicSample basicSample2 : sample.getChildList()) {
                this.sampleIncluded(bl, bl2, basicSample2, string, (UidIndex.UidIndexSegMap)object, uidIndexSegMap);
            }
        }
        AnalyseSample.updateIncludedSamples(node, "sample", this.includeList);
        AnalyseSample.updateIncludedSamples(node, "test", this.testList);
        this.analyse.save();
    }

    private void sampleIncluded(boolean bl, boolean bl2, BasicSample basicSample, String string, UidIndex.UidIndexSegMap uidIndexSegMap, UidIndex.UidIndexSegMap uidIndexSegMap2) {
        String string2 = basicSample.getSegmentationHashId();
        int n = basicSample.getIndex(string2);
        UidIndex uidIndex = uidIndexSegMap.getOrDefault(string2);
        UidIndex uidIndex2 = uidIndexSegMap2.getOrDefault(string2);
        if (bl) {
            if (bl2) {
                if (uidIndex2 != null) {
                    uidIndex2.removeIndex(n);
                }
            } else {
                if (uidIndex2 == null) {
                    uidIndex2 = new UidIndex(string, string2);
                    this.testList.add(uidIndex2);
                    uidIndexSegMap2.put(string2, uidIndex2);
                }
                if (!uidIndex2.hasIndex(n)) {
                    uidIndex2.addIndex(n);
                }
            }
            if (uidIndex == null) {
                uidIndex = new UidIndex(string, string2);
                this.includeList.add(uidIndex);
                uidIndexSegMap.put(string2, uidIndex);
            }
            if (!uidIndex.hasIndex(n)) {
                uidIndex.addIndex(n);
            }
        } else {
            if (uidIndex != null) {
                uidIndex.removeIndex(n);
            }
            if (uidIndex2 != null) {
                uidIndex2.removeIndex(n);
            }
        }
    }

    public SampleIndex sampleIndex(BasicSample basicSample) {
        SampleIndex sampleIndex = new SampleIndex(new ArrayList<Integer>(), new ArrayList<Integer>());
        if (basicSample == null) {
            return sampleIndex;
        }
        Sample sample = (Sample)basicSample;
        Measurement measurement = sample.measurement();
        Integer n = this.analyse.getSegmentationIdentifier().Level;
        int n2 = sample.getSegmentationLevel();
        UidIndex.UidIndexSegMap uidIndexSegMap = this.includeList.getUidIndexSegMap(measurement.getUid());
        UidIndex.UidIndexSegMap uidIndexSegMap2 = this.testList.getUidIndexSegMap(measurement.getUid());
        if (n2 == n) {
            String string = sample.getSegmentationHashId();
            UidIndex uidIndex = uidIndexSegMap.getOrDefault(string);
            UidIndex uidIndex2 = uidIndexSegMap2.getOrDefault(string);
            int n3 = sample.getIndex(string);
            if (uidIndex != null && uidIndex.hasIndex(n3)) {
                if (uidIndex2 != null && uidIndex2.hasIndex(n3)) {
                    sampleIndex.test.add(n3);
                } else {
                    sampleIndex.train.add(n3);
                }
            }
        } else if (n2 == n - 1) {
            for (BasicSample basicSample2 : sample.getChildList()) {
                String string = basicSample2.getSegmentationHashId();
                UidIndex uidIndex = uidIndexSegMap.getOrDefault(string);
                UidIndex uidIndex3 = uidIndexSegMap2.getOrDefault(string);
                int n4 = basicSample2.getIndex(string);
                if (uidIndex == null || !uidIndex.hasIndex(n4)) continue;
                if (uidIndex3 != null && uidIndex3.hasIndex(n4)) {
                    sampleIndex.test.add(n4);
                    continue;
                }
                sampleIndex.train.add(n4);
            }
        }
        return sampleIndex;
    }

    private static void updateIncludedSamples(Node node, String string, List<UidIndex> list) {
        Node node2 = XmlParserHelper.getNodeRecursive(node.getChildNodes(), string + "s");
        NodeList nodeList = node2.getChildNodes();
        int n = 0;
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            node2.removeChild(nodeList.item(i));
        }
        for (UidIndex uidIndex : list) {
            CompactIntegerList compactIntegerList = new CompactIntegerList();
            for (Integer n2 : uidIndex.getIndexList()) {
                compactIntegerList.add(n2);
                ++n;
            }
            if (!compactIntegerList.hasData()) continue;
            Element element = XmlParserHelper.addElement(node2, string, compactIntegerList.toString());
            element.setAttribute("uid", uidIndex.getUid());
            element.setAttribute("seg", uidIndex.getSeg());
        }
        XmlParserHelper.setAttribute(node2, "number", n);
    }

    public void updateIncludedClasses(Workflow workflow, CategoryFactor categoryFactor, int n) {
        if (categoryFactor.isAllIncluded()) {
            return;
        }
        UidIndex.UidIndexList uidIndexList = this.includeList;
        for (Measurement measurement : workflow.getAllMeasurements()) {
            UidIndex.UidIndexSegMap uidIndexSegMap = uidIndexList.getUidIndexSegMap(measurement.getUid());
            if (uidIndexSegMap == null) continue;
            for (Sample sample : measurement.getSamples(n)) {
                CatClass catClass;
                Float f;
                String string = sample.getSegmentationHashId();
                UidIndex uidIndex = uidIndexSegMap.getOrDefault(string);
                if (uidIndex == null || !uidIndex.hasIndex(sample.getIndex(string)) || (f = sample.getSampleValues().getValue(categoryFactor)) == null || (catClass = categoryFactor.getClassByValueIdx(f.intValue())) == null || catClass.isIncluded()) continue;
                catClass.setIncluded(true);
            }
        }
    }

    public static enum SampleIncluded {
        None(false, false, false),
        PartialTrain(true, false, false),
        AllTrain(true, false, true),
        PartialTest(false, true, false),
        AllTest(false, true, true),
        PartialBoth(true, true, false);

        public boolean train;
        public boolean test;
        public boolean all;

        private SampleIncluded(boolean bl, boolean bl2, boolean bl3) {
            this.train = bl;
            this.test = bl2;
            this.all = bl3;
        }

        public String format() {
            return switch (this.ordinal()) {
                case 4 -> "Test";
                case 2 -> "Train";
                case 5 -> "(Train/Test)";
                case 3 -> "(Test)";
                case 1 -> "(Train)";
                default -> "";
            };
        }

        public Color color() {
            return switch (this.ordinal()) {
                case 2 -> SelectSamplePanelStep.TrainTestClass.trainColor;
                case 1 -> SelectSamplePanelStep.TrainTestClass.trainColor;
                case 4 -> SelectSamplePanelStep.TrainTestClass.testColor;
                case 3 -> SelectSamplePanelStep.TrainTestClass.testColor;
                case 5 -> bothColor;
                default -> null;
            };
        }

        public int type() {
            if (this.train) {
                return 1;
            }
            if (this.test) {
                return 2;
            }
            return 0;
        }
    }

    public record SampleIndex(List<Integer> train, List<Integer> test) {
    }
}

