/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;

public class AnalyseSpectralGroup {
    private String studyId;
    private String groupId;
    private String studyName;
    private String groupName;
    private Group group;

    public AnalyseSpectralGroup(String string, String string2, String string3, String string4) {
        this.studyId = string;
        this.studyName = string2;
        this.groupId = string3;
        this.groupName = string4;
    }

    public AnalyseSpectralGroup(Analyse analyse, boolean bl) {
        AnalyseSpectralGroup analyseSpectralGroup = this.getFirstGroup(analyse, bl);
        if (analyseSpectralGroup != null) {
            this.studyId = analyseSpectralGroup.studyId;
            this.groupId = analyseSpectralGroup.groupId;
            this.studyName = analyseSpectralGroup.studyName;
            this.groupName = analyseSpectralGroup.groupName;
            this.group = analyseSpectralGroup.group;
        } else {
            Workflow workflow = analyse.getWorkflowElseNull();
            if (workflow != null) {
                this.studyId = workflow.getUid();
                this.studyName = workflow.getName();
                if (workflow.getChildCount() > 0) {
                    this.group = workflow.getChild(0);
                    this.groupId = this.group.getUid();
                    this.groupName = this.group.getName();
                }
            }
        }
    }

    private AnalyseSpectralGroup getFirstGroup(Analyse analyse, boolean bl) {
        AnalyseSpectralGroups analyseSpectralGroups = analyse.getGroups(bl);
        if (analyseSpectralGroups != null && analyseSpectralGroups.size() > 0) {
            return (AnalyseSpectralGroup)analyseSpectralGroups.get(analyseSpectralGroups.size() - 1);
        }
        return null;
    }

    public AnalyseSpectralGroup(Group group) {
        this.group = group;
    }

    public String getStudyId() {
        if (this.group != null) {
            return this.group.getParent().getUid();
        }
        return this.studyId;
    }

    public void setStudyName(String string) {
        this.studyName = string;
    }

    public String getStudyName() {
        if (this.group != null) {
            return this.group.getParent().getName();
        }
        return this.studyName;
    }

    public void setStudyId(String string) {
        this.studyId = string;
    }

    public String getGroupId() {
        if (this.group != null) {
            return this.group.getUid();
        }
        return this.groupId;
    }

    public String getGroupName() {
        if (this.group != null) {
            return this.group.getName();
        }
        return this.groupName;
    }

    public void setGroupId(String string) {
        this.groupId = string;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    public boolean hasGroup() {
        return this.group != null && this.group.exists();
    }

    public void clear() {
        this.group = null;
    }

    public List<Measurement> getChildList() {
        if (this.group != null) {
            return this.group.getChildList();
        }
        return new ArrayList<Measurement>();
    }

    public String toString() {
        String string = this.getStudyName();
        if (string != null) {
            return string + " - " + this.getGroupName();
        }
        return "NA";
    }

    public AnalyseSpectralGroup copy() {
        AnalyseSpectralGroup analyseSpectralGroup = new AnalyseSpectralGroup(this.studyId, this.studyName, this.groupId, this.groupName);
        analyseSpectralGroup.setGroup(this.group);
        return analyseSpectralGroup;
    }

    public static Group getFirstGroup(List<AnalyseSpectralGroup> list) {
        if (list != null) {
            for (AnalyseSpectralGroup analyseSpectralGroup : list) {
                if (!analyseSpectralGroup.hasGroup()) continue;
                return analyseSpectralGroup.getGroup();
            }
        }
        return null;
    }

    public static class AnalyseSpectralGroups
    extends ArrayList<AnalyseSpectralGroup> {
        public boolean hasGroup(Group group) {
            String string = group.getUid();
            for (int i = 0; i < this.size(); ++i) {
                if (!string.equals(((AnalyseSpectralGroup)this.get(i)).getGroupId())) continue;
                return true;
            }
            return false;
        }

        public void addGroup(Group group) {
            this.add(new AnalyseSpectralGroup(group));
        }
    }
}

