/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse;

import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.test.SlowTestCategory;
import se.prediktera.breeze.util.FileWithStringContent;

@Category(value={SlowTestCategory.class})
public class AnalyseTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private File rootFolder;
    private Analyse analyse;
    private File existingXmlFileFolder;
    private static final String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<model xmlns=\"Prediktera.XML.ModelXml\" createdby=\"Administrator \" createddate=\"20161017095206\" id=\"spectral_sample_uid\">\r\n  <description/>\r\n  <settings>\r\n    <ppclass>se.prediktera.breeze.frontend.wizard.model.SampleModelWizard</ppclass>\r\n    <type>Sample</type>\r\n    <modelling>\r\n      <sample>\r\n        <reduce>2</reduce>\r\n        <number_of_samples>9</number_of_samples>\r\n        <snv>true</snv>\r\n        <excludeWavelengthsBeginningPercent>4</excludeWavelengthsBeginningPercent>\r\n        <excludeWavelengthsEndPercent>4</excludeWavelengthsEndPercent>\r\n      </sample>\r\n    </modelling>\r\n  </settings>\r\n  <comments/>\r\n  <identifiers/>\r\n  <variables>\r\n    <qualitative id=\"\" name=\"SampleCategory\">\r\n      <editable>true</editable>\r\n      <class name=\"-\">\r\n        <color>red</color>\r\n      </class>\r\n      <class name=\"Sample\">\r\n        <color>#3ad23a</color>\r\n      </class>\r\n    </qualitative>\r\n  </variables>\r\n  <setup>\r\n    <variables/>\r\n    <samples>\r\n      <sample uid=\"A000002\">0</sample>\r\n      <sample uid=\"A000003\">0</sample>\r\n      <sample uid=\"A000004\">0</sample>\r\n      <sample uid=\"A000005\">0</sample>\r\n      <sample uid=\"A000006\">0</sample>\r\n      <sample uid=\"A000007\">0</sample>\r\n      <sample uid=\"A000008\">0</sample>\r\n    </samples>\r\n    <tests/>\r\n    <wavelengths>\r\n      <wavelength uid=\"index\">0,1,2,3,4,5,6,7,8,9</wavelength>\r\n    </wavelengths>\r\n    <properties>\r\n      <property key=\"snv\" value=\"true\"/>\r\n      <property key=\"calibrated\" value=\"true\"/>\r\n    </properties>\r\n  </setup>\r\n  <recordgroups>\r\n    <recordgroup recordid=\"spectral\" recordname=\"spectral\" studyid=\"spectral\" studyname=\"spectral\"/>\r\n  </recordgroups>\r\n</model>\r\n";

    @Before
    public void setup() throws IOException {
        this.rootFolder = this.tempFolder.getRoot();
        this.analyse = new AnalyseInTempFolder("Measurement THEONEANDONLY");
        this.existingXmlFileFolder = this.tempFolder.newFolder("existinguid");
        new FileWithStringContent(xmlString).writtenTo(new File(this.existingXmlFileFolder, "model.xml"));
    }

    @Test
    public void shouldCreateNewAnalyseTrimmingSpacesFromName() {
        AnalyseInTempFolder analyseInTempFolder = new AnalyseInTempFolder(" new name ");
        analyseInTempFolder.save();
        MatcherAssert.assertThat((String)"folder is created without spaces", (boolean)new File(this.rootFolder, "new name").exists());
        MatcherAssert.assertThat((String)"analyse is named without spaces", (Object)analyseInTempFolder.getName(), (Matcher)CoreMatchers.is((Object)"new name"));
    }

    @Test
    public void shouldThrowOnCreatingAnalyseWithAlreadyTakenName() {
        AnalyseInTempFolder analyseInTempFolder = new AnalyseInTempFolder("analyse1");
        analyseInTempFolder.save();
        try {
            AnalyseInTempFolder analyseInTempFolder2 = new AnalyseInTempFolder("analyse1");
            analyseInTempFolder2.save();
            Assert.fail((String)"should throw on creating another analyse with the same name");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void shouldSaveXmlInCorrectDirectoryWithCorrectFilename() {
        this.analyse.save();
        XMLTag xMLTag = XMLDoc.from((File)this.analyse.getXml(), (boolean)true);
        MatcherAssert.assertThat((String)"analyse xml file parsed", (Object)xMLTag, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void shouldSaveUidInXmlFile() {
        this.analyse.save();
        XMLTag xMLTag = XMLDoc.from((File)this.analyse.getXml(), (boolean)true);
        MatcherAssert.assertThat((Object)xMLTag.getAttribute("id", "/model", new Object[0]), (Matcher)CoreMatchers.equalTo((Object)this.analyse.getUid()));
    }

    @Test
    public void shouldLoadFromXmlFile() {
        AnalyseInTempFolder analyseInTempFolder = new AnalyseInTempFolder(this.existingXmlFileFolder);
        MatcherAssert.assertThat((String)"analyse was parsed somewhat", (Object)analyseInTempFolder, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void shouldSetUidFromXmlFile() {
        AnalyseInTempFolder analyseInTempFolder = new AnalyseInTempFolder(this.existingXmlFileFolder);
        MatcherAssert.assertThat((String)"analyse uid was read from xml", (Object)analyseInTempFolder.getUid(), (Matcher)CoreMatchers.equalTo((Object)"spectral_sample_uid"));
    }

    @Test
    public void shouldSetNameFromFolder() {
        AnalyseInTempFolder analyseInTempFolder = new AnalyseInTempFolder(this.existingXmlFileFolder);
        MatcherAssert.assertThat((String)"analyse name is folder name", (Object)analyseInTempFolder.getName(), (Matcher)CoreMatchers.equalTo((Object)analyseInTempFolder.getFolder().getName()));
    }

    @Test
    public void shouldFindMapFile() throws IOException {
        AnalyseInTempFolder analyseInTempFolder = new AnalyseInTempFolder(this.existingXmlFileFolder);
        new File(analyseInTempFolder.getFolder(), "model.map").createNewFile();
        MatcherAssert.assertThat((String)"analyse finds map file", (boolean)analyseInTempFolder.getProjectFile().exists());
    }

    @Test
    public void shouldRenameFolderAndChangeName() throws IOException {
        AnalyseInTempFolder analyseInTempFolder = new AnalyseInTempFolder("originalname");
        analyseInTempFolder.save();
        MatcherAssert.assertThat((String)"folder exists", (boolean)new File(this.rootFolder, "originalname").exists());
        MatcherAssert.assertThat((String)"xml file exists", (boolean)new File(this.rootFolder, "originalname/model.xml").exists());
        analyseInTempFolder.rename("newname");
        MatcherAssert.assertThat((String)"folder is renamed", (boolean)new File(this.rootFolder, "newname").exists());
        MatcherAssert.assertThat((String)"analyse is renamed", (Object)analyseInTempFolder.getName(), (Matcher)CoreMatchers.is((Object)"newname"));
        MatcherAssert.assertThat((String)"xml is not renamed", (boolean)new File(this.rootFolder, "newname/model.xml").exists());
    }

    @Test
    public void shouldRenameFolderAndChangeNameTrimmingSpaces() throws IOException {
        AnalyseInTempFolder analyseInTempFolder = new AnalyseInTempFolder("originalname");
        analyseInTempFolder.save();
        analyseInTempFolder.rename(" new name ");
        MatcherAssert.assertThat((String)"folder is renamed without spaces", (boolean)new File(this.rootFolder, "new name").exists());
        MatcherAssert.assertThat((String)"analyse is renamed without spaces", (Object)analyseInTempFolder.getName(), (Matcher)CoreMatchers.is((Object)"new name"));
    }

    @Test
    public void shouldAbortRenameIfFolderAlreadyExists() {
        AnalyseInTempFolder analyseInTempFolder = new AnalyseInTempFolder("originalname");
        analyseInTempFolder.save();
        new File(this.rootFolder, "newname").mkdirs();
        try {
            analyseInTempFolder.rename("newname");
            Assert.fail((String)"rename should fail");
        }
        catch (Exception exception) {
            this.assertNotRenamed(analyseInTempFolder, "originalname", "newname");
            MatcherAssert.assertThat((String)"dummy folder is still empty", (Object)new File(this.rootFolder, "newname").listFiles().length, (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Test
    public void shouldAbortRenameIfFolderRenameFailsWithIllegalCharacters() throws IOException {
        Assume.assumeTrue((boolean)System.getProperty("os.name").startsWith("Windows"));
        AnalyseInTempFolder analyseInTempFolder = new AnalyseInTempFolder("originalname");
        analyseInTempFolder.save();
        try {
            analyseInTempFolder.rename("<newname>");
            Assert.fail((String)"rename should fail");
        }
        catch (InvalidPathException invalidPathException) {
            this.assertNotRenamed(analyseInTempFolder, "originalname", "newname");
        }
    }

    @Test
    public void shouldAbortRenameIfFolderRenameFailsWithOpenStream() throws FileNotFoundException {
        Assume.assumeTrue((boolean)System.getProperty("os.name").startsWith("Windows"));
        AnalyseInTempFolder analyseInTempFolder = new AnalyseInTempFolder("originalname");
        analyseInTempFolder.save();
        new FileInputStream(analyseInTempFolder.getXml());
        try {
            analyseInTempFolder.rename("newname");
            Assert.fail((String)"rename should fail");
        }
        catch (Exception exception) {
            this.assertNotRenamed(analyseInTempFolder, "originalname", "newname");
        }
    }

    @Test
    public void shouldCreateVersion() {
        AnalyseInTempFolder analyseInTempFolder = new AnalyseInTempFolder("originalname");
        String string = analyseInTempFolder.getVersion();
        MatcherAssert.assertThat((Object)(string.length() > 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)string, (Matcher)CoreMatchers.is((Object)analyseInTempFolder.getVersion()));
        AnalyseInTempFolder analyseInTempFolder2 = new AnalyseInTempFolder(analyseInTempFolder.getFolder());
        MatcherAssert.assertThat((Object)string, (Matcher)CoreMatchers.is((Object)analyseInTempFolder2.getVersion()));
    }

    private void assertNotRenamed(AnalyseInTempFolder analyseInTempFolder, String string, String string2) {
        MatcherAssert.assertThat((String)"folder is not renamed", (boolean)new File(this.rootFolder, string).exists());
        MatcherAssert.assertThat((String)"analyse is not renamed", (Object)analyseInTempFolder.getName(), (Matcher)CoreMatchers.is((Object)string));
        MatcherAssert.assertThat((String)"xml is not renamed", (boolean)new File(this.rootFolder, string + "/model.xml").exists());
    }

    public class AnalyseInTempFolder
    extends Analyse {
        public AnalyseInTempFolder(String string) {
            super(string);
        }

        public AnalyseInTempFolder(File file) {
            super(file);
        }

        @Override
        protected File getParentFolder() {
            return AnalyseTest.this.rootFolder;
        }
    }
}

