/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.entry.analyse.model.CommonModelSettings;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.UidIndex;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;

public class ModelInformation {
    private Double dCrit;
    private Double hotellingT2;
    private Integer numberOfSamples;
    private Integer numberOfComponents;
    private Integer numberOfWaveLenghts;
    private Integer numberOfMLSeconds;
    private final List<String> listOfPretreatments = new ArrayList<String>();
    private List<UidIndex> regions;
    private UidIndex outerRegion;

    private ModelInformation() {
    }

    public static ModelInformation parse(Node node, BasicAnalyse.ModelMethod modelMethod) {
        ModelInformation modelInformation = new ModelInformation();
        if (node == null) {
            return modelInformation;
        }
        List<Node> list = XmlParserHelper.getNodeList(node, "properties");
        List list2 = Arrays.stream(Model.Transformation.values()).map(Model.Transformation::getXmlName).collect(Collectors.toUnmodifiableList());
        List list3 = Arrays.stream(Model.Transformation.values()).map(Model.Transformation::getInfoName).collect(Collectors.toUnmodifiableList());
        if (!list.isEmpty()) {
            for (Node object2 : XmlParserHelper.getNodeList(list.get(0), "property")) {
                String string = XmlParserHelper.getAttribute(object2, "key");
                String string2 = XmlParserHelper.getAttribute(object2, "value");
                if (list2.contains(string) && string2.equals("true")) {
                    modelInformation.listOfPretreatments.add((String)list3.get(list2.indexOf(string)));
                    continue;
                }
                if (string.equals("components") && !string2.equals("0")) {
                    modelInformation.numberOfComponents = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("dcrit")) {
                    modelInformation.dCrit = Double.parseDouble(string2);
                    continue;
                }
                if (!string.equals("hotellingt2")) continue;
                modelInformation.hotellingT2 = Double.parseDouble(string2);
            }
        }
        modelInformation.listOfPretreatments.sort(Comparator.comparingInt(list2::indexOf));
        modelInformation.numberOfWaveLenghts = ModelInformation.getNumberOrNullFromSetupNode("wavelengths", node);
        List<UidIndex> list4 = CommonModelSettings.ModelXmlFormat.parseWavelengths(node, true);
        if (list4.size() > 0) {
            modelInformation.regions = list4;
            modelInformation.outerRegion = new UidIndex("", "");
            modelInformation.outerRegion.addIndex(((UidIndex)list4.get(0)).getIndexList().get(0));
            UidIndex uidIndex = (UidIndex)list4.get(list4.size() - 1);
            modelInformation.outerRegion.addIndex(uidIndex.getIndexList().get(uidIndex.getIndexSize() - 1));
        }
        modelInformation.numberOfSamples = ModelInformation.getNumberOrNullFromSetupNode("samples", node);
        if (modelMethod.isRuntime()) {
            AbstractRuntimeModel.RuntimeSettings runtimeSettings = new AbstractRuntimeModel.RuntimeSettings(node);
            modelInformation.numberOfMLSeconds = runtimeSettings.time;
        }
        return modelInformation;
    }

    private static Integer getNumberOrNullFromSetupNode(String string, Node node) {
        int n;
        List<Node> list = XmlParserHelper.getNodeList(node, string);
        if (!list.isEmpty() && (n = XmlParserHelper.getIntAttribute(list.get(0), "number", -1)) != -1) {
            return n;
        }
        return null;
    }

    public Optional<Integer> getMLTrainingSeconds() {
        return Optional.ofNullable(this.numberOfMLSeconds);
    }

    public List<String> getListOfPretreatments() {
        return this.listOfPretreatments;
    }

    public Optional<Integer> getNumberComponents() {
        return Optional.ofNullable(this.numberOfComponents);
    }

    public Optional<Integer> getNumberOfWaveLenghts() {
        return Optional.ofNullable(this.numberOfWaveLenghts);
    }

    public Optional<Double> getHotelling() {
        return Optional.ofNullable(this.hotellingT2);
    }

    public Optional<Double> getDcrit() {
        return Optional.ofNullable(this.dCrit);
    }

    public Optional<Integer> getNumberOfSamples() {
        return Optional.ofNullable(this.numberOfSamples);
    }

    public String getDiff(ModelInformation modelInformation) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (modelInformation == null) {
            modelInformation = new ModelInformation();
        }
        if (!Objects.equals(this.numberOfComponents, modelInformation.numberOfComponents)) {
            arrayList.add("Components");
        }
        if (!Objects.equals(this.numberOfSamples, modelInformation.numberOfSamples)) {
            arrayList.add("Samples");
        }
        if (!Objects.equals(this.numberOfMLSeconds, modelInformation.numberOfMLSeconds)) {
            arrayList.add("Training Time");
        }
        if (!Objects.equals(this.dCrit, modelInformation.getDcrit().orElse(null))) {
            arrayList.add("dCrit");
        }
        if (!Objects.equals(this.numberOfWaveLenghts, modelInformation.numberOfWaveLenghts)) {
            arrayList.add("Wavelengths");
        }
        if (!this.listOfPretreatments.equals(modelInformation.listOfPretreatments)) {
            arrayList.add("Transformations");
        }
        return String.join((CharSequence)",", arrayList);
    }

    public List<String> getFormatedRanges(Workflow workflow) {
        BandNames bandNames;
        Measurement measurement;
        if (workflow != null && (measurement = workflow.getFirstMeasurementWithData()) != null && (bandNames = measurement.getBandNames()) != null && this.regions != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (UidIndex uidIndex : this.regions) {
                arrayList.add(ModelInformation.getFormatedRegion(uidIndex, false, bandNames));
            }
            return arrayList;
        }
        return null;
    }

    public String getFormatedRange(Workflow workflow, boolean bl) {
        BandNames bandNames;
        Measurement measurement;
        if (workflow != null && (measurement = workflow.getFirstMeasurementWithData()) != null && (bandNames = measurement.getBandNames()) != null && this.outerRegion != null) {
            return ModelInformation.getFormatedRegion(this.outerRegion, bl, bandNames);
        }
        return null;
    }

    private static String getFormatedRegion(UidIndex uidIndex, boolean bl, BandNames bandNames) {
        ArrayList<Integer> arrayList = uidIndex.getIndexList();
        Integer n = arrayList.get(0);
        Integer n2 = arrayList.get(arrayList.size() - 1);
        StringBuilder stringBuilder = new StringBuilder(bandNames.getFormated(n));
        stringBuilder.append(" - ");
        if (bl) {
            stringBuilder.append("@@");
        }
        stringBuilder.append(bandNames.getFormated(n2));
        if (bandNames.isNm()) {
            stringBuilder.append(" nm");
        }
        return stringBuilder.toString();
    }
}

