/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;

public class RecordGroupHolder {
    private final boolean external;
    private final AnalyseSpectralGroup.AnalyseSpectralGroups groups = new AnalyseSpectralGroup.AnalyseSpectralGroups();

    public RecordGroupHolder(boolean bl) {
        this.external = bl;
    }

    public String toString() {
        return "RecordGroups";
    }

    public void parse(Node node) {
        List<Node> list = XmlParserHelper.getNodeList(node, "recordgroup", null);
        for (Node node2 : list) {
            String string = XmlParserHelper.getAttribute(node2, "studyid");
            String string2 = XmlParserHelper.getAttribute(node2, "recordid");
            String string3 = XmlParserHelper.getAttribute(node2, "studyname");
            String string4 = XmlParserHelper.getAttribute(node2, "recordname");
            AnalyseSpectralGroup analyseSpectralGroup = new AnalyseSpectralGroup(string, string3, string2, string4);
            this.groups.add(analyseSpectralGroup);
        }
    }

    public Element save(Node node) {
        Element element = XmlParserHelper.addElement(node, this.getXmlNodeType());
        for (AnalyseSpectralGroup analyseSpectralGroup : this.groups) {
            this.save(analyseSpectralGroup, element);
        }
        return element;
    }

    private void save(AnalyseSpectralGroup analyseSpectralGroup, Node node) {
        Element element = XmlParserHelper.addElement(node, "recordgroup");
        element.setAttribute("studyid", analyseSpectralGroup.getStudyId());
        element.setAttribute("studyname", analyseSpectralGroup.getStudyName());
        element.setAttribute("recordid", analyseSpectralGroup.getGroupId());
        element.setAttribute("recordname", analyseSpectralGroup.getGroupName());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Group getGroup() {
        if (this.groups != null && this.groups.size() > 0) {
            return ((AnalyseSpectralGroup)this.groups.get(0)).getGroup();
        }
        return null;
    }

    public AnalyseSpectralGroup.AnalyseSpectralGroups getGroups() {
        return this.groups;
    }

    public void addGroup(Group group) {
        this.groups.add(new AnalyseSpectralGroup(group));
    }

    public boolean partOfStudy(String string) {
        for (AnalyseSpectralGroup analyseSpectralGroup : this.groups) {
            if (!string.equals(analyseSpectralGroup.getStudyId())) continue;
            return true;
        }
        return false;
    }

    public Measurement getFirstMeasurementWithData() {
        for (AnalyseSpectralGroup analyseSpectralGroup : this.groups) {
            Measurement measurement;
            Group group = analyseSpectralGroup.getGroup();
            if (group == null || (measurement = group.getFirstMeasurementWithData()) == null) continue;
            return measurement;
        }
        return null;
    }

    public String getXmlNodeType() {
        if (this.external) {
            return "externalrecordgroups";
        }
        return "recordgroups";
    }

    public void setGroupFromWorkflow() {
        for (AnalyseSpectralGroup analyseSpectralGroup : new ArrayList<AnalyseSpectralGroup>(this.getGroups())) {
            Workflow workflow;
            if (analyseSpectralGroup.getGroup() != null || (workflow = BreezeMasterCache.getInstance().getStudyList().byId(analyseSpectralGroup.getStudyId())) == null) continue;
            Group group = RecordGroupHolder.getGroupById(workflow, analyseSpectralGroup.getGroupId());
            if (group != null) {
                analyseSpectralGroup.setGroup(group);
                continue;
            }
            Group group2 = RecordGroupHolder.getGroupByName(workflow, analyseSpectralGroup.getGroupName());
            if (group2 == null) continue;
            analyseSpectralGroup.setGroup(group2);
            analyseSpectralGroup.setGroupId(group2.getUid());
        }
    }

    public void clear() {
        this.groups.clear();
    }

    private static Group getGroupById(Workflow workflow, String string) {
        if (string != null) {
            for (Group group : workflow.getChildList()) {
                if (!string.equals(group.getUid())) continue;
                return group;
            }
        }
        return null;
    }

    private static Group getGroupByName(Workflow workflow, String string) {
        if (string != null) {
            for (Group group : workflow.getChildList()) {
                if (!string.equals(group.getName())) continue;
                return group;
            }
        }
        return null;
    }
}

