/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.DefaultModel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;

public abstract class AbstractRuntimeModel
extends DefaultModel {
    private RuntimeSettings runtimeSettings = new RuntimeSettings();
    private RuntimeResultList runtimeResults = new RuntimeResultList();

    public AbstractRuntimeModel(BreezeProgress breezeProgress, Analyse analyse) {
        this(breezeProgress, analyse, (List<FactorOrDescriptor>)null);
    }

    public AbstractRuntimeModel(BreezeProgress breezeProgress, Analyse analyse, List<FactorOrDescriptor> list) {
        super(breezeProgress, analyse, list);
        this.parseRuntime(analyse);
    }

    public AbstractRuntimeModel(BreezeProgress breezeProgress, Analyse analyse, AbstractModel abstractModel) {
        super(breezeProgress, analyse, abstractModel);
        this.parseRuntime(analyse);
    }

    private void parseRuntime(Analyse analyse) {
        Node node = analyse.getSetupXmlNode();
        if (node != null) {
            this.runtimeSettings = new RuntimeSettings(node);
            this.runtimeResults = new RuntimeResultList(node);
        }
    }

    public void saveTrainingData(BreezeProgressManager breezeProgressManager, File file, boolean bl) {
        this.save(breezeProgressManager, this.model.getMatrixByName("Xres"), file, true, bl);
    }

    public void saveTestData(BreezeProgressManager breezeProgressManager, File file, boolean bl) {
        AbstractPrediction abstractPrediction = this.model.getLocalPredictionNode();
        if (abstractPrediction != null) {
            this.save(breezeProgressManager, abstractPrediction.getMatrixByName("Xres Test"), file, false, bl);
        }
    }

    protected abstract void save(BreezeProgressManager var1, AbstractDataMatrix var2, File var3, boolean var4, boolean var5);

    @Override
    public void saveXml(Element element) {
        super.saveXml(element);
        this.runtimeSettings.save(element);
        this.runtimeResults.save(element);
    }

    public RuntimeResultList getRuntimeResults() {
        if (!this.runtimeResults.results.isEmpty()) {
            this.runtimeResults.results.getFirst().selected = true;
        }
        return this.runtimeResults;
    }

    public static RtModelParameters.RtModel createRtModel(BasicAnalyse basicAnalyse, File file, double d, boolean bl) {
        RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel("ClassificationRuntime");
        RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Base");
        rtModel.getModules().add(rtModuleSetup);
        if (!file.exists()) {
            throw new FileNotFoundException("Cannot find " + file.getName() + " for analyse: " + basicAnalyse.getName());
        }
        byte[] byArray = Files.readAllBytes(file.toPath());
        String string = Base64.getEncoder().encodeToString(byArray);
        rtModuleSetup.add(new RtModelParameters.RtParameterString("model", string));
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("confidenceLevel", d));
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("storeConfidence", bl ? 1.0 : 0.0));
        return rtModel;
    }

    @Generated
    public RuntimeSettings getRuntimeSettings() {
        return this.runtimeSettings;
    }

    @Generated
    public void setRuntimeResults(RuntimeResultList runtimeResultList) {
        this.runtimeResults = runtimeResultList;
    }

    public static class RuntimeSettings
    implements Cloneable {
        public int time = 30;
        public String method;
        public String metric;
        public String scriptFile;
        public String displayName = this.method = "Auto";
        public boolean crossValidateAll = true;
        public String interpreter;
        public String customInterpreter;
        public int numberOfCvFolds = 5;
        public int topK = 5;

        public RuntimeSettings() {
        }

        public RuntimeSettings(Node node) {
            List<Node> list = XmlParserHelper.getNodeList(node, "runtimeProperties");
            if (!list.isEmpty()) {
                List<Node> list2 = XmlParserHelper.getNodeList(list.getFirst(), "property");
                for (Node node2 : list2) {
                    if (!node2.getNodeName().equals("property")) continue;
                    String string = XmlParserHelper.getAttribute(node2, "key");
                    String string2 = XmlParserHelper.getAttribute(node2, "value");
                    if (string.equalsIgnoreCase("method")) {
                        this.method = string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("time")) {
                        this.time = RtDataFormat.toNumberInt(string2);
                        continue;
                    }
                    if (string.equalsIgnoreCase("crossValidateAll")) {
                        this.crossValidateAll = Boolean.parseBoolean(string2);
                        continue;
                    }
                    if (string.equalsIgnoreCase("displayName")) {
                        this.displayName = string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("metric")) {
                        this.metric = string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("scriptFile")) {
                        this.scriptFile = string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("interpreter")) {
                        this.interpreter = string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("customInterpreter")) {
                        this.customInterpreter = string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("numberOfCvFolds")) {
                        this.numberOfCvFolds = RtDataFormat.toNumberInt(string2);
                        continue;
                    }
                    if (!string.equalsIgnoreCase("topK")) continue;
                    this.topK = RtDataFormat.toNumberInt(string2);
                }
            }
        }

        public void save(Element element) {
            Element element2 = XmlParserHelper.addElement(element, "runtimeProperties");
            this.addProperty(element2, "method", this.method);
            this.addProperty(element2, "time", String.valueOf(this.time));
            this.addProperty(element2, "crossValidateAll", String.valueOf(this.crossValidateAll));
            this.addProperty(element2, "displayName", this.displayName);
            this.addProperty(element2, "metric", this.metric);
            this.addProperty(element2, "scriptFile", this.scriptFile);
            this.addProperty(element2, "interpreter", this.interpreter);
            this.addProperty(element2, "customInterpreter", this.customInterpreter);
            this.addProperty(element2, "numberOfCvFolds", String.valueOf(this.numberOfCvFolds));
            this.addProperty(element2, "topK", String.valueOf(this.topK));
        }

        private void addProperty(Element element, String string, String string2) {
            Element element2 = XmlParserHelper.addElement(element, "property");
            element2.setAttribute("key", string);
            element2.setAttribute("value", string2);
        }

        public RuntimeSettings clone() {
            try {
                return (RuntimeSettings)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }

        @Generated
        public void setTime(int n) {
            this.time = n;
        }

        @Generated
        public void setMethod(String string) {
            this.method = string;
        }

        @Generated
        public void setMetric(String string) {
            this.metric = string;
        }

        @Generated
        public void setScriptFile(String string) {
            this.scriptFile = string;
        }

        @Generated
        public void setDisplayName(String string) {
            this.displayName = string;
        }

        @Generated
        public void setCrossValidateAll(boolean bl) {
            this.crossValidateAll = bl;
        }

        @Generated
        public void setInterpreter(String string) {
            this.interpreter = string;
        }

        @Generated
        public void setCustomInterpreter(String string) {
            this.customInterpreter = string;
        }

        @Generated
        public void setNumberOfCvFolds(int n) {
            this.numberOfCvFolds = n;
        }

        @Generated
        public void setTopK(int n) {
            this.topK = n;
        }
    }

    public static class RuntimeResultList {
        public List<RuntimeResult> results = new ArrayList<RuntimeResult>();

        public RuntimeResultList() {
        }

        public RuntimeResultList(Node node) {
            List<Node> list = XmlParserHelper.getNodeList(node, "runtimeResults");
            if (!list.isEmpty()) {
                List<Node> list2 = XmlParserHelper.getNodeList(list.getFirst(), "result");
                for (Node node2 : list2) {
                    if (!node2.getNodeName().equals("result")) continue;
                    this.results.add(new RuntimeResult(node2));
                }
            }
        }

        public RuntimeResultList(JSONObject jSONObject, BasicAnalyse.ModelType modelType, boolean bl) {
            JSONArray jSONArray = jSONObject.getJSONArray("Results");
            for (int i = 0; i < jSONArray.length(); ++i) {
                RuntimeResult runtimeResult = new RuntimeResult((JSONObject)jSONArray.get(i));
                boolean bl2 = runtimeResult.selected = i == 0;
                if (bl) {
                    runtimeResult.algorithmName = "External";
                }
                runtimeResult.modelType = modelType.toString();
                this.results.add(runtimeResult);
            }
        }

        public void save(Element element) {
            Element element2 = XmlParserHelper.addElement(element, "runtimeResults");
            for (RuntimeResult runtimeResult : this.results) {
                runtimeResult.save(element2);
            }
        }
    }

    public static class RuntimeResult {
        public String algorithmName;
        public List<Double> accuracy = Arrays.asList(-1.0, -1.0, -1.0, -1.0, -1.0);
        public double accuracyTest = -1.0;
        public double crossValidationResult = -1.0;
        public double runtimeInSeconds;
        public boolean selected;
        public String modelType;
        public final String displayName;

        public RuntimeResult(Node node) {
            this.algorithmName = XmlParserHelper.getAttribute(node, "algorithmName");
            this.displayName = XmlParserHelper.getAttribute(node, "displayName");
            this.runtimeInSeconds = XmlParserHelper.getDoubleAttribute(node, "runtimeInSeconds", -1.0);
            this.accuracyTest = XmlParserHelper.getDoubleAttribute(node, "accuracyTest", -1.0);
            this.crossValidationResult = XmlParserHelper.getDoubleAttribute(node, "crossValidationResult", -1.0);
            this.modelType = XmlParserHelper.getAttribute(node, "modelType");
            String string = XmlParserHelper.getAttribute(node, "accuracy");
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                this.accuracy = Arrays.stream(string.split(";")).map(Double::parseDouble).collect(Collectors.toList());
            }
        }

        public RuntimeResult(JSONObject jSONObject) {
            this.algorithmName = jSONObject.optString("AlgorithmName", "External");
            this.displayName = jSONObject.getString("DisplayName");
            if (!jSONObject.isNull("Accuracy")) {
                this.accuracy = Arrays.stream(jSONObject.getString("Accuracy").split(";")).map(Double::parseDouble).collect(Collectors.toList());
            }
            this.runtimeInSeconds = jSONObject.getDouble("RuntimeInSeconds");
            if (!jSONObject.isNull("AccuracyTest")) {
                this.accuracyTest = jSONObject.getDouble("AccuracyTest");
            }
            if (!jSONObject.isNull("CrossValidationResults")) {
                this.crossValidationResult = jSONObject.getDouble("CrossValidationResults");
            }
        }

        public void save(Element element) {
            Element element2 = XmlParserHelper.addElement(element, "result");
            element2.setAttribute("algorithmName", this.algorithmName);
            element2.setAttribute("displayName", this.displayName);
            element2.setAttribute("modelType", this.modelType);
            element2.setAttribute("accuracy", StringUtils.join(this.accuracy, (String)";"));
            element2.setAttribute("accuracyTest", NiceDataFormat.toString((double)this.accuracyTest));
            element2.setAttribute("crossValidationResult", NiceDataFormat.toString((double)this.crossValidationResult));
            element2.setAttribute("runtimeInSeconds", NiceDataFormat.toString((double)this.runtimeInSeconds));
        }

        public String toString() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return this.algorithmName;
        }
    }
}

