/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.DefaultModel;
import se.prediktera.breeze.entry.analyse.model.EvinceModelParameters;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.model.AbstractModel;

public class ClassificationModel
extends DefaultModel
implements Model.IClassificationModel {
    public ClassificationModel(BreezeProgress breezeProgress, Analyse analyse) {
        this(breezeProgress, analyse, (List<FactorOrDescriptor>)null);
    }

    public ClassificationModel(BreezeProgress breezeProgress, Analyse analyse, List<FactorOrDescriptor> list) {
        super(breezeProgress, analyse, list);
    }

    public ClassificationModel(BreezeProgress breezeProgress, Analyse analyse, AbstractModel abstractModel) {
        super(breezeProgress, analyse, abstractModel);
        ClassTypes classTypes = abstractModel.getClassTypes();
        CategoryFactor categoryFactor = analyse.getWorkflow().getCategoryFactors().getByName(classTypes.toString());
        this.setVariables(Collections.singletonList(categoryFactor));
    }

    @Override
    public void createModel(BreezeProgressManager breezeProgressManager) {
        CategoryFactor categoryFactor = this.getFactor();
        ClassificationModel.excludeNoClass(breezeProgressManager, this.dataSet, categoryFactor);
        if (this.model != null) {
            this.model.delete();
        }
        Properties properties = new Properties();
        properties.put("rethrowexceptions", "true");
        if (this.analyse.getModelMethod().equals((Object)BasicAnalyse.ModelMethod.SimcaClassification)) {
            properties.put("category", categoryFactor.getName());
            this.model = this.dataSet.createModel((ProgressManager)breezeProgressManager, "simca", properties);
            for (AbstractModel abstractModel : EvinceModelParameters.getModels(this.model)) {
                abstractModel.setUseDcrit(true);
            }
        } else {
            this.modelSettings(properties);
            properties.put("ycategory", categoryFactor.getName());
            this.model = this.dataSet.createModel((ProgressManager)breezeProgressManager, "pls-da", properties);
        }
        this.model.setName(this.analyse.getUid());
        ModelProperties.setFromProperties(breezeProgressManager, this.model, this.analyse, false);
        this.model.setEnabled(true);
    }

    public static void excludeNoClass(ProgressManager progressManager, DataSet dataSet, CategoryFactor categoryFactor) {
        InnerColumnClass innerColumnClass = dataSet.getCategory(categoryFactor.getName());
        Double[] doubleArray = innerColumnClass.getClassIndex("-");
        if (doubleArray.length > 0) {
            dataSet.exclude(progressManager, "obs", doubleArray);
        }
    }

    @Override
    public void updateSampleInclusionAndTestFlags(ProgressManager progressManager, boolean[] blArray, boolean[] blArray2) {
        super.updateSampleInclusionAndTestFlags(progressManager, blArray, blArray2);
        ClassificationModel.excludeNoClass(progressManager, this.dataSet, this.getFactor());
    }

    public void enabledDcrit(double d) {
        this.model.setUseDcrit(true);
        this.model.setDcritX(d);
    }

    @Override
    public CategoryFactor getFactor() {
        if (this.selectedProperties != null && this.selectedProperties.size() > 0) {
            return (CategoryFactor)this.selectedProperties.get(0);
        }
        return null;
    }

    public List<CategoryFactor> getSelectedVariables() {
        CategoryFactor categoryFactor = this.getFactor();
        if (categoryFactor != null) {
            return List.of(categoryFactor);
        }
        if (!this.getAllVariables(this.segmentationLevel, null).isEmpty()) {
            return Collections.singletonList((CategoryFactor)this.getAllVariables(this.segmentationLevel, null).get(0));
        }
        return List.of();
    }

    @Override
    public List<FactorOrDescriptor> getAllVariables(int n, String string) {
        return FactorOrDescriptor.toList(this.analyse.getWorkflow().getCategoryFactors());
    }

    @Override
    public List<String> getModelVariables() {
        if (this.analyse.getModelMethod().equals((Object)BasicAnalyse.ModelMethod.SimcaClassification)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (AbstractModel abstractModel : ClassificationModel.getModels(this.model)) {
                arrayList.add(abstractModel.getName());
            }
            return arrayList;
        }
        return super.getModelVariables();
    }

    @Override
    public void finishAndSave(BreezeProgressManager breezeProgressManager) {
        this.analyse.getCategoryFactors().clear();
        this.analyse.getCategoryFactors().add((CategoryFactor)this.getFactor().cloneKeepId());
        this.analyse.addModelPropertiesToAnalyse(this.model);
        this.commonModelSettings.saveEvinceModel(breezeProgressManager);
        this.analyse.save(this);
    }

    @Override
    public void balanceTrainData(BreezeProgress breezeProgress, boolean bl, boolean bl2) {
        new ClassificationBalanceModel(this.dataSet, this.dataSet.getCategory(this.getFactor().getName())).performAnalysis(breezeProgress, bl, bl2);
    }

    public static List<AbstractModel> getModels(AbstractModel abstractModel) {
        ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
        for (int i = 0; i < abstractModel.getTreeNodeCount(); ++i) {
            if (!(abstractModel.getTreeNodeAt(i) instanceof AbstractModel)) continue;
            arrayList.add((AbstractModel)abstractModel.getTreeNodeAt(i));
        }
        return arrayList;
    }

    protected static class ClassificationBalanceModel
    extends DefaultModel.BalanceModel {
        private final InnerColumnClass icc;

        public ClassificationBalanceModel(DataSet dataSet, InnerColumnClass innerColumnClass) {
            super(dataSet);
            this.icc = innerColumnClass;
        }

        @Override
        protected ArrayList<Integer>[] createIndexList(boolean bl) {
            ClassTypes classTypes = this.icc.getObject();
            ArrayList<Integer>[] arrayListArray = this.allocateIndexList(classTypes.size());
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.dataInfo.getPrimaryColumnByType(4);
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)this.dataInfo.getPrimaryColumnByType(1);
            for (int i = 0; i < this.icc.getSize(); ++i) {
                if (!innerColumnBoolean.getValueBool(i) || bl && !innerColumnBoolean2.getValueBool(i) || this.icc.getValueShort(i) <= 0) continue;
                arrayListArray[this.icc.getValueShort(i)].add(i);
            }
            return arrayListArray;
        }
    }
}

