/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.analyse.model.UidIndex;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.util.CompactIntegerList;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.main.ProjectProperties;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.model.AbstractModel;

public class CommonModelSettings {
    private final Analyse analyse;
    private final DataSet dataSet;
    private AbstractModel model;
    private final Project_GUI project_GUI;
    private final EvinceWavelengthIndex wavelengthIndex;
    private final ModelXmlFormat format = new ModelXmlFormat();

    public CommonModelSettings(Analyse analyse, DataSet dataSet) {
        this.analyse = analyse;
        this.dataSet = dataSet;
        this.project_GUI = dataSet.getProject_GUI();
        this.wavelengthIndex = new EvinceWavelengthIndex(dataSet);
        this.parseWavelengthsOrSetDefault(analyse.getSetupXmlNode());
        for (Model.Transformation transformation : Model.Transformation.values()) {
            this.updateTransformation(this.format.parseTransformation(transformation));
        }
    }

    public CommonModelSettings(Analyse analyse, DataSet dataSet, AbstractModel abstractModel) {
        this.analyse = analyse;
        this.dataSet = dataSet;
        this.model = abstractModel;
        this.project_GUI = dataSet.getProject_GUI();
        this.wavelengthIndex = new EvinceWavelengthIndex(dataSet);
    }

    private void parseWavelengthsOrSetDefault(Node node) {
        if (!this.format.parseWavelengthsAndSetInDataSet(node)) {
            this.setDefaultWavelength();
        }
    }

    private void setDefaultWavelength() {
        int n;
        Workflow workflow = this.analyse.getWorkflow();
        double d = this.analyse.getDefaultExcludeBeginningPercent(workflow);
        double d2 = this.analyse.getDefaultExcludeEndPercent(workflow);
        this.wavelengthIndex.includeAll();
        this.wavelengthIndex.excludeNoneNirVariables();
        int n2 = this.wavelengthIndex.getWavelengthCount();
        int n3 = (int)((double)n2 * d / 100.0);
        for (n = 0; n < n3; ++n) {
            this.wavelengthIndex.setValue(n, false);
        }
        for (int i = n = n2 - (int)((double)n2 * d2 / 100.0); i < n2; ++i) {
            this.wavelengthIndex.setValue(i, false);
        }
    }

    public void updateIncludedWavelengths(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            this.wavelengthIndex.setValue(i, blArray[i]);
        }
        this.dataSet.updateReferences((ProgressManager)BreezeProgressManager.createEmpty(), true);
    }

    public boolean isWavelengthIndexIncluded(int n) {
        return this.wavelengthIndex.getValue(n);
    }

    public float getWavelengthImportance(AbstractModel abstractModel, int n) {
        if (abstractModel != null) {
            return (float)CommonModelSettings.getVariableImportance(abstractModel, n, false);
        }
        return 0.0f;
    }

    public static double getVariableImportance(AbstractModel abstractModel, int n, boolean bl) {
        int n2;
        int n3 = abstractModel.getDatatypeNIRStartIndex();
        ModelMatrix modelMatrix = (ModelMatrix)abstractModel.getMatrixByName("w");
        ModelMatrix modelMatrix2 = (ModelMatrix)abstractModel.getMatrixByName("r2y");
        if (modelMatrix != null && modelMatrix2 != null && modelMatrix.getN() > 0 && (n2 = modelMatrix.getKrefOrig(n3 + n)) >= 0) {
            int n4 = modelMatrix.getN();
            double d = 0.0;
            for (int i = 0; i < n4; ++i) {
                double d2 = modelMatrix2.getScalar(i);
                d += d2;
            }
            if (bl) {
                double d3 = 0.0;
                for (int i = 0; i < n4; ++i) {
                    double d4 = modelMatrix2.getScalar(i);
                    double d5 = modelMatrix.getValue(i, n2);
                    double d6 = d5 * d5;
                    d3 += d6 * d4;
                }
                return Math.sqrt(d3 * ((double)modelMatrix.getK() / d)) * 100.0;
            }
            double d7 = 0.0;
            for (int i = 0; i < n4; ++i) {
                double d8 = modelMatrix2.getScalar(i);
                double d9 = Math.abs(modelMatrix.getValue(i, n2));
                d7 += d9 * d8;
            }
            return d7 * 100.0;
        }
        return 0.0;
    }

    public HashMap<Model.Transformation, ModelProperties.TransformationProperties> getTransformations() {
        HashMap<Model.Transformation, ModelProperties.TransformationProperties> hashMap = new HashMap<Model.Transformation, ModelProperties.TransformationProperties>();
        for (Model.Transformation transformation : Model.Transformation.values()) {
            hashMap.put(transformation, this.getModification(transformation));
        }
        return hashMap;
    }

    public ModelProperties.TransformationProperties getModification(Model.Transformation transformation) {
        if (this.dataSet != null) {
            return new ModelProperties.TransformationProperties(transformation, CommonModelSettings.getModificationFromDataSet(this.dataSet, transformation));
        }
        return this.format.parseTransformation(transformation);
    }

    public void updateTransformation(ModelProperties.TransformationProperties transformationProperties) {
        CommonModelSettings.updateTransformation(this.dataSet, transformationProperties);
    }

    public static void updateTransformation(DataSet dataSet, ModelProperties.TransformationProperties transformationProperties) {
        Model.Transformation transformation = transformationProperties.getTransformation();
        AbstractTransform abstractTransform = CommonModelSettings.getModificationFromDataSet(dataSet, transformation);
        if (transformationProperties.enabled()) {
            Properties properties = transformationProperties.getProperties();
            if (abstractTransform != null) {
                abstractTransform.setExtraArgument(properties);
                dataSet.setTransformationResults();
            } else {
                if (transformation.equals((Object)Model.Transformation.Logarithm)) {
                    properties.put("includeAll", "true");
                    properties.put("log10", "false");
                }
                dataSet.createModification((ProgressManager)BreezeProgressManager.createEmpty(), "var", transformation.getInfoName(), (Double[])null, properties);
            }
        } else if (abstractTransform != null) {
            dataSet.deleteModification("var", abstractTransform);
        }
    }

    private static AbstractTransform getModificationFromDataSet(DataSet dataSet, Model.Transformation transformation) {
        if (dataSet != null) {
            return dataSet.getModificationByTreeType("var", transformation.getTreeType());
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.format.parseProperty(string) != null;
    }

    public String getProperty(String string) {
        return this.format.parseProperty(string);
    }

    public boolean getPropertyBool(String string, boolean bl) {
        String string2 = this.format.parseProperty(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public double getPropertyDouble(String string, double d) {
        String string2 = this.format.parseProperty(string);
        if (string2 != null) {
            return NiceDataFormat.toNumber((String)string2);
        }
        return d;
    }

    public int getWavelengthCount() {
        return this.wavelengthIndex.getWavelengthCount();
    }

    public void saveXml(Element element, AbstractModel abstractModel) {
        ModelProperties modelProperties = ModelProperties.fromModel(abstractModel);
        ModelXmlFormat modelXmlFormat = new ModelXmlFormat();
        modelXmlFormat.saveWavelength(element, this.dataSet);
        for (Model.Transformation transformation : Model.Transformation.values()) {
            this.getModification(transformation).addToProperties(modelProperties);
        }
        modelProperties.put("cutOffLow", String.valueOf(abstractModel.getCutOffLow()), null);
        modelProperties.put("cutOffHigh", String.valueOf(abstractModel.getCutOffHigh()), null);
        modelProperties.saveProperties(element);
    }

    public void saveEvinceModel(BreezeProgressManager breezeProgressManager) {
        if (this.model != null) {
            return;
        }
        ProjectProperties projectProperties = this.project_GUI.getProperties();
        projectProperties.addProperty("Analyse", this.analyse.getName());
        projectProperties.addProperty("Type", this.analyse.getModelMethod().getMethod());
        projectProperties.addProperty("ID", this.analyse.getUid());
        projectProperties.addProperty("Date", this.analyse.getEntryData().getViewCreatedDate());
        File file = this.analyse.getProjectFile();
        EvinceScriptCommands.save((ProgressManager)breezeProgressManager, (Project_GUI)this.project_GUI, (String)file.getAbsolutePath(), null);
        this.analyse.getBaseModel(breezeProgressManager);
        XmlProperties xmlProperties = this.analyse.getProperties();
        xmlProperties.setPropertyLocal("project", file.getName());
        this.analyse.clearCachedModel();
    }

    public class ModelXmlFormat {
        private ModelProperties.TransformationProperties parseTransformation(Model.Transformation transformation) {
            ModelProperties modelProperties = new ModelProperties(CommonModelSettings.this.analyse);
            boolean bl = modelProperties.getPropertyBool(transformation.getXmlName(), CommonModelSettings.this.analyse.isDefault(transformation));
            String string = modelProperties.getProperty(transformation.getXmlName() + "_properties", "");
            return new ModelProperties.TransformationProperties(transformation, bl, string);
        }

        public String parseProperty(String string) {
            return new ModelProperties(CommonModelSettings.this.analyse).getProperty(string, null);
        }

        public static List<UidIndex> parseWavelengths(Node node, boolean bl) {
            ArrayList<UidIndex> arrayList = new ArrayList<UidIndex>();
            if (node != null) {
                ModelXmlFormat.parseUidList(node, arrayList, "wavelength", bl);
            }
            return arrayList;
        }

        private static void parseUidList(Node node, List<UidIndex> list, String string, boolean bl) {
            List<Node> list2 = XmlParserHelper.getNodeList(node, string + "s", null);
            for (Node node2 : list2) {
                List<Node> list3 = XmlParserHelper.getNodeList(node2, string, null);
                for (Node node3 : list3) {
                    String string2 = XmlParserHelper.getAttribute(node3, "uid");
                    String string3 = node3.getTextContent();
                    if (bl) {
                        String[] stringArray;
                        for (String string4 : stringArray = string3.split(",")) {
                            list.add(ModelXmlFormat.addUidIndex(string2, CompactIntegerList.parseInterval(string4)));
                        }
                        continue;
                    }
                    list.add(ModelXmlFormat.addUidIndex(string2, new CompactIntegerList(string3)));
                }
            }
        }

        private static UidIndex addUidIndex(String string, Iterable<Integer> iterable) {
            UidIndex uidIndex = new UidIndex(string, null);
            for (int n : iterable) {
                uidIndex.addIndex(n);
            }
            return uidIndex;
        }

        private boolean parseWavelengthsAndSetInDataSet(Node node) {
            List<UidIndex> list = ModelXmlFormat.parseWavelengths(node, false);
            boolean bl = false;
            if (!list.isEmpty()) {
                UidIndex uidIndex = list.get(0);
                CommonModelSettings.this.wavelengthIndex.excludeAll();
                for (Integer n : uidIndex.indexList) {
                    CommonModelSettings.this.wavelengthIndex.setValue(n, true);
                    bl = true;
                }
            }
            return bl;
        }

        private void saveWavelength(Element element, DataSet dataSet) {
            Element element2 = XmlParserHelper.addElement(element, "wavelengths");
            Element element3 = XmlParserHelper.addElement(element2, "wavelength");
            CompactIntegerList compactIntegerList = new CompactIntegerList();
            int n = CommonModelSettings.this.wavelengthIndex.getWavelengthCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!CommonModelSettings.this.wavelengthIndex.getValue(i)) continue;
                compactIntegerList.add(i);
                ++n2;
            }
            XmlParserHelper.setAttribute((Node)element2, "number", n2);
            element3.setTextContent(compactIntegerList.toString());
        }
    }

    public static class EvinceWavelengthIndex {
        private final DataSet dataSet;
        private final int[] nirIndex;
        private final InnerColumnBoolean varColumn;

        public EvinceWavelengthIndex(DataSet dataSet) {
            this.dataSet = dataSet;
            VariablesInfo variablesInfo = dataSet.getVarDataInfo();
            this.varColumn = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
            this.nirIndex = EvinceWavelengthIndex.createNirIndex(dataSet);
        }

        public void excludeNoneNirVariables() {
            if (this.nirIndex != null && this.nirIndex.length > 0) {
                for (int i = 0; i < this.nirIndex[0]; ++i) {
                    this.varColumn.setValueBool(i, false);
                }
            }
        }

        private static int[] createNirIndex(DataSet dataSet) {
            try {
                InnerColumnClass innerColumnClass = dataSet.getCategory((AbstractDataInfo)dataSet.getVarDataInfo(), "Datatype");
                return innerColumnClass.getClassIndexInt("NIR");
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void includeAll() {
            this.varColumn.fillColumn(true);
        }

        public void excludeAll() {
            this.varColumn.fillColumn(false);
        }

        public int getIndex(int n) {
            if (this.nirIndex != null && n < this.nirIndex.length) {
                return this.nirIndex[n];
            }
            return n;
        }

        public void setValue(int n, boolean bl) {
            this.varColumn.setValueBool(this.getIndex(n), bl);
        }

        public boolean getValue(int n) {
            return this.varColumn.getValueBool(this.getIndex(n));
        }

        public int getWavelengthCount() {
            if (this.nirIndex != null) {
                return this.nirIndex.length;
            }
            VariablesInfo variablesInfo = this.dataSet.getVarDataInfo();
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
            int n = 0;
            for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                if (!innerColumnBoolean.getValueBool(i)) continue;
                ++n;
            }
            return n;
        }
    }
}

