/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import no.uib.cipr.matrix.DenseVector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.entry.analyse.model.CommonModelSettings;
import se.prediktera.breeze.frontend.common.view.EmptyModel;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;

public class CommonModelSettingsTest {
    @Test
    public void testVariableImportance() {
        TestModel testModel = new TestModel();
        MatcherAssert.assertThat((Object)((int)CommonModelSettings.getVariableImportance(testModel, 0, true)), (Matcher)CoreMatchers.is((Object)216));
        MatcherAssert.assertThat((Object)((int)CommonModelSettings.getVariableImportance(testModel, 0, false)), (Matcher)CoreMatchers.is((Object)185));
    }

    private static ModelMatrix createMatrix(double[][] dArray) {
        ModelMatrix modelMatrix = new ModelMatrix(null, (int[])null);
        modelMatrix.setRowType(4);
        modelMatrix.setColumnType(8);
        for (double[] dArray2 : dArray) {
            modelMatrix.addRow(new DenseVector(dArray2));
        }
        return modelMatrix;
    }

    private static class TestModel
    extends EmptyModel {
        private final ModelMatrix w = CommonModelSettingsTest.createMatrix(new double[][]{{-1.5}, {2.5}, {3.5}});
        private final ModelMatrix r2y = CommonModelSettingsTest.createMatrix(new double[][]{{0.5}, {0.3}, {0.1}});

        @Override
        public AbstractDataMatrix getMatrixByName(String string) {
            if (string.equalsIgnoreCase("w")) {
                return this.w;
            }
            if (string.equalsIgnoreCase("r2y")) {
                return this.r2y;
            }
            return null;
        }
    }
}

