/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.util.List;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.ClassificationModel;
import se.prediktera.breeze.entry.analyse.model.DefaultModel;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.util.curveseparation.CurveSeparationStatisticsInfo;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.model.AbstractModel;

public class CurveSeparationModel
extends DefaultModel
implements Model.IClassificationModel {
    private CurveSeparationStatisticsInfo.CurveAreas curveAreas = new CurveSeparationStatisticsInfo.CurveAreas();

    public CurveSeparationModel(BreezeProgress breezeProgress, Analyse analyse) {
        this(breezeProgress, analyse, (List<FactorOrDescriptor>)null);
    }

    public CurveSeparationModel(BreezeProgress breezeProgress, Analyse analyse, List<FactorOrDescriptor> list) {
        super(breezeProgress, analyse, list);
        this.parseCurveAreas(analyse);
    }

    public CurveSeparationModel(BreezeProgress breezeProgress, Analyse analyse, AbstractModel abstractModel) {
        super(breezeProgress, analyse, abstractModel);
        CategoryFactor categoryFactor = analyse.getWorkflow().getCategoryFactors().getByName(analyse.getCategoryFactor().getName());
        this.setVariables(List.of(categoryFactor));
        this.parseCurveAreas(analyse);
    }

    private void parseCurveAreas(Analyse analyse) {
        Node node = analyse.getSetupXmlNode();
        if (node != null) {
            this.curveAreas = new CurveSeparationStatisticsInfo.CurveAreas(node);
        }
    }

    @Override
    protected void addDefaultModifications(BreezeProgressManager breezeProgressManager) {
    }

    public CurveSeparationStatisticsInfo.CurveAreas getCurves() {
        return this.curveAreas;
    }

    @Override
    protected void clearModel(Model.ModelStatus modelStatus, boolean bl) {
    }

    @Override
    public void createModel(BreezeProgressManager breezeProgressManager) {
        CategoryFactor categoryFactor = this.getFactor();
        ClassificationModel.excludeNoClass(breezeProgressManager, this.dataSet, categoryFactor);
        Properties properties = new Properties();
        properties.put("rethrowexceptions", "true");
        properties.put("crossvalidation", "false");
        properties.put("maxcomponents", "0");
        this.model = this.dataSet.createModel((ProgressManager)breezeProgressManager, "pca", properties);
        this.model.setName(this.analyse.getUid());
        ModelProperties.setFromProperties(breezeProgressManager, this.model, this.analyse, false);
        this.model.setEnabled(true);
        if (this.curveAreas.isEmpty()) {
            this.curveAreas.add(this.createDefaultCurve(0));
        }
    }

    @Override
    public void updateSampleInclusionAndTestFlags(ProgressManager progressManager, boolean[] blArray, boolean[] blArray2) {
        super.updateSampleInclusionAndTestFlags(progressManager, blArray, blArray2);
        ClassificationModel.excludeNoClass(progressManager, this.dataSet, this.getFactor());
    }

    public CurveSeparationStatisticsInfo.CurveClass createDefaultCurve(int n) {
        AbstractDataMatrix abstractDataMatrix = this.model.getMatrixByName("Xres");
        MinMax minMax = new MinMax();
        MinMax minMax2 = new MinMax();
        for (int i = 0; i < abstractDataMatrix.getN(); ++i) {
            minMax.add((float)abstractDataMatrix.getValue(i, 0));
            minMax2.add((float)abstractDataMatrix.getValue(i, 1));
        }
        return new CurveSeparationStatisticsInfo.CurveClass(minMax, minMax2, n);
    }

    @Override
    public CategoryFactor getFactor() {
        if (this.selectedProperties != null && this.selectedProperties.size() > 0) {
            return (CategoryFactor)this.selectedProperties.get(0);
        }
        return null;
    }

    public List<CategoryFactor> getSelectedVariables() {
        CategoryFactor categoryFactor = this.getFactor();
        if (categoryFactor != null) {
            return List.of(categoryFactor);
        }
        if (!this.getAllVariables(this.segmentationLevel, null).isEmpty()) {
            return List.of((CategoryFactor)this.getAllVariables(this.segmentationLevel, null).get(0));
        }
        return List.of();
    }

    @Override
    public List<FactorOrDescriptor> getAllVariables(int n, String string) {
        return FactorOrDescriptor.toList(this.analyse.getWorkflow().getCategoryFactors());
    }

    @Override
    public List<String> getModelVariables() {
        return super.getModelVariables();
    }

    @Override
    public void saveXml(Element element) {
        super.saveXml(element);
        this.curveAreas.save(element);
    }

    @Override
    public void finishAndSave(BreezeProgressManager breezeProgressManager) {
        this.analyse.getCategoryFactors().clear();
        this.analyse.getCategoryFactors().add((CategoryFactor)this.getFactor().cloneKeepId());
        this.analyse.addModelPropertiesToAnalyse(this.model);
        this.commonModelSettings.saveEvinceModel(breezeProgressManager);
        this.analyse.save(this);
    }

    @Override
    public void balanceTrainData(BreezeProgress breezeProgress, boolean bl, boolean bl2) {
    }

    public RtModelParameters.RtModel createRtModel() {
        RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel("CurveSeparation");
        RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Base");
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("curves", this.curveAreas.size()));
        rtModel.getModules().add(rtModuleSetup);
        int n = 1;
        for (CurveSeparationStatisticsInfo.CurveClass curveClass : this.curveAreas) {
            RtModelParameters.RtModuleSetup rtModuleSetup2 = new RtModelParameters.RtModuleSetup("curve" + n++);
            rtModuleSetup2.add(new RtModelParameters.RtParameterVector("p1", curveClass.p1.array()));
            rtModuleSetup2.add(new RtModelParameters.RtParameterVector("p2", curveClass.p2.array()));
            rtModuleSetup2.add(new RtModelParameters.RtParameterVector("p3", curveClass.p3.array()));
            rtModel.getModules().add(rtModuleSetup2);
        }
        return rtModel;
    }
}

