/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.w3c.dom.Element;
import se.prediktera.breeze.common.entry.factor.FactorList;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.CommonModelSettings;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelIncludedSamplesSettings;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.analyse.model.ModelVariableSettings;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.evince.data.DataTemplatesHelper;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.evince.datasource.MeasurementImportInfo;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.LoadHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public abstract class DefaultModel
implements Model.ModelWithSample {
    protected final Analyse analyse;
    protected int segmentationLevel = -1;
    protected String segmentationHashId = null;
    protected List<FactorOrDescriptor> selectedProperties = new ArrayList<FactorOrDescriptor>();
    protected DataSet dataSet;
    protected CommonModelSettings commonModelSettings;
    protected ModelIncludedSamplesSettings includedSamplesSettings;
    protected AbstractModel model;

    public DefaultModel(BreezeProgress breezeProgress, Analyse analyse, List<FactorOrDescriptor> list) {
        this.analyse = analyse;
        Integer n = analyse.getSegmentationIdentifier().Level;
        String string = analyse.getSegmentationIdentifier().HashId;
        FactorList factorList = analyse.getFactorList();
        if (factorList != null) {
            for (Object f : factorList) {
                this.selectedProperties.add((FactorOrDescriptor)f);
            }
        }
        int n2 = analyse.getWorkflow().getVisualisationNode().getLastSegmentationLevel();
        if (n < 0 || n > n2) {
            n = n2;
        }
        this.setSegmentationLevel((BreezeProgressManager)breezeProgress, n, string, Model.ModelStatus.Normal);
    }

    public DefaultModel(BreezeProgress breezeProgress, Analyse analyse, AbstractModel abstractModel) {
        this.analyse = analyse;
        this.model = abstractModel;
        this.dataSet = abstractModel.getDataSet();
        this.commonModelSettings = new CommonModelSettings(analyse, this.dataSet, abstractModel);
        this.segmentationLevel = 0;
        this.includedSamplesSettings = new ModelIncludedSamplesSettings(analyse, this.dataSet, this.segmentationLevel, this.segmentationHashId);
    }

    protected void modelSettings(Properties properties) {
        XmlProperties xmlProperties = this.analyse.getProperties();
        properties.put("crossvalidation", xmlProperties.getPropertyBoolLocal("modelling/crossvalidation", true) ? "true" : "false");
        properties.put("cvfull", xmlProperties.getPropertyBoolLocal("modelling/cvFull", false) ? "true" : "false");
        properties.put("cvtype", xmlProperties.getPropertyLocal("modelling/cvType", "EvenlySpread"));
        properties.put("cvgroups", xmlProperties.getPropertyLocal("modelling/cvGroups", "7"));
        properties.put("cvcategory", xmlProperties.getPropertyLocal("modelling/cvCategory", ""));
        properties.put("dmodx", "false");
    }

    @Override
    public final void setVariables(List<FactorOrDescriptor> list) {
        this.selectedProperties = list;
    }

    @Override
    public boolean setSegmentationLevel(BreezeProgressManager breezeProgressManager, int n, String string, Model.ModelStatus modelStatus) {
        if (this.segmentationLevel != n || this.segmentationHashId != string || !modelStatus.equals((Object)Model.ModelStatus.Normal)) {
            boolean bl = this.segmentationLevel != n;
            this.segmentationLevel = n;
            this.segmentationHashId = string;
            if (this.dataSet != null) {
                this.dataSet.close();
                this.clearModel(modelStatus, bl);
            }
            MeasurementDataSource measurementDataSource = new MeasurementDataSource(this.analyse, this, new SegmentationIdentifier(this.segmentationLevel, this.segmentationHashId));
            measurementDataSource.autoIdentifyData(breezeProgressManager, Integer.MAX_VALUE);
            Project_GUI project_GUI = Project_GUI.createNewProject((boolean)false, (String)this.analyse.getUid());
            this.dataSet = LoadHelper.loadDataSource((Project_GUI)project_GUI, (ProgressManager)breezeProgressManager, (AbstractImportInfo)new MeasurementImportInfo(), (CellIdentifierModel)measurementDataSource, (Properties)new Properties());
            if (this.dataSet != null) {
                this.addDefaultModifications(breezeProgressManager);
                this.commonModelSettings = new CommonModelSettings(this.analyse, this.dataSet);
                this.includedSamplesSettings = new ModelIncludedSamplesSettings(this.analyse, measurementDataSource, this.dataSet, this.segmentationLevel, this.segmentationHashId, !modelStatus.equals((Object)Model.ModelStatus.Reset) && this.analyse.getSegmentationIdentifier().Level == this.segmentationLevel);
                return true;
            }
        }
        return false;
    }

    protected void clearModel(Model.ModelStatus modelStatus, boolean bl) {
    }

    protected void addDefaultModifications(BreezeProgressManager breezeProgressManager) {
        this.dataSet.createModification((ProgressManager)breezeProgressManager, "var", "center");
    }

    @Override
    public void saveXml(Element element) {
        ModelVariableSettings.saveSegmentationIdentifier(element, this.segmentationLevel, this.segmentationHashId);
        this.includedSamplesSettings.saveXml(element);
        this.commonModelSettings.saveXml(element, this.model);
    }

    @Override
    public Analyse getAnalyse() {
        return this.analyse;
    }

    @Override
    public AbstractModel getModel() {
        return this.model;
    }

    public void setModel(AbstractModel abstractModel) {
        this.model = abstractModel;
    }

    @Override
    public void applyChanges(ProgressManager progressManager) {
        this.dataSet.applyChanges(progressManager);
    }

    @Override
    public int getSegmentationLevel() {
        return this.segmentationLevel;
    }

    @Override
    public String getSegmentationHashId() {
        return this.segmentationHashId;
    }

    @Override
    public void updateTransformation(ModelProperties.TransformationProperties transformationProperties) {
        this.commonModelSettings.updateTransformation(transformationProperties);
    }

    @Override
    public HashMap<Model.Transformation, ModelProperties.TransformationProperties> getTransformations() {
        return this.commonModelSettings.getTransformations();
    }

    @Override
    public boolean isWavelengthIndexIncluded(int n) {
        return this.commonModelSettings.isWavelengthIndexIncluded(n);
    }

    @Override
    public float getWavelengthImportance(int n) {
        return this.commonModelSettings.getWavelengthImportance(this.model, n);
    }

    @Override
    public void updateIncludedWavelengths(boolean[] blArray) {
        this.commonModelSettings.updateIncludedWavelengths(blArray);
    }

    @Override
    public List<String> getModelVariables() {
        return this.includedSamplesSettings.getModelVariables();
    }

    @Override
    public boolean sampleIsIncluded(int n) {
        return this.includedSamplesSettings.sampleIsIncluded(n);
    }

    @Override
    public boolean sampleIsIncludedForTest(int n) {
        return this.includedSamplesSettings.sampleIsIncludedForTest(n);
    }

    @Override
    public List<Sample> getIncludedSampleList() {
        return this.includedSamplesSettings.getIncludedSampleList();
    }

    @Override
    public void updateSampleInclusionAndTestFlags(ProgressManager progressManager, boolean[] blArray, boolean[] blArray2) {
        this.includedSamplesSettings.updateSampleInclusionAndTestFlags(progressManager, blArray, blArray2);
    }

    @Override
    public void updateSampleInclusionAndTestFlags(ProgressManager progressManager, List<Sample> list, boolean bl, boolean bl2) {
        this.includedSamplesSettings.updateSampleInclusionAndTestFlags(progressManager, list, bl, bl2);
    }

    @Override
    public void close() {
        Project_GUI project_GUI;
        if (this.dataSet != null && (project_GUI = this.dataSet.getProject_GUI()) != null) {
            project_GUI.closeProjectNow();
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public AbstractDataMatrix getEvinceMatrix(BreezeProgress breezeProgress, String string) {
        if (string.equals("origmatrix")) {
            return this.dataSet.getOriginalMatrix();
        }
        if (string.equals("xtraining") || string.equals("xtr")) {
            return this.dataSet.getMatrix(0);
        }
        if (string.startsWith("model")) {
            return DataTemplatesHelper.getMatrix(this.model, string);
        }
        throw new RuntimeException("Model: No such matrix type " + string);
    }

    @Override
    public ModelProperties.CriticalValues getCriticalValues() {
        return new ModelProperties.CriticalValues(this.model, this.analyse);
    }

    protected static abstract class BalanceModel {
        protected final DataSet dataSet;
        protected final ObservationInfo dataInfo;

        public BalanceModel(DataSet dataSet) {
            this.dataSet = dataSet;
            this.dataInfo = dataSet.getObsDataInfo();
        }

        public void performAnalysis(BreezeProgress breezeProgress, boolean bl, boolean bl2) {
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.dataInfo.getPrimaryColumnByType(1);
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)this.dataInfo.getPrimaryColumnByType(5);
            BooleanArray booleanArray = new BooleanArray(innerColumnBoolean.getSize());
            this.createBooleanArray(booleanArray, this.createIndexList(bl), bl2);
            innerColumnBoolean.beginUpdate();
            for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                if (innerColumnBoolean2.getValueBool(i)) continue;
                innerColumnBoolean.setValueBool(i, booleanArray.get(i));
            }
            innerColumnBoolean.endUpdate();
            this.dataInfo.triggerObsVarIncExc();
        }

        protected abstract ArrayList<Integer>[] createIndexList(boolean var1);

        protected ArrayList<Integer>[] allocateIndexList(int n) {
            ArrayList[] arrayListArray = new ArrayList[n];
            for (int i = 0; i < arrayListArray.length; ++i) {
                arrayListArray[i] = new ArrayList();
            }
            return arrayListArray;
        }

        protected void createBooleanArray(BooleanArray booleanArray, ArrayList<Integer>[] arrayListArray, boolean bl) {
            int n = Integer.MAX_VALUE;
            for (int i = 1; i < arrayListArray.length; ++i) {
                if (arrayListArray[i].size() <= 0 || n <= arrayListArray[i].size()) continue;
                n = arrayListArray[i].size();
            }
            double d = n;
            if (this.useMedian()) {
                d = this.calculateMedian(arrayListArray);
            }
            for (ArrayList<Integer> arrayList : arrayListArray) {
                if (bl) {
                    Collections.shuffle(arrayList, new Random(0L));
                }
                double d2 = Math.min((double)arrayList.size(), d);
                double d3 = (double)arrayList.size() / d2;
                double d4 = 0.0;
                int n2 = 0;
                while ((double)n2 < d2) {
                    if (d4 < (double)arrayList.size()) {
                        booleanArray.set(arrayList.get((int)d4).intValue());
                    }
                    ++n2;
                    d4 += d3;
                }
            }
        }

        private double calculateMedian(ArrayList<Integer>[] arrayListArray) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (ArrayList<Integer> arrayList2 : arrayListArray) {
                if (arrayList2.size() <= 0) continue;
                arrayList.add(arrayList2.size());
            }
            Collections.sort(arrayList);
            if (arrayList.size() > 1 && arrayList.size() % 2 == 0) {
                double d = (Integer)arrayList.get(arrayList.size() / 2) + (Integer)arrayList.get(arrayList.size() / 2 - 1);
                return d / 2.0;
            }
            return ((Integer)arrayList.get(arrayList.size() / 2)).intValue();
        }

        protected boolean useMedian() {
            return false;
        }
    }
}

