/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jblas.FloatMatrix;
import org.jblas.Solve;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationDescriptor;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.ObjectHolder;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.entry.analyse.model.CurveSeparationModel;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.cr.ContinuumRemovalTransform;
import se.prediktera.map.datasetcontainer.transform.derivative.Derivative;
import se.prediktera.map.datasetcontainer.transform.savitzky.Savitzky;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.output.OutputClass;

public class EvinceModelParameters
extends RtModelParameters {
    public EvinceModelParameters(File file) {
        this(BreezeProgressManager.createEmpty(), file);
    }

    public EvinceModelParameters(BreezeProgressManager breezeProgressManager, File file) {
        this(EvinceScriptCommands.loadModelList((ProgressManager)breezeProgressManager, (String)file.getAbsolutePath()));
    }

    public EvinceModelParameters(AbstractModel abstractModel) {
        this(Collections.singletonList(abstractModel));
    }

    public EvinceModelParameters(BreezeProgress breezeProgress, Workflow workflow, BasicAnalyse basicAnalyse) {
        BasicAnalyse.ModelMethod modelMethod = basicAnalyse.getModelMethod();
        if (basicAnalyse.getObjectMethod() instanceof MembersSetting) {
            this.addModel(((MembersSetting)basicAnalyse.getObjectMethod()).createRtModel(workflow, true));
        } else if (modelMethod == BasicAnalyse.ModelMethod.ClassificationUsgs || modelMethod == BasicAnalyse.ModelMethod.QuantificationExpression || modelMethod == BasicAnalyse.ModelMethod.ClassificationExpression || modelMethod == BasicAnalyse.ModelMethod.QuantificationSaturation || modelMethod == BasicAnalyse.ModelMethod.QuantificationMwl || modelMethod == BasicAnalyse.ModelMethod.ClassificationObject || modelMethod == BasicAnalyse.ModelMethod.QuantificationPca || modelMethod == BasicAnalyse.ModelMethod.ClassificationCluster || modelMethod == BasicAnalyse.ModelMethod.ClassificationRgb || modelMethod == BasicAnalyse.ModelMethod.ClassificationDataSlicing || modelMethod == BasicAnalyse.ModelMethod.QuantificationRgb) {
            this.addModel(basicAnalyse.getModelParameters(breezeProgress, workflow).getModel());
        } else if (modelMethod == BasicAnalyse.ModelMethod.ClassificationCurveSeparation) {
            List<AbstractModel> list = ((Analyse)basicAnalyse).getModels((BreezeProgressManager)breezeProgress);
            this.addModel(new CurveSeparationModel(breezeProgress, (Analyse)basicAnalyse, list.get(0)).createRtModel());
        } else if (modelMethod == BasicAnalyse.ModelMethod.ClassificationRuntime || modelMethod == BasicAnalyse.ModelMethod.QuantificationRuntime || modelMethod == BasicAnalyse.ModelMethod.ClassificationANN || modelMethod == BasicAnalyse.ModelMethod.SampleRuntime) {
            File file;
            Analyse analyse = (Analyse)basicAnalyse;
            List<AbstractModel> list = analyse.getModels((BreezeProgressManager)breezeProgress);
            AbstractModel abstractModel = list.get(0);
            double d = abstractModel.getCutOffLow();
            if (modelMethod == BasicAnalyse.ModelMethod.ClassificationANN) {
                file = analyse.getModelDataFile();
            } else {
                file = analyse.getOnnxFile();
                if (modelMethod == BasicAnalyse.ModelMethod.SampleRuntime) {
                    d = abstractModel.getDcritX();
                }
            }
            DescriptorTreeNode descriptorTreeNode = EvinceModelParameters.getStoreConfidenceNode(workflow, basicAnalyse);
            if (descriptorTreeNode != null) {
                if (basicAnalyse.getPropertyFactors().size() == 0) {
                    basicAnalyse.getPropertyFactors().add(PropertyFactor.createConfidence());
                }
            } else if (modelMethod == BasicAnalyse.ModelMethod.ClassificationRuntime) {
                basicAnalyse.getPropertyFactors().clear();
            }
            RtModelParameters.RtModel rtModel = AbstractRuntimeModel.createRtModel(basicAnalyse, file, d, descriptorTreeNode != null);
            this.setVariableInfo(abstractModel);
            EvinceModelParameters.addModules(abstractModel, rtModel.getForward(), Type.Forward);
            this.addModel(rtModel);
        } else if (basicAnalyse instanceof Analyse) {
            Analyse analyse = (Analyse)basicAnalyse;
            DescriptorTreeNode descriptorTreeNode = EvinceModelParameters.getStoreConfidenceNode(workflow, basicAnalyse);
            if (descriptorTreeNode != null) {
                workflow.functionErrorId = descriptorTreeNode.getUid();
                throw new ErrorHandler.InformationMessageException("Confidence is only available for ML models");
            }
            this.addModels(analyse.getModels((BreezeProgressManager)breezeProgress));
        }
    }

    public static DescriptorTreeNode getStoreConfidenceNode(Workflow workflow, BasicAnalyse basicAnalyse) {
        ObjectHolder<Object> objectHolder = new ObjectHolder<Object>(null);
        workflow.getAnalyseTree().forEveryFunction((functionTreeNode, abstractBreezeFunction) -> {
            BasicAnalyse basicAnalyse2;
            DescriptorTreeNode descriptorTreeNode;
            if (abstractBreezeFunction instanceof PlsPredClassificationDescriptor && functionTreeNode instanceof DescriptorTreeNode && (descriptorTreeNode = (DescriptorTreeNode)functionTreeNode).getIndex() == 1 && (basicAnalyse2 = abstractBreezeFunction.getAnalyse()) != null && basicAnalyse2.getUid().equals(basicAnalyse.getUid())) {
                objectHolder.set(descriptorTreeNode);
            }
        });
        return objectHolder.getValue();
    }

    public EvinceModelParameters(List<AbstractModel> list) {
        this.addModels(list);
    }

    private void addModels(List<AbstractModel> list) {
        if (list.isEmpty()) {
            throw new RuntimeException("No models");
        }
        AbstractModel abstractModel = list.get(0);
        this.setVariableInfo(abstractModel);
        if (list.size() > 1) {
            this.addModel(this.parseModels(this.getRootModel(list), list, null));
        } else {
            String string = abstractModel.getModelName();
            if (string.equals("PCA")) {
                this.addModel(this.addPCA(abstractModel, false));
            } else if (string.equals("PLS") || string.equals("PLS-DA")) {
                this.addModel(this.addPLS(abstractModel));
            } else if (string.equals("SIMCA")) {
                for (AbstractModel abstractModel2 : EvinceModelParameters.getModels(abstractModel)) {
                    this.addModel(this.addPCA(abstractModel2, true));
                }
            }
        }
    }

    private void setVariableInfo(AbstractModel abstractModel) {
        this.setVariableCount(abstractModel.getDatatypeNIRCount());
        this.setVariableIndex(abstractModel.createIncludedIndexArray());
        this.setVariableNames(abstractModel.createIncDescriptionArray());
    }

    private AbstractModel getRootModel(List<AbstractModel> list) {
        return list.get(0);
    }

    private RtModelParameters.RtModel parseModels(AbstractModel abstractModel, List<AbstractModel> list, CategoryFactor categoryFactor) {
        RtModelParameters.RtModel rtModel = this.addPLS(abstractModel);
        for (AbstractModel abstractModel2 : this.getSortedSubModels(abstractModel, list)) {
            RtModelParameters.RtModel rtModel2 = this.parseModels(abstractModel2, list, categoryFactor);
            rtModel.add(rtModel2);
        }
        return rtModel;
    }

    private List<AbstractModel> getSortedSubModels(AbstractModel abstractModel, List<AbstractModel> list) {
        ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
        for (AbstractModel abstractModel4 : list) {
            if (!abstractModel.equals((Object)abstractModel4.getReplaceModel())) continue;
            arrayList.add(abstractModel4);
        }
        arrayList.sort((abstractModel2, abstractModel3) -> Integer.compare(this.getReplaceIndex(abstractModel, (AbstractModel)abstractModel2), this.getReplaceIndex(abstractModel, (AbstractModel)abstractModel3)));
        return arrayList;
    }

    private int getReplaceIndex(AbstractModel abstractModel, AbstractModel abstractModel2) {
        ClassTypes classTypes = abstractModel.getClassByName(abstractModel.getClassName()).getObject();
        return classTypes.getTypeDescriptionIndex(abstractModel2.getReplaceClassName());
    }

    private RtModelParameters.RtModel addPCA(AbstractModel abstractModel, boolean bl) {
        RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel(abstractModel.getName());
        EvinceModelParameters.addModules(abstractModel, rtModel.getForward(), Type.Forward);
        this.addOutlier(abstractModel, rtModel.getModules(), "S0", bl);
        return rtModel;
    }

    private RtModelParameters.RtModel addPLS(AbstractModel abstractModel) {
        RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel(abstractModel.getName());
        EvinceModelParameters.addModules(abstractModel, rtModel.getForward(), Type.Forward);
        RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Pls");
        if (abstractModel.getComponentsInt() > 0) {
            rtModuleSetup.add(new RtModelParameters.RtParameterMatrix("bprim", EvinceModelParameters.calculateBprim(abstractModel)));
        }
        rtModuleSetup.add(new RtModelParameters.RtParameterStringArray("variables", abstractModel.getVariableArray()));
        DataContainer dataContainer = abstractModel.getOutputContainer();
        OutputClass outputClass = (OutputClass)dataContainer.getTreeNodeAt(0);
        rtModuleSetup.add(new RtModelParameters.RtParameterVector("min", outputClass.getYmin()));
        rtModuleSetup.add(new RtModelParameters.RtParameterVector("max", outputClass.getYmax()));
        rtModel.getModules().add(rtModuleSetup);
        if (abstractModel.getModelName().equals("PLS-DA")) {
            RtModelParameters.RtModuleSetup rtModuleSetup2 = new RtModelParameters.RtModuleSetup("PlsDA");
            rtModuleSetup2.add(new RtModelParameters.RtParameterScalar("cutofflow", abstractModel.getCutOffLow()));
            rtModuleSetup2.add(new RtModelParameters.RtParameterScalar("cutoffhigh", abstractModel.getCutOffHigh()));
            rtModuleSetup2.add(new RtModelParameters.RtParameterStringArray("classes", abstractModel.getClassNames()));
            rtModuleSetup2.add(new RtModelParameters.RtParameterString("class", abstractModel.getReplaceClassName()));
            rtModel.getModules().add(rtModuleSetup2);
        }
        this.addOutlier(abstractModel, rtModel.getModules(), "S0X", false);
        EvinceModelParameters.addModules(abstractModel, rtModel.getReverse(), Type.Reverse);
        return rtModel;
    }

    private void addOutlier(AbstractModel abstractModel, RtModelParameters.RtModuleSetupList rtModuleSetupList, String string, boolean bl) {
        RtModelParameters.RtModuleSetup rtModuleSetup;
        RtModelParameters.RtModuleSetup rtModuleSetup2;
        if (abstractModel.isUseDcrit() || bl) {
            rtModuleSetup2 = new RtModelParameters.RtModuleSetup("DmodX");
            rtModuleSetup2.add(new RtModelParameters.RtParameterMatrix("p", EvinceModelParameters.getModelData(abstractModel, "P")));
            try {
                rtModuleSetup2.add(new RtModelParameters.RtParameterMatrix("w", EvinceModelParameters.getModelData(abstractModel, "W")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            rtModuleSetup2.add(new RtModelParameters.RtParameterMatrix("s0", EvinceModelParameters.getModelData(abstractModel, string)));
            rtModuleSetupList.add(rtModuleSetup2);
            rtModuleSetup = new RtModelParameters.RtModuleSetup("Dcrit");
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar("dcrit", abstractModel.getDcritX()));
            rtModuleSetupList.add(rtModuleSetup);
        }
        if (abstractModel.isUseHotelling()) {
            rtModuleSetup2 = new RtModelParameters.RtModuleSetup("Tpred");
            rtModuleSetup2.add(new RtModelParameters.RtParameterMatrix("p", EvinceModelParameters.getModelData(abstractModel, "P")));
            rtModuleSetup2.add(new RtModelParameters.RtParameterScalar("components", abstractModel.getComponentsInt()));
            rtModuleSetupList.add(rtModuleSetup2);
            rtModuleSetup = new RtModelParameters.RtModuleSetup("Hotelling");
            rtModuleSetup.add(new RtModelParameters.RtParameterMatrix("r2x", EvinceModelParameters.getModelData(abstractModel.getR2X())));
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar("hotellingt2", abstractModel.getHotellingt2()));
            rtModuleSetupList.add(rtModuleSetup);
        }
    }

    public static FloatMatrix calculateBprim(AbstractModel abstractModel) {
        FloatMatrix floatMatrix = EvinceModelParameters.getModelData(abstractModel, "P");
        FloatMatrix floatMatrix2 = EvinceModelParameters.getModelData(abstractModel, "W");
        FloatMatrix floatMatrix3 = EvinceModelParameters.getModelData(abstractModel, "C");
        return floatMatrix2.mmul(Solve.pinv((FloatMatrix)floatMatrix.transpose().mmul(floatMatrix2)).mmul(floatMatrix3.transpose())).transpose();
    }

    public static FloatMatrix getModelData(AbstractModel abstractModel, String string) {
        return EvinceModelParameters.getModelData((ModelMatrix)abstractModel.get(string));
    }

    public static FloatMatrix getModelData(ModelMatrix modelMatrix) {
        return new FloatMatrix(modelMatrix.getFloatData());
    }

    private static void addModules(AbstractModel abstractModel, RtModelParameters.RtModuleSetupList rtModuleSetupList, Type type) {
        AbstractDataMatrix abstractDataMatrix = abstractModel.getMatrixByName(type.equals((Object)Type.Reverse) ? "Yres" : "Xres");
        for (int i = 0; i < abstractDataMatrix.getTreeNodeCount(); ++i) {
            RtModelParameters.RtModuleSetup rtModuleSetup;
            RtModelParameters.RtModuleSetup rtModuleSetup2;
            AbstractTransform abstractTransform;
            Object object = abstractDataMatrix.getTreeNodeAt(i);
            if (!(object instanceof AbstractTransform) || !(abstractTransform = (AbstractTransform)object).isTransformationEnabled()) continue;
            object = abstractTransform.getShortName();
            if (type.equals((Object)Type.Reverse)) {
                if (!((String)object).equalsIgnoreCase("center") && !((String)object).equalsIgnoreCase("uv")) continue;
                EvinceModelParameters.createModule(rtModuleSetupList, abstractTransform.getIntermediateData(), (String)object, type);
                continue;
            }
            if (!EvinceModelParameters.transformationImplicesToVariables(abstractTransform, abstractModel.getDataSet(), true)) continue;
            if (((String)object).equalsIgnoreCase("snv") || ((String)object).equalsIgnoreCase("center") || ((String)object).equalsIgnoreCase("uv") || ((String)object).equalsIgnoreCase("derivative") || ((String)object).equalsIgnoreCase("log")) {
                rtModuleSetup2 = EvinceModelParameters.createModule(rtModuleSetupList, abstractTransform.getIntermediateData(), (String)object, type);
                if (((String)object).equalsIgnoreCase("derivative")) {
                    rtModuleSetup2.add(new RtModelParameters.RtParameterScalar("type", ((Derivative)abstractTransform).getUsedType()));
                }
            }
            if (((String)object).equalsIgnoreCase("savitzky-golay")) {
                rtModuleSetup2 = (Savitzky)abstractTransform;
                rtModuleSetup = EvinceModelParameters.createModule(rtModuleSetupList, rtModuleSetup2.createVector(), (String)object, type);
                rtModuleSetup.add(new RtModelParameters.RtParameterScalar("left", rtModuleSetup2.getUsedLeft()));
                rtModuleSetup.add(new RtModelParameters.RtParameterScalar("right", rtModuleSetup2.getUsedRight()));
                rtModuleSetup.add(new RtModelParameters.RtParameterScalar("version", rtModuleSetup2.getUsedVersion()));
            }
            if (!((String)object).equalsIgnoreCase("continuumremoval")) continue;
            rtModuleSetup2 = (ContinuumRemovalTransform)abstractTransform;
            rtModuleSetup = EvinceModelParameters.createModule(rtModuleSetupList, rtModuleSetup2.getIntermediateData(), (String)object, type);
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar("leftoffset", rtModuleSetup2.getLeftOffset()));
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar("rightoffset", rtModuleSetup2.getRightOffset()));
        }
    }

    private static boolean transformationImplicesToVariables(AbstractTransform abstractTransform, DataSet dataSet, boolean bl) {
        if (dataSet != null) {
            VariablesInfo variablesInfo = dataSet.getVarDataInfo();
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)abstractTransform.getInnerColumn();
            for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                if (innerColumnBoolean.getValueBool(i) != bl || !innerColumnBoolean2.getValueBool(i)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static RtModelParameters.RtModuleSetup createModule(RtModelParameters.RtModuleSetupList rtModuleSetupList, double[] dArray, String string, Type type) {
        RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup(string);
        if (dArray != null) {
            rtModuleSetup.add(new RtModelParameters.RtParameterVector("vector", dArray));
        }
        if (type.equals((Object)Type.Forward)) {
            rtModuleSetupList.add(rtModuleSetup);
        } else {
            rtModuleSetupList.insert(rtModuleSetup);
        }
        return rtModuleSetup;
    }

    public static List<AbstractModel> getModels(AbstractModel abstractModel) {
        ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
        for (int i = 0; i < abstractModel.getTreeNodeCount(); ++i) {
            if (!(abstractModel.getTreeNodeAt(i) instanceof AbstractModel)) continue;
            arrayList.add((AbstractModel)abstractModel.getTreeNodeAt(i));
        }
        return arrayList;
    }

    public static enum Type {
        Forward,
        Reverse;

    }
}

