/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.analyse.model.SampleModel;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.center.TCenterInfo;
import se.prediktera.map.datasetcontainer.transform.cr.ContinuumRemovalInfo;
import se.prediktera.map.datasetcontainer.transform.derivative.DerivativeInfo;
import se.prediktera.map.datasetcontainer.transform.logarithm.LogarithmInfo;
import se.prediktera.map.datasetcontainer.transform.savitzky.SavitzkyInfo;
import se.prediktera.map.datasetcontainer.transform.snv.SnvInfo;
import se.prediktera.map.datasetcontainer.transform.uvscale.TUVScaleInfo;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.model.AbstractModel;

public interface Model {
    public void saveXml(Element var1);

    public AbstractDataMatrix getEvinceMatrix(BreezeProgress var1, String var2);

    public void applyChanges(ProgressManager var1);

    public void updateTransformation(ModelProperties.TransformationProperties var1);

    public void updateIncludedWavelengths(boolean[] var1);

    public HashMap<Transformation, ModelProperties.TransformationProperties> getTransformations();

    public List<Sample> getIncludedSampleList();

    public boolean isWavelengthIndexIncluded(int var1);

    public float getWavelengthImportance(int var1);

    public void finishAndSave(BreezeProgressManager var1);

    public void close();

    public ModelProperties.CriticalValues getCriticalValues();

    public Analyse getAnalyse();

    public AbstractModel getModel();

    public static AbstractModel getEvinceModel(Model model) {
        if (model instanceof ModelWithSample) {
            ModelWithSample modelWithSample = (ModelWithSample)model;
            return modelWithSample.getModel();
        }
        if (model instanceof SampleModel) {
            SampleModel sampleModel = (SampleModel)model;
            return sampleModel.getModel();
        }
        return null;
    }

    public static interface ModelWithSample
    extends Model {
        @Override
        public Analyse getAnalyse();

        public int getSegmentationLevel();

        public String getSegmentationHashId();

        default public SegmentationIdentifier getSegmentationIdentifier() {
            return new SegmentationIdentifier(this.getSegmentationLevel(), this.getSegmentationHashId());
        }

        public boolean sampleIsIncluded(int var1);

        public boolean sampleIsIncludedForTest(int var1);

        public void updateSampleInclusionAndTestFlags(ProgressManager var1, boolean[] var2, boolean[] var3);

        public void updateSampleInclusionAndTestFlags(ProgressManager var1, List<Sample> var2, boolean var3, boolean var4);

        public List<String> getModelVariables();

        public List<? extends FactorOrDescriptor> getSelectedVariables();

        public List<FactorOrDescriptor> getAllVariables(int var1, String var2);

        public void setVariables(List<FactorOrDescriptor> var1);

        public boolean setSegmentationLevel(BreezeProgressManager var1, int var2, String var3, ModelStatus var4);

        public void createModel(BreezeProgressManager var1);

        public void balanceTrainData(BreezeProgress var1, boolean var2, boolean var3);
    }

    public static interface IClassificationModel {
        public CategoryFactor getFactor();
    }

    public static enum ModelStatus {
        Normal,
        Reload,
        Reset;

    }

    public static enum Transformation {
        SavitzkyGolay(false, (AbstractInfo)new SavitzkyInfo(), "Savitzky-Golay Smoothing", "savitzkygolay", 10),
        ContinuumRemoval(false, (AbstractInfo)new ContinuumRemovalInfo(), "Continuum removal", "continuumremoval", 15),
        Derivative(false, (AbstractInfo)new DerivativeInfo(), "Derivative", "derivative", 9),
        SNV(true, (AbstractInfo)new SnvInfo(), "Standard Normal Variate correction", "snv", 11),
        Logarithm(false, (AbstractInfo)new LogarithmInfo(), "Logarithm", "logarithm", 7),
        Center(true, (AbstractInfo)new TCenterInfo(), "Center", "center", 0),
        UvScale(false, (AbstractInfo)new TUVScaleInfo(), "UV Scale", "uvscale", 1);

        private final boolean def;
        private final String infoName;
        private final String evinceName;
        private final String xmlName;
        private final int treeType;

        private Transformation(boolean bl, AbstractInfo abstractInfo, String string2, String string3, int n2) {
            this.def = bl;
            this.evinceName = string2;
            this.xmlName = string3;
            this.treeType = n2;
            this.infoName = abstractInfo != null ? abstractInfo.toString() : "";
        }

        public String getInfoName() {
            return this.infoName;
        }

        public String getEvinceName() {
            return this.evinceName;
        }

        public String getXmlName() {
            return this.xmlName;
        }

        public boolean isDefault() {
            return this.def;
        }

        public int getTreeType() {
            return this.treeType;
        }
    }
}

