/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.UidIndex;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.util.CompactIntegerList;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;

public class ModelIncludedSamplesSettings {
    private final Analyse analyse;
    private final MeasurementDataSource measurementDataSource;
    private final DataSet dataSet;
    private final int segmentationIndex;
    private final String segmentationHashId;
    private final boolean setupXmlValid;

    public ModelIncludedSamplesSettings(Analyse analyse, MeasurementDataSource measurementDataSource, DataSet dataSet, int n, String string, boolean bl) {
        this.analyse = analyse;
        this.measurementDataSource = measurementDataSource;
        this.dataSet = dataSet;
        this.segmentationIndex = n;
        this.segmentationHashId = string;
        this.setupXmlValid = bl;
        this.parseIncludedAndTest();
    }

    public ModelIncludedSamplesSettings(Analyse analyse, DataSet dataSet, int n, String string) {
        this.analyse = analyse;
        this.dataSet = dataSet;
        this.segmentationIndex = n;
        this.segmentationHashId = string;
        this.setupXmlValid = false;
        ArrayList<BasicSample> arrayList = new ArrayList<BasicSample>();
        int[] nArray = dataSet.getMatrix(0).getNref();
        List<Measurement> list = analyse.getWorkflow().getAllMeasurements();
        for (int n2 : nArray) {
            if (n2 >= list.size()) continue;
            arrayList.add(list.get(n2).getRootSample());
        }
        this.measurementDataSource = new MeasurementDataSource(arrayList);
    }

    private void parseIncludedAndTest() {
        ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(1);
        InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(4);
        InnerColumnBoolean innerColumnBoolean3 = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(5);
        UidIndex.UidIndexList uidIndexList = ModelIncludedSamplesSettings.parse(this.getValidSetupXml(), "sample");
        UidIndex.UidIndexList uidIndexList2 = ModelIncludedSamplesSettings.parse(this.getValidSetupXml(), "test");
        Measurement measurement = null;
        SampleSegmentationColumn sampleSegmentationColumn = null;
        HashMap<? extends BasicSample, Integer> hashMap = null;
        List<BasicSample> list = this.measurementDataSource.getAllSamples();
        for (int i = 0; i < list.size(); ++i) {
            Sample sample = (Sample)list.get(i);
            Measurement measurement2 = sample.measurement();
            String string = sample.getSegmentationHashId();
            String string2 = measurement2.getUid();
            if (measurement2 != measurement) {
                sampleSegmentationColumn = measurement2.getSamples(new SegmentationIdentifier(this.segmentationIndex, this.segmentationHashId));
                measurement = measurement2;
                hashMap = ModelIncludedSamplesSettings.collectSegmentationIndex(sampleSegmentationColumn);
            }
            Integer n = (Integer)hashMap.get(sample);
            boolean bl = true;
            if (uidIndexList != null && uidIndexList.size() > 0) {
                UidIndex uidIndex = uidIndexList.getUidIndex(string2, string);
                bl = uidIndex != null && uidIndex.hasIndex(n);
            }
            boolean bl2 = false;
            if (uidIndexList2 != null && uidIndexList2.size() > 0) {
                UidIndex uidIndex = uidIndexList2.getUidIndex(string2, string);
                bl2 = uidIndex != null && uidIndex.hasIndex(n);
            }
            innerColumnBoolean.setValueBool(i, bl);
            innerColumnBoolean2.setValueBool(i, !bl2);
            innerColumnBoolean3.setValueBool(i, bl2);
        }
    }

    private Node getValidSetupXml() {
        if (this.setupXmlValid) {
            return this.analyse.getSetupXmlNode();
        }
        return null;
    }

    public static UidIndex.UidIndexList parse(Node node, String string) {
        if (node == null || !XmlParserHelper.hasNode(node, string + "s")) {
            return null;
        }
        List<Node> list = XmlParserHelper.getNodeList(node, string + "s", null);
        UidIndex.UidIndexList uidIndexList = new UidIndex.UidIndexList();
        for (Node node2 : list) {
            List<Node> list2 = XmlParserHelper.getNodeList(node2, string, null);
            for (Node node3 : list2) {
                String string2 = XmlParserHelper.getAttribute(node3, "uid");
                String string3 = XmlParserHelper.getAttribute(node3, "seg");
                UidIndex uidIndex = new UidIndex(string2, string3);
                uidIndexList.add(uidIndex);
                CompactIntegerList compactIntegerList = new CompactIntegerList(node3.getTextContent());
                for (int n : compactIntegerList) {
                    uidIndex.addIndex(n);
                }
            }
        }
        return uidIndexList;
    }

    public boolean sampleIsIncluded(int n) {
        ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(1);
        return innerColumnBoolean.getValueBool(n);
    }

    public boolean sampleIsIncludedForTest(int n) {
        ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(5);
        return innerColumnBoolean.getValueBool(n);
    }

    public List<Sample> getIncludedSampleList() {
        return this.measurementDataSource.getSamplesIncludedInDataSetColumn(this.dataSet, 1);
    }

    public void updateSampleInclusionAndTestFlags(ProgressManager progressManager, boolean[] blArray, boolean[] blArray2) {
        ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(1);
        for (int i = 0; i < blArray.length; ++i) {
            innerColumnBoolean.setValueBool(i, blArray[i]);
        }
        InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(4);
        InnerColumnBoolean innerColumnBoolean3 = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(5);
        for (int i = 0; i < blArray2.length; ++i) {
            innerColumnBoolean2.setValueBool(i, !blArray2[i]);
            innerColumnBoolean3.setValueBool(i, blArray2[i]);
        }
        this.dataSet.updateReferences(progressManager, true);
    }

    public void updateSampleInclusionAndTestFlags(ProgressManager progressManager, List<Sample> list, boolean bl, boolean bl2) {
        ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(1);
        InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(4);
        InnerColumnBoolean innerColumnBoolean3 = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(5);
        for (Sample sample : list) {
            int n = this.measurementDataSource.getSampleIndex(sample);
            if (n < 0) continue;
            innerColumnBoolean.setValueBool(n, bl);
            innerColumnBoolean2.setValueBool(n, !bl2);
            innerColumnBoolean3.setValueBool(n, bl2);
        }
        this.dataSet.updateReferences(progressManager, true);
    }

    public void saveXml(Element element) {
        if (this.measurementDataSource != null) {
            this.saveSampleList(element, this.measurementDataSource.getSamplesIncludedInDataSetColumn(this.dataSet, 1), "samples", "sample");
            this.saveSampleList(element, this.measurementDataSource.getSamplesIncludedInDataSetColumn(this.dataSet, 5), "tests", "test");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void saveSampleList(Element element, List<Sample> list, String string, String string2) {
        HashMap<Object, SegmentationSamples> hashMap = new HashMap<Object, SegmentationSamples>();
        for (Sample sample : list) {
            void object;
            Measurement measurement = sample.measurement();
            SegmentationSamples segmentationSamples = (SegmentationSamples)hashMap.get(measurement);
            if (segmentationSamples == null) {
                SegmentationSamples segmentationSamples2 = new SegmentationSamples();
                hashMap.put(measurement, segmentationSamples2);
            }
            object.getOrCreate(sample.getSegmentationHashId()).add(sample);
        }
        Element element2 = XmlParserHelper.addElement(element, string);
        int n = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            Measurement measurement = (Measurement)entry.getKey();
            SegmentationSamples segmentationSamples = (SegmentationSamples)entry.getValue();
            SampleSegmentationColumn sampleSegmentationColumn = measurement.getSamples(new SegmentationIdentifier(this.segmentationIndex, this.segmentationHashId));
            HashMap<? extends BasicSample, Integer> hashMap2 = ModelIncludedSamplesSettings.collectSegmentationIndex(sampleSegmentationColumn);
            for (Map.Entry entry2 : segmentationSamples.entrySet()) {
                CompactIntegerList compactIntegerList = new CompactIntegerList();
                for (Sample sample : (List)entry2.getValue()) {
                    Integer n2 = hashMap2.get(sample);
                    compactIntegerList.add(n2);
                    ++n;
                }
                if (!compactIntegerList.hasData()) continue;
                Element element3 = XmlParserHelper.addElement(element2, string2);
                element3.setAttribute("uid", measurement.getUid());
                element3.setAttribute("seg", (String)entry2.getKey());
                element3.setTextContent(compactIntegerList.toString());
            }
        }
        XmlParserHelper.setAttribute((Node)element2, "number", n);
    }

    private static HashMap<? extends BasicSample, Integer> collectSegmentationIndex(List<? extends BasicSample> list) {
        HashMap<BasicSample, Integer> hashMap = new HashMap<BasicSample, Integer>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        for (BasicSample basicSample : list) {
            String string = basicSample.getSegmentationHashId();
            Integer n = (Integer)hashMap2.get(string);
            if (n == null) {
                n = 0;
            }
            hashMap.put(basicSample, n);
            hashMap2.put(string, n + 1);
        }
        return hashMap;
    }

    public List<String> getModelVariables() {
        ArrayList<String> arrayList = new ArrayList<String>();
        AbstractDataMatrix abstractDataMatrix = this.dataSet.getMatrix(2);
        for (int i = 0; i < abstractDataMatrix.getK(); ++i) {
            arrayList.add(this.getVariableName(abstractDataMatrix, i));
        }
        return arrayList;
    }

    private String getVariableName(AbstractDataMatrix abstractDataMatrix, int n) {
        String string = abstractDataMatrix.getColumnDescription(n, 0);
        int n2 = string.indexOf(":");
        if (n2 > 0) {
            return string.substring(n2 + 2);
        }
        return string;
    }

    private class SegmentationSamples
    extends HashMap<String, List<Sample>> {
        private SegmentationSamples() {
        }

        public List<Sample> getOrCreate(String string) {
            ArrayList arrayList = (ArrayList)this.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.put(string, arrayList);
            }
            return arrayList;
        }
    }
}

