/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.EvinceModelParameters;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.model.AbstractModel;

public class ModelProperties {
    private final List<Property> properties = new ArrayList<Property>();
    private final List<ModelProperties> subProperties = new ArrayList<ModelProperties>();
    private String name;

    public ModelProperties() {
        this("");
    }

    public ModelProperties(String string) {
        this.name = string;
    }

    public ModelProperties(Analyse analyse) {
        List<Node> list = XmlParserHelper.getNodeList(analyse.getSetupXmlNode(), "properties");
        if (!list.isEmpty()) {
            this.parse(list.get(0));
        }
    }

    public ModelProperties(Node node) {
        if (node != null) {
            this.parse(node);
        }
    }

    private void parse(Node node) {
        this.name = XmlParserHelper.getAttribute(node, "name");
        for (Node node2 : XmlParserHelper.getNodeList(node)) {
            if (node2.getNodeName().equals("property")) {
                this.put(XmlParserHelper.getAttribute(node2, "key"), XmlParserHelper.getAttribute(node2, "value"), XmlParserHelper.getAttribute(node2, "attr"));
                continue;
            }
            if (!node2.getNodeName().equals("properties")) continue;
            this.subProperties.add(new ModelProperties(node2));
        }
    }

    public void put(String string, String string2, String string3) {
        this.properties.add(new Property(string, string2, string3));
    }

    public void put(String string, double d, Boolean bl) {
        this.properties.add(new Property(string, RtDataFormat.toString(d), bl != null ? bl.toString() : null));
    }

    public boolean getPropertyBool(String string, boolean bl) {
        return Boolean.parseBoolean(this.getProperty(string, String.valueOf(bl)));
    }

    public double getPropertyDouble(String string, double d) {
        return RtDataFormat.toNumber(this.getProperty(string, String.valueOf(d)));
    }

    public int getPropertyInt(String string, int n) {
        return (int)this.getPropertyDouble(string, n);
    }

    public String getProperty(String string, String string2) {
        Property property = this.getProperty(string);
        if (property != null) {
            return property.getValue();
        }
        return string2;
    }

    public Property getProperty(String string) {
        for (Property property : this.properties) {
            if (!property.getKey().equals(string)) continue;
            return property;
        }
        return null;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public void removeProperty(Property property) {
        this.properties.remove(property);
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public void saveProperties(Element element) {
        Element element2 = XmlParserHelper.addElement(element, "properties");
        if (this.name != null && this.name.length() > 0) {
            element2.setAttribute("name", this.name);
        }
        for (Property object : this.properties) {
            Element element3 = XmlParserHelper.addElement(element2, "property");
            element3.setAttribute("key", object.getKey());
            element3.setAttribute("value", object.getValue());
            if (object.getAttribute() == null) continue;
            element3.setAttribute("attr", object.getAttribute());
        }
        for (ModelProperties modelProperties : this.subProperties) {
            modelProperties.saveProperties(element2);
        }
    }

    public void updateAnalyseProperties(Analyse analyse) {
        Node node = analyse.getSetupXmlNode();
        Node node2 = XmlParserHelper.getNodeRecursive(node.getChildNodes(), "properties");
        node.removeChild(node2);
        this.saveProperties((Element)node);
    }

    public ModelProperties getSubProperties(String string) {
        for (ModelProperties modelProperties : this.subProperties) {
            if (!string.equals(modelProperties.getName())) continue;
            return modelProperties;
        }
        return null;
    }

    private String getName() {
        return this.name;
    }

    public static ModelProperties fromModel(AbstractModel abstractModel) {
        ModelProperties modelProperties = new ModelProperties();
        if (abstractModel.getModelName().equals("SIMCA")) {
            for (AbstractModel abstractModel2 : EvinceModelParameters.getModels(abstractModel)) {
                ModelProperties modelProperties2 = ModelProperties.fromModel(abstractModel2);
                modelProperties2.name = abstractModel2.getName();
                modelProperties.subProperties.add(modelProperties2);
            }
        } else {
            if (abstractModel.isUseDcrit()) {
                modelProperties.put("dcrit", abstractModel.getDcritX(), abstractModel.isDcriXmanually());
            }
            if (abstractModel.isUseHotelling()) {
                modelProperties.put("hotellingt2", abstractModel.getHotellingt2(), abstractModel.isHotellingT2manually());
            }
            modelProperties.put("components", abstractModel.getComponentsInt(), null);
        }
        return modelProperties;
    }

    public static void setFromProperties(BreezeProgressManager breezeProgressManager, AbstractModel abstractModel, Analyse analyse, boolean bl) {
        ModelProperties modelProperties = new ModelProperties(analyse);
        if (abstractModel.getModelName().equals("SIMCA")) {
            for (AbstractModel abstractModel2 : EvinceModelParameters.getModels(abstractModel)) {
                ModelProperties modelProperties2 = modelProperties.getSubProperties(abstractModel2.getName());
                if (modelProperties2 == null) continue;
                ModelProperties.setFromPropertiesLocal(breezeProgressManager, abstractModel2, modelProperties2, bl);
            }
        } else {
            ModelProperties.setFromPropertiesLocal(breezeProgressManager, abstractModel, modelProperties, bl);
        }
    }

    private static void setFromPropertiesLocal(BreezeProgressManager breezeProgressManager, AbstractModel abstractModel, ModelProperties modelProperties, boolean bl) {
        if (modelProperties.hasProperty("components")) {
            abstractModel.setComponents((ProgressManager)breezeProgressManager, modelProperties.getPropertyInt("components", abstractModel.getComponentsInt()));
        }
        if (modelProperties.hasProperty("cutOffLow")) {
            abstractModel.setCutOffLow(modelProperties.getPropertyDouble("cutOffLow", 0.5));
        }
        if (modelProperties.hasProperty("cutOffHigh")) {
            abstractModel.setCutOffHigh(modelProperties.getPropertyDouble("cutOffHigh", 1.5));
        }
        Property property = modelProperties.getProperty("dcrit");
        Property property2 = modelProperties.getProperty("hotellingt2");
        abstractModel.setUseDcrit(property != null || property2 == null && bl);
        if (property != null) {
            abstractModel.setDcritX(property.getNumber());
            if (property.hasAttribute()) {
                abstractModel.setDcritXmanually(property.getAttributeBool());
            }
        }
        abstractModel.setUseHotelling(property2 != null);
        if (property2 != null) {
            abstractModel.setHotellingt2(property2.getNumber());
            if (property2.hasAttribute()) {
                abstractModel.setDcritXmanually(property2.getAttributeBool());
            }
        }
    }

    public static class Property {
        public String key;
        public String value;
        public String attribute;

        public Property(String string, String string2, String string3) {
            this.key = string;
            this.value = string2;
            this.attribute = string3;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public double getNumber() {
            return RtDataFormat.toNumber(this.value);
        }

        public int getNumberInt() {
            return (int)this.getNumber();
        }

        public boolean hasAttribute() {
            return this.attribute != null;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public boolean getAttributeBool() {
            return Boolean.parseBoolean(this.attribute);
        }
    }

    public static class CriticalValues {
        private final AbstractModel model;
        private final BasicAnalyse analyse;

        public CriticalValues(AbstractModel abstractModel, BasicAnalyse basicAnalyse) {
            this.model = abstractModel;
            this.analyse = basicAnalyse;
        }

        public CriticalValues(BasicAnalyse basicAnalyse) {
            this.analyse = basicAnalyse;
            if (basicAnalyse instanceof Analyse) {
                Analyse analyse = (Analyse)basicAnalyse;
                this.model = analyse.getBaseModel((ProgressManager)ProgressManager.createEmpty());
            } else {
                this.model = null;
            }
        }

        public boolean isDcrit() {
            return this.model.isUseDcrit();
        }

        public boolean isDcriXmanually() {
            return this.model.isDcriXmanually();
        }

        public double getDcrit() {
            if (this.model == null) {
                return 0.0;
            }
            return this.model.getDcritX();
        }

        public void setDcrit(double d) {
            this.model.setDcritX(d);
        }

        public boolean isHotellingT2() {
            return this.model.isUseHotelling();
        }

        public void setHotellingT2(double d) {
            this.model.setHotellingt2(d);
        }

        public boolean isHotellingT2manually() {
            return this.model.isHotellingT2manually();
        }

        public double getHotellingT2() {
            return this.model.getHotellingt2();
        }

        public double getCutOffLow() {
            if (this.model == null) {
                return 0.0;
            }
            return this.model.getCutOffLow();
        }

        public double getCutOffHigh() {
            return this.model.getCutOffHigh();
        }

        public boolean supportHighCutOff() {
            return this.analyse.getModelMethod() == BasicAnalyse.ModelMethod.ClassificationPlsDa;
        }

        public void recalculate() {
            if (!this.isDcriXmanually()) {
                this.model.recalculateDcrit();
            }
            if (!this.isHotellingT2manually()) {
                this.model.recalculateHotellingT2();
            }
        }

        public void setCutOffCallback(AbstractModel.CutOffCallback cutOffCallback) {
            this.model.setCutOffCallback(cutOffCallback);
        }

        public void setCutOffLow(double d) {
            this.model.setCutOffLow(d);
        }

        public void setCutOffHigh(double d) {
            this.model.setCutOffHigh(d);
        }

        public void save(ProgressManager progressManager, File file) {
            Properties properties = new Properties();
            properties.put("savetype", "complete");
            this.model.save(progressManager, file.getAbsolutePath(), properties);
        }

        public BasicAnalyse getAnalyse() {
            return this.analyse;
        }
    }

    public static class TransformationProperties {
        final Model.Transformation transformation;
        final boolean enabled;
        final Properties properties;

        public TransformationProperties(Model.Transformation transformation, boolean bl, String string) {
            this(transformation, bl, new Properties());
            if (string != null && string.length() > 0) {
                String[] stringArray;
                String string2 = string.substring(1, string.length() - 1);
                for (String string3 : stringArray = string2.split(";")) {
                    String[] stringArray2 = string3.split("=");
                    this.properties.put(stringArray2[0], stringArray2[1]);
                }
            }
        }

        public TransformationProperties(Model.Transformation transformation, boolean bl) {
            this(transformation, bl, new Properties());
        }

        public TransformationProperties(Model.Transformation transformation, boolean bl, Properties properties) {
            this.transformation = transformation;
            this.enabled = bl;
            this.properties = properties;
        }

        public TransformationProperties(Model.Transformation transformation, AbstractTransform abstractTransform) {
            this(transformation, abstractTransform != null, new Properties());
            Properties properties;
            if (abstractTransform != null && (properties = abstractTransform.getProperties()) != null) {
                this.properties.putAll((Map<?, ?>)properties);
            }
        }

        public Model.Transformation getTransformation() {
            return this.transformation;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String getPropertyString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            for (Object object : this.properties.keySet()) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(object);
                stringBuilder.append("=");
                stringBuilder.append(this.properties.get(object));
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        public void addToProperties(ModelProperties modelProperties) {
            modelProperties.put(this.transformation.getXmlName(), Boolean.toString(this.enabled), null);
            if (this.properties != null && this.properties.size() > 0) {
                modelProperties.put(this.transformation.getXmlName() + "_properties", this.getPropertyString(), null);
            }
        }
    }
}

