/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import no.uib.cipr.matrix.DenseVector;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.DefaultModel;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.model.AbstractModel;

public class QuantificationModel
extends DefaultModel {
    public QuantificationModel(BreezeProgress breezeProgress, Analyse analyse) {
        super(breezeProgress, analyse, (List<FactorOrDescriptor>)null);
    }

    public QuantificationModel(BreezeProgress breezeProgress, Analyse analyse, List<FactorOrDescriptor> list) {
        super(breezeProgress, analyse, list);
    }

    public QuantificationModel(BreezeProgress breezeProgress, Analyse analyse, AbstractModel abstractModel) {
        super(breezeProgress, analyse, abstractModel);
        Workflow workflow = analyse.getWorkflow();
        ArrayList<FactorOrDescriptor> arrayList = new ArrayList<FactorOrDescriptor>();
        for (String string : abstractModel.getVariableArray()) {
            PropertyFactor propertyFactor = workflow.getPropertyFactors().getByName(string);
            if (propertyFactor != null) {
                arrayList.add(propertyFactor);
                continue;
            }
            arrayList.add(new PropertyFactor(string));
        }
        this.setVariables(arrayList);
    }

    @Override
    public boolean setSegmentationLevel(BreezeProgressManager breezeProgressManager, int n, String string, Model.ModelStatus modelStatus) {
        if (super.setSegmentationLevel(breezeProgressManager, n, string, modelStatus)) {
            this.addAndInitializeUvScaleTransform(breezeProgressManager, this.dataSet);
            return true;
        }
        return false;
    }

    private void addAndInitializeUvScaleTransform(BreezeProgressManager breezeProgressManager, DataSet dataSet) {
        VariablesInfo variablesInfo = dataSet.getVarDataInfo();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
            if (innerColumnBoolean.getValueBool(i)) continue;
            arrayList.add((double)i + 1.0);
        }
        dataSet.createModification((ProgressManager)breezeProgressManager, "var", "uvscale", arrayList.toArray(new Double[0]));
    }

    @Override
    public void createModel(BreezeProgressManager breezeProgressManager) {
        Properties properties = new Properties();
        this.createModel(breezeProgressManager, properties);
    }

    public void createModel(BreezeProgressManager breezeProgressManager, Properties properties) {
        VariablesInfo variablesInfo = this.dataSet.getVarDataInfo();
        InnerColumnString innerColumnString = (InnerColumnString)variablesInfo.getPrimaryColumnByType(0);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
        InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
        for (int i = 0; i < innerColumnBoolean2.getSize(); ++i) {
            if (innerColumnBoolean2.getValueBool(i)) continue;
            innerColumnBoolean.setValueBool(i, this.isVariableIncluded(innerColumnString.getValueLocal(i)));
        }
        properties.put("rethrowexceptions", "true");
        this.modelSettings(properties);
        this.model = this.dataSet.createModel((ProgressManager)breezeProgressManager, "pls", properties);
        this.model.setName(this.analyse.getUid());
        ModelProperties.setFromProperties(breezeProgressManager, this.model, this.analyse, false);
        this.model.setEnabled(true);
    }

    public List<FactorOrDescriptor> getSelectedVariables() {
        if (this.selectedProperties != null && this.selectedProperties.size() > 0) {
            return this.selectedProperties;
        }
        return this.getAllVariables(this.segmentationLevel, null);
    }

    private boolean isVariableIncluded(String string) {
        for (FactorOrDescriptor factorOrDescriptor : this.selectedProperties) {
            if (!factorOrDescriptor.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<FactorOrDescriptor> getAllVariables(int n, String string) {
        Workflow workflow = this.analyse.getWorkflow();
        List<FactorOrDescriptor> list = FactorOrDescriptor.toList(workflow.getPropertyFactors());
        list.addAll(workflow.getSegmentationLevelDescriptorNodes(new SegmentationIdentifier(n, string), false));
        return list;
    }

    public List<FactorOrDescriptor> getPropertyList() {
        return this.selectedProperties;
    }

    @Override
    public void finishAndSave(BreezeProgressManager breezeProgressManager) {
        this.analyse.getPropertyFactors().clear();
        for (FactorOrDescriptor factorOrDescriptor : this.getPropertyList()) {
            this.analyse.getPropertyFactors().add((PropertyFactor)factorOrDescriptor.cloneKeepId());
        }
        this.analyse.addModelPropertiesToAnalyse(this.model);
        this.commonModelSettings.saveEvinceModel(breezeProgressManager);
        this.analyse.save(this);
    }

    public List<Integer> getSortedVariablesByWeights() {
        ModelMatrix modelMatrix = (ModelMatrix)this.model.getMatrixByName("W");
        DenseVector denseVector = modelMatrix.getLastRM();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < denseVector.size(); ++i) {
            arrayList.add(i);
        }
        arrayList.sort((n, n2) -> Double.compare(denseVector.get(n2.intValue()), denseVector.get(n.intValue())));
        return arrayList;
    }

    @Override
    public void balanceTrainData(BreezeProgress breezeProgress, boolean bl, boolean bl2) {
        new QuantificationBalanceModel(this.dataSet, 10).performAnalysis(breezeProgress, bl, bl2);
    }

    protected static class QuantificationBalanceModel
    extends DefaultModel.BalanceModel {
        private final int numBuckets;

        public QuantificationBalanceModel(DataSet dataSet, int n) {
            super(dataSet);
            this.numBuckets = n;
        }

        @Override
        protected ArrayList<Integer>[] createIndexList(boolean bl) {
            AbstractDataMatrix abstractDataMatrix = this.dataSet.getOriginalMatrix();
            List<Integer> list = this.getIncludedYColumns();
            Integer n = list.get(0);
            double d = Double.MAX_VALUE;
            double d2 = 0.0;
            for (int i = 0; i < abstractDataMatrix.getN(); ++i) {
                if (abstractDataMatrix.isMissing(i, n.intValue())) continue;
                double d3 = abstractDataMatrix.getValue(i, n.intValue());
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            ArrayList<Integer>[] arrayListArray = this.allocateIndexList(this.numBuckets);
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.dataInfo.getPrimaryColumnByType(4);
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)this.dataInfo.getPrimaryColumnByType(1);
            double d4 = d2 - d;
            if (d4 == 0.0) {
                throw new RuntimeException("No variation in data");
            }
            for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                if (!innerColumnBoolean.getValueBool(i) || bl && !innerColumnBoolean2.getValueBool(i) || abstractDataMatrix.isMissing(i, n.intValue())) continue;
                int n2 = (int)((abstractDataMatrix.getValue(i, n.intValue()) - d) / d4 * (double)this.numBuckets);
                n2 = Math.min(this.numBuckets - 1, n2);
                arrayListArray[n2].add(i);
            }
            return arrayListArray;
        }

        private List<Integer> getIncludedYColumns() {
            VariablesInfo variablesInfo = this.dataSet.getVarDataInfo();
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < innerColumnBoolean2.getSize(); ++i) {
                if (!innerColumnBoolean.getValueBool(i) || innerColumnBoolean2.getValueBool(i)) continue;
                arrayList.add(i);
            }
            return arrayList;
        }

        @Override
        protected boolean useMedian() {
            return true;
        }
    }
}

