/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.util.List;
import java.util.Properties;
import no.uib.cipr.matrix.DenseVector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.entry.MeasurementOrSample;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.RecordGroupHolder;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.analyse.model.QuantificationModel;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.test.EvinceTestSetUp;
import se.prediktera.breeze.test.SlowTestCategory;
import se.prediktera.breeze.test.stubs.AnalyseWithoutIO;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.mda.model.ModelContainer;

@Category(value={SlowTestCategory.class})
public class QuantificationModelTest
extends EvinceTestSetUp {
    private final float[][] factorValues = new float[][]{{0.0f, 100.0f, 0.0f}, {100.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 100.0f}, {0.0f, 50.0f, 50.0f}, {50.0f, 0.0f, 50.0f}, {50.0f, 50.0f, 0.0f}, {33.0f, 33.0f, 33.0f}};
    private final float[][] powderQuantificationDemoDataProfiles = new float[][]{{0.10132416f, 0.09935438f, 0.09664381f, 0.0954844f, 0.10156127f, 0.12029494f, 0.13880987f, 0.15377349f, 0.1376493f, 0.13000573f, 0.12815589f, 0.120886125f, 0.11965976f, 0.12972613f, 0.15300596f, 0.16350271f, 0.18288721f, 0.29034314f, 0.24926919f, 0.26411557f, 0.27058607f, 0.27006882f, 0.2628205f, 0.26501358f, 0.26292083f, 0.24149124f, 0.22343485f, 0.21395904f, 0.22379029f, 0.23467667f, 0.29451954f, 0.25841823f, 0.26048493f, 0.24101186f, 0.23549482f, 0.22268066f, 0.21113327f, 0.20952038f, 0.21642572f, 0.2228557f, 0.2262969f, 0.2313979f, 0.25080398f, 0.30537608f, 0.35935724f, 0.4686839f, 0.5035994f, 0.4430094f, 0.40321812f, 0.3935995f, 0.35690942f, 0.3520837f, 0.34134617f, 0.37440455f, 0.4347202f, 0.4806067f, 0.7025747f, 0.5458821f, 0.6317563f, 0.5648134f, 0.5852253f, 0.63350743f, 0.62165594f, 0.5857054f, 0.5938301f, 0.5672733f, 0.5431805f}, {0.11232059f, 0.1105205f, 0.10988131f, 0.112504385f, 0.12111206f, 0.14210132f, 0.15751179f, 0.17220636f, 0.15758643f, 0.1486893f, 0.14607611f, 0.14581992f, 0.15083945f, 0.16395153f, 0.1796823f, 0.20712179f, 0.26232764f, 0.3129728f, 0.32617226f, 0.32250565f, 0.31039143f, 0.30127198f, 0.2984991f, 0.29681012f, 0.29438785f, 0.28960088f, 0.28710133f, 0.28848666f, 0.30031994f, 0.3292658f, 0.38065282f, 0.36584195f, 0.38327235f, 0.38087717f, 0.38749138f, 0.39048153f, 0.39765465f, 0.430697f, 0.5217882f, 0.5865493f, 0.58660686f, 0.565513f, 0.5474867f, 0.54103464f, 0.54818124f, 0.56236243f, 0.57307863f, 0.5743513f, 0.5679109f, 0.56158257f, 0.5578748f, 0.5560226f, 0.56014407f, 0.57329863f, 0.6149113f, 0.6791666f, 0.86531276f, 0.7272086f, 0.83141714f, 0.779389f, 0.8119484f, 0.824278f, 0.8411761f, 0.80667394f, 0.80477023f, 0.78608745f, 0.7677432f}, {0.13509421f, 0.12893488f, 0.124722846f, 0.1252029f, 0.13946201f, 0.17631699f, 0.20496136f, 0.22762215f, 0.2013454f, 0.18390067f, 0.17703289f, 0.17286555f, 0.17854361f, 0.20164363f, 0.23019093f, 0.27102488f, 0.35996056f, 0.45207512f, 0.47397843f, 0.46428448f, 0.44198075f, 0.42424813f, 0.41691196f, 0.4110305f, 0.39928713f, 0.37856176f, 0.3575351f, 0.34245074f, 0.34624362f, 0.38453054f, 0.44190988f, 0.41845995f, 0.43274334f, 0.413859f, 0.40096733f, 0.3826846f, 0.37268537f, 0.4226865f, 0.58387464f, 0.693104f, 0.6809114f, 0.6232974f, 0.5722399f, 0.5567404f, 0.58338344f, 0.6241377f, 0.6516939f, 0.6542827f, 0.6327725f, 0.6029173f, 0.5746097f, 0.54984117f, 0.5359107f, 0.551968f, 0.6371894f, 0.74487174f, 0.9799794f, 0.7978415f, 0.92066777f, 0.84849113f, 0.8864449f, 0.91410154f, 0.9526041f, 0.92000395f, 0.92409486f, 0.89269763f, 0.8625673f}, {0.106801264f, 0.1030617f, 0.099550925f, 0.099067554f, 0.10862222f, 0.13515969f, 0.15796134f, 0.17560494f, 0.15549083f, 0.14387596f, 0.13992155f, 0.13432547f, 0.13653736f, 0.15268302f, 0.17766911f, 0.20250192f, 0.25818163f, 0.35671178f, 0.3492148f, 0.3511094f, 0.34312338f, 0.33446294f, 0.32722703f, 0.32565767f, 0.31900084f, 0.29757124f, 0.27788946f, 0.2653114f, 0.27183226f, 0.29536784f, 0.34944445f, 0.32319897f, 0.3314669f, 0.3139548f, 0.30445644f, 0.28922936f, 0.27902102f, 0.306159f, 0.4069919f, 0.48005927f, 0.472952f, 0.43751472f, 0.41124183f, 0.42184535f, 0.46129352f, 0.5383689f, 0.57323235f, 0.54296577f, 0.5122809f, 0.49156338f, 0.45810235f, 0.44247603f, 0.4289708f, 0.45358443f, 0.52560127f, 0.6000213f, 0.81081516f, 0.6554663f, 0.7500858f, 0.685194f, 0.71341926f, 0.7533893f, 0.7713869f, 0.7431f, 0.75126797f, 0.7239171f, 0.696852f}, {0.13234669f, 0.12814216f, 0.12534827f, 0.1266857f, 0.13749628f, 0.16613469f, 0.18868865f, 0.20796704f, 0.18698259f, 0.1732744f, 0.16827372f, 0.16578922f, 0.17064178f, 0.18835089f, 0.21052901f, 0.24389254f, 0.3147295f, 0.38893312f, 0.4080264f, 0.4016056f, 0.3843929f, 0.3708908f, 0.3658682f, 0.36207148f, 0.3545421f, 0.34118074f, 0.32884088f, 0.32149744f, 0.3294881f, 0.3632304f, 0.41735455f, 0.39850438f, 0.41430163f, 0.40389916f, 0.40123692f, 0.39434534f, 0.3932539f, 0.43157282f, 0.5539159f, 0.643468f, 0.63824195f, 0.59904695f, 0.5651066f, 0.5547262f, 0.5721071f, 0.60062885f, 0.6205026f, 0.62265545f, 0.6084944f, 0.5900035f, 0.574215f, 0.5610012f, 0.55675006f, 0.57169914f, 0.63407356f, 0.7178545f, 0.92037797f, 0.7676583f, 0.8759558f, 0.8162918f, 0.8501098f, 0.8720304f, 0.90043837f, 0.8698125f, 0.87234175f, 0.8478597f, 0.82427f}, {0.10910477f, 0.10689368f, 0.10465074f, 0.10493559f, 0.11189049f, 0.13179456f, 0.14937383f, 0.165028f, 0.14835984f, 0.13954136f, 0.13713849f, 0.13270049f, 0.13407823f, 0.1453021f, 0.16516876f, 0.18412453f, 0.22060521f, 0.30583426f, 0.2857153f, 0.29311413f, 0.29233456f, 0.28877926f, 0.28285792f, 0.2833095f, 0.28118652f, 0.2659056f, 0.254035f, 0.24931401f, 0.26047426f, 0.28068683f, 0.3386926f, 0.31125858f, 0.32116455f, 0.30992743f, 0.31081206f, 0.30670762f, 0.3052609f, 0.32320553f, 0.3795551f, 0.42142662f, 0.42234308f, 0.4104732f, 0.4048305f, 0.42055383f, 0.44817674f, 0.5146469f, 0.54205126f, 0.5067061f, 0.48145866f, 0.47270977f, 0.45139593f, 0.44753918f, 0.44475695f, 0.4681997f, 0.51926124f, 0.5764499f, 0.78444725f, 0.63321567f, 0.7302011f, 0.6698263f, 0.69744265f, 0.7278211f, 0.730585f, 0.69361293f, 0.6974211f, 0.6727801f, 0.6525822f}, {0.12205964f, 0.119010374f, 0.11629886f, 0.11680358f, 0.12590246f, 0.15070279f, 0.17159727f, 0.18905012f, 0.16990264f, 0.15856636f, 0.1547908f, 0.15056689f, 0.15321043f, 0.16808708f, 0.19039707f, 0.21578622f, 0.26989478f, 0.35642675f, 0.35266194f, 0.35360488f, 0.34512872f, 0.33664438f, 0.33050197f, 0.32884893f, 0.3233843f, 0.3063578f, 0.29140222f, 0.2830578f, 0.29160717f, 0.31695288f, 0.37265167f, 0.34783766f, 0.35891473f, 0.34572944f, 0.34181613f, 0.33324218f, 0.32905495f, 0.3564747f, 0.44915676f, 0.51740676f, 0.5130692f, 0.48390698f, 0.46168667f, 0.46673244f, 0.49509513f, 0.5546017f, 0.5827615f, 0.5596956f, 0.53542876f, 0.5194189f, 0.4954569f, 0.4844149f, 0.47754094f, 0.49866903f, 0.5603471f, 0.6319181f, 0.8417933f, 0.6864049f, 0.78730005f, 0.7248154f, 0.75453776f, 0.7854647f, 0.8010668f, 0.7680171f, 0.77287346f, 0.7464539f, 0.7225861f}};

    @Test
    public void shouldCreateQuantificationModelWithSevenObservations() {
        Analyse analyse = this.createAnalyseWithMeasurement(7, 0);
        QuantificationModel quantificationModel = new QuantificationModel(BreezeProgressManager.createEmpty(), analyse);
        quantificationModel.setVariables(analyse.getWorkflow().getPropertyFactors().getList());
        quantificationModel.createModel(BreezeProgressManager.createEmpty());
        MatcherAssert.assertThat((Object)quantificationModel.getModel().getComponentsInt(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)quantificationModel.getModel().getScores().getScalar(0), (Matcher)CoreMatchers.equalTo((Object)-2.015311920604034));
        DenseVector denseVector = ((ModelMatrix)quantificationModel.getModel().getMatrixByName("W")).getLastRM();
        List<Integer> list = quantificationModel.getSortedVariablesByWeights();
        MatcherAssert.assertThat((Object)denseVector.get(list.get(0).intValue()), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(denseVector.get(list.get(1).intValue()))));
        analyse.addModelPropertiesToAnalyse(quantificationModel.getModel());
        MatcherAssert.assertThat((Object)analyse.getQ2y(), (Matcher)CoreMatchers.is((Object)0.89043));
        MatcherAssert.assertThat((Object)analyse.getR2x(), (Matcher)CoreMatchers.is((Object)0.99737));
    }

    @Test
    public void shouldCreateQuantificationModelWithTest() {
        Analyse analyse = this.createAnalyseWithMeasurement(7, 2);
        QuantificationModel quantificationModel = new QuantificationModel(BreezeProgressManager.createEmpty(), analyse);
        quantificationModel.setVariables(analyse.getWorkflow().getPropertyFactors().getList());
        DataSet dataSet = quantificationModel.getDataSet();
        dataSet.setTest(Double.valueOf(1.0), new Double[]{8.0, 9.0});
        quantificationModel.createModel(BreezeProgressManager.createEmpty());
        AbstractModel abstractModel = quantificationModel.getModel();
        MatcherAssert.assertThat((Object)abstractModel.getComponentsInt(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)abstractModel.getScores().getScalar(0), (Matcher)CoreMatchers.equalTo((Object)-1.8571644731641677));
        ModelMatrix modelMatrix = (ModelMatrix)abstractModel.getMatrixByName("RMSE_var");
        MatcherAssert.assertThat((Object)modelMatrix.getScalar(1), (Matcher)CoreMatchers.is((Object)0.5160919474809326));
        AbstractPrediction abstractPrediction = abstractModel.getLocalPredictionNode();
        ModelMatrix modelMatrix2 = (ModelMatrix)abstractPrediction.getMatrixByName("RPDP_var");
        MatcherAssert.assertThat((Object)modelMatrix2.getScalar(1), (Matcher)CoreMatchers.is((Object)3.3779806988691434));
        ModelMatrix modelMatrix3 = (ModelMatrix)abstractPrediction.getMatrixByName("R2XP_var_cum");
        MatcherAssert.assertThat((Object)modelMatrix3.getScalar(1), (Matcher)CoreMatchers.is((Object)0.955797603484579));
        ModelMatrix modelMatrix4 = (ModelMatrix)abstractPrediction.getMatrixByName("R2YP_var_cum");
        MatcherAssert.assertThat((Object)modelMatrix4.getScalar(1), (Matcher)CoreMatchers.is((Object)0.8802217445163619));
        analyse.addModelPropertiesToAnalyse(abstractModel);
        MatcherAssert.assertThat((Object)analyse.getQ2y(), (Matcher)CoreMatchers.is((Object)0.95018));
        MatcherAssert.assertThat((Object)analyse.getR2x(), (Matcher)CoreMatchers.is((Object)0.99721));
    }

    @Test
    public void shouldCreateQuantificationModelWithSevenObservationsWithMissingValue() {
        Analyse analyse = this.createAnalyseWithMeasurement(7, 0);
        PropertyFactor propertyFactor = analyse.getWorkflow().getPropertyFactors().getByName("Baking soda");
        analyse.getFirstGroup().getChild(0).getRootSample().getSampleValues().removeValue(propertyFactor);
        QuantificationModel quantificationModel = new QuantificationModel(BreezeProgressManager.createEmpty(), analyse);
        quantificationModel.setVariables(analyse.getWorkflow().getPropertyFactors().getList());
        quantificationModel.createModel(BreezeProgressManager.createEmpty());
        MatcherAssert.assertThat((Object)quantificationModel.getModel().getDataSet().getMatrix(2).isMissing(0, 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)quantificationModel.getModel().getDataSet().getMatrix(2).isMissing(1, 0), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)quantificationModel.getModel().getComponentsInt(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)quantificationModel.getModel().getScores().getScalar(0), (Matcher)CoreMatchers.equalTo((Object)2.0108363789880053));
        analyse.addModelPropertiesToAnalyse(quantificationModel.getModel());
        MatcherAssert.assertThat((Object)analyse.getQ2y(), (Matcher)CoreMatchers.is((Object)0.86839));
        MatcherAssert.assertThat((Object)analyse.getR2x(), (Matcher)CoreMatchers.is((Object)0.99736));
    }

    @Test
    public void shouldCreateQuantificationModelWithThreeObservations() {
        Analyse analyse = this.createAnalyseWithMeasurement(3, 0);
        QuantificationModel quantificationModel = new QuantificationModel(BreezeProgressManager.createEmpty(), analyse);
        quantificationModel.setVariables(analyse.getWorkflow().getPropertyFactors().getList());
        quantificationModel.createModel(BreezeProgressManager.createEmpty());
        MatcherAssert.assertThat((Object)quantificationModel.getModel().getComponentsInt(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)quantificationModel.getModel().getScores().getScalar(0), (Matcher)CoreMatchers.equalTo((Object)-1.8520412714744299));
    }

    @Test
    public void shouldCreateQuantificationModelWithThreeIncludedObservations() {
        Analyse analyse = this.createAnalyseWithMeasurement(7, 0);
        boolean[] blArray = new boolean[7];
        for (int i = 0; i < 3; ++i) {
            blArray[i] = true;
        }
        QuantificationModel quantificationModel = new QuantificationModel(BreezeProgressManager.createEmpty(), analyse);
        quantificationModel.setVariables(analyse.getWorkflow().getPropertyFactors().getList());
        quantificationModel.createModel(BreezeProgressManager.createEmpty());
        quantificationModel.updateSampleInclusionAndTestFlags(BreezeProgressManager.createEmpty(), blArray, new boolean[7]);
        quantificationModel.applyChanges(BreezeProgressManager.createEmpty());
        MatcherAssert.assertThat((Object)quantificationModel.getModel().getComponentsInt(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)quantificationModel.getModel().getScores().getScalar(0), (Matcher)CoreMatchers.equalTo((Object)-1.8520412714744299));
    }

    @Test
    public void shouldCreateQuantificationModelWithSavitzky() {
        Analyse analyse = this.createAnalyseWithMeasurement(7, 0);
        QuantificationModel quantificationModel = new QuantificationModel(BreezeProgressManager.createEmpty(), analyse);
        quantificationModel.setVariables(analyse.getWorkflow().getPropertyFactors().getList());
        quantificationModel.createModel(BreezeProgressManager.createEmpty());
        Properties properties = new Properties();
        properties.put("polynomialorder", "5");
        properties.put("derivativeorder", "1");
        properties.put("leftpoints", "4");
        properties.put("rightpoints", "8");
        quantificationModel.updateTransformation(new ModelProperties.TransformationProperties(Model.Transformation.SavitzkyGolay, true, properties));
        quantificationModel.applyChanges(BreezeProgressManager.createEmpty());
        AbstractModel abstractModel = quantificationModel.getModel();
        DataSet dataSet = abstractModel.getDataSet();
        AbstractTransform abstractTransform = dataSet.getModificationByTreeType("var", Model.Transformation.SavitzkyGolay.getTreeType());
        MatcherAssert.assertThat((Object)(abstractTransform != null ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        Properties properties2 = abstractTransform.getProperties();
        MatcherAssert.assertThat((Object)properties2.getProperty("polynomialorder"), (Matcher)CoreMatchers.is((Object)"5"));
        MatcherAssert.assertThat((Object)properties2.getProperty("derivativeorder"), (Matcher)CoreMatchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)properties2.getProperty("leftpoints"), (Matcher)CoreMatchers.is((Object)"4"));
        MatcherAssert.assertThat((Object)properties2.getProperty("rightpoints"), (Matcher)CoreMatchers.is((Object)"8"));
        MatcherAssert.assertThat((Object)abstractModel.getComponentsInt(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)abstractModel.getScores().getScalar(0), (Matcher)CoreMatchers.equalTo((Object)-5.0444917187502));
        properties.put("polynomialorder", "6");
        properties.put("derivativeorder", "2");
        properties.put("leftpoints", "5");
        properties.put("rightpoints", "9");
        quantificationModel.updateTransformation(new ModelProperties.TransformationProperties(Model.Transformation.SavitzkyGolay, true, properties));
        dataSet.setChanged();
        quantificationModel.applyChanges(BreezeProgressManager.createEmpty());
        Properties properties3 = abstractTransform.getProperties();
        MatcherAssert.assertThat((Object)properties3.getProperty("polynomialorder"), (Matcher)CoreMatchers.is((Object)"6"));
        MatcherAssert.assertThat((Object)properties3.getProperty("derivativeorder"), (Matcher)CoreMatchers.is((Object)"2"));
        MatcherAssert.assertThat((Object)properties3.getProperty("leftpoints"), (Matcher)CoreMatchers.is((Object)"5"));
        MatcherAssert.assertThat((Object)properties3.getProperty("rightpoints"), (Matcher)CoreMatchers.is((Object)"9"));
        MatcherAssert.assertThat((Object)abstractModel.getComponentsInt(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)abstractModel.getScores().getScalar(0), (Matcher)CoreMatchers.equalTo((Object)-4.927984979642623));
    }

    private Analyse createAnalyseWithMeasurement(int n, int n2) {
        MeasurementOrSample measurementOrSample;
        AnalyseWithoutIO analyseWithoutIO = new AnalyseWithoutIO();
        analyseWithoutIO.getProperties().getPropertyBoolLocal("modelling/cvfull", true);
        RecordGroupHolder recordGroupHolder = analyseWithoutIO.getRecordGroupHolder();
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        PropertyFactor propertyFactor = new PropertyFactor("Baking soda");
        workflowWithoutIO.getPropertyFactors().add(propertyFactor);
        PropertyFactor propertyFactor2 = new PropertyFactor("Vanilla");
        workflowWithoutIO.getPropertyFactors().add(propertyFactor2);
        PropertyFactor propertyFactor3 = new PropertyFactor("Potato starch");
        workflowWithoutIO.getPropertyFactors().add(propertyFactor3);
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO(workflowWithoutIO);
        for (int i = 0; i < n; ++i) {
            MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO();
            measurementOrSample = new RootSample();
            ((BasicSample)((Object)measurementOrSample)).getSampleValues().setValue(propertyFactor, this.factorValues[i][0]);
            ((BasicSample)((Object)measurementOrSample)).getSampleValues().setValue(propertyFactor2, this.factorValues[i][1]);
            ((BasicSample)((Object)measurementOrSample)).getSampleValues().setValue(propertyFactor3, this.factorValues[i][2]);
            measurementWithoutIO.replaceRootSample((RootSample)measurementOrSample);
            ((Sample)measurementOrSample).getPath().setAverageProfile(this.powderQuantificationDemoDataProfiles[i]);
            groupWithoutIO.addChild(measurementWithoutIO);
        }
        recordGroupHolder.addGroup(groupWithoutIO);
        if (n2 > 0) {
            GroupWithoutIO groupWithoutIO2 = new GroupWithoutIO(workflowWithoutIO);
            for (int i = 0; i < n2; ++i) {
                measurementOrSample = new MeasurementWithoutIO();
                RootSample rootSample = new RootSample();
                rootSample.getSampleValues().setValue(propertyFactor, this.factorValues[i][0]);
                rootSample.getSampleValues().setValue(propertyFactor2, this.factorValues[i][1]);
                rootSample.getSampleValues().setValue(propertyFactor3, this.factorValues[i][2]);
                ((Measurement)measurementOrSample).replaceRootSample(rootSample);
                rootSample.getPath().setAverageProfile(this.powderQuantificationDemoDataProfiles[i]);
                groupWithoutIO2.addChild((Measurement)measurementOrSample);
            }
            recordGroupHolder.addGroup(groupWithoutIO2);
        }
        return analyseWithoutIO;
    }

    @Test
    public void testQuantificationBalanaceModel() {
        ProgressManagerImpl progressManagerImpl = ProgressManager.createEmpty();
        Project_GUI project_GUI = Project_GUI.createNewProject((boolean)false, (String)"Test");
        Case case_ = project_GUI.getOrCreatePrimaryCase();
        MVmatrix mVmatrix = new MVmatrix(11, 5);
        double[] dArray = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.2, 0.2, 0.2, 0.3, 0.3, 0.4};
        for (int i = 0; i < dArray.length; ++i) {
            mVmatrix.setValue(i, 4, dArray[i]);
        }
        mVmatrix.setValue(dArray.length - 1, 4, 0.4, true);
        DataSet dataSet = case_.importCaseFromMatrix((AbstractDataMatrix)mVmatrix, project_GUI, (ProgressManager)progressManagerImpl, 1);
        dataSet.setY(new Double[]{5.0});
        new QuantificationModel.QuantificationBalanceModel(dataSet, 10).performAnalysis(BreezeProgressImpl.createEmpty(), false, false);
        dataSet.updateReferences((ProgressManager)BreezeProgressManager.createEmpty(), true);
        double[] dArray2 = (double[])dataSet.get("included");
        MatcherAssert.assertThat((Object)dArray2.length, (Matcher)CoreMatchers.is((Object)8));
        MatcherAssert.assertThat((Object)dArray2[0], (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)dArray2[1], (Matcher)CoreMatchers.is((Object)2.0));
        MatcherAssert.assertThat((Object)dArray2[2], (Matcher)CoreMatchers.is((Object)4.0));
        MatcherAssert.assertThat((Object)dArray2[3], (Matcher)CoreMatchers.is((Object)6.0));
        MatcherAssert.assertThat((Object)dArray2[4], (Matcher)CoreMatchers.is((Object)7.0));
        MatcherAssert.assertThat((Object)dArray2[5], (Matcher)CoreMatchers.is((Object)8.0));
        MatcherAssert.assertThat((Object)dArray2[6], (Matcher)CoreMatchers.is((Object)9.0));
        MatcherAssert.assertThat((Object)dArray2[7], (Matcher)CoreMatchers.is((Object)10.0));
    }

    @Test
    public void singleYplsModel() {
        try {
            this.assertSingleY();
        }
        catch (AssertionError assertionError) {
            Logg.error((String)"Assert failed for single y pls model", (Throwable)((Object)assertionError));
        }
    }

    private void assertSingleY() {
        Analyse analyse = this.createAnalyseWithMeasurement(7, 2);
        QuantificationModel quantificationModel = new QuantificationModel(BreezeProgressManager.createEmpty(), analyse);
        quantificationModel.setVariables(analyse.getWorkflow().getPropertyFactors().getList());
        DataSet dataSet = quantificationModel.getDataSet();
        dataSet.setTest(Double.valueOf(1.0), new Double[]{8.0, 9.0});
        Properties properties = new Properties();
        properties.put("singley", "true");
        quantificationModel.createModel(BreezeProgressManager.createEmpty(), properties);
        ModelContainer modelContainer = (ModelContainer)quantificationModel.getModel();
        MatcherAssert.assertThat((Object)modelContainer.getModelCount(), (Matcher)CoreMatchers.is((Object)3));
        AbstractModel abstractModel = modelContainer.getModelAt(0);
        MatcherAssert.assertThat((Object)abstractModel.getComponentsInt(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)abstractModel.getScores().getScalar(0), (Matcher)CoreMatchers.equalTo((Object)-1.681987345468389));
        AbstractPrediction abstractPrediction = abstractModel.getLocalPredictionNode();
        ModelMatrix modelMatrix = (ModelMatrix)abstractPrediction.getMatrixByName("RPDP_var");
        MatcherAssert.assertThat((Object)modelMatrix.getScalar(1), (Matcher)CoreMatchers.is((Object)3.4262093285314803));
        ModelMatrix modelMatrix2 = (ModelMatrix)abstractPrediction.getMatrixByName("R2XP_var_cum");
        MatcherAssert.assertThat((Object)modelMatrix2.getScalar(1), (Matcher)CoreMatchers.is((Object)0.9575237230906473));
        ModelMatrix modelMatrix3 = (ModelMatrix)abstractPrediction.getMatrixByName("R2YP_var_cum");
        MatcherAssert.assertThat((Object)modelMatrix3.getScalar(1), (Matcher)CoreMatchers.is((Object)0.883570091741769));
        analyse.addModelPropertiesToAnalyse(abstractModel);
        MatcherAssert.assertThat((Object)analyse.getQ2y(), (Matcher)CoreMatchers.is((Object)0.99901));
        MatcherAssert.assertThat((Object)analyse.getR2x(), (Matcher)CoreMatchers.is((Object)0.99721));
    }
}

