/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.util.Collections;
import java.util.List;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.entry.measurement.Measurement;

public class ReduceFromFileSize {
    public static final int MAX_DATA_SIZE = 100000000;
    public static final int MAX_DIMENSION = 1000000;
    private final int value;

    public ReduceFromFileSize(FileInfo fileInfo, int n, int n2) {
        int n3 = (int)Math.max(Math.ceil(Math.sqrt((double)fileInfo.totalSize / (double)n)), 1.0);
        int n4 = (int)Math.max(Math.ceil(Math.sqrt((double)fileInfo.maxDimension / (double)n2)), 1.0);
        this.value = Math.max(n3, n4);
    }

    public int value() {
        return this.value;
    }

    public static ReduceFromFileSize fromMeasurement(Measurement measurement) {
        return ReduceFromFileSize.fromMeasurements(Collections.singletonList(measurement));
    }

    public static ReduceFromFileSize fromMeasurements(List<Measurement> list) {
        FileInfo fileInfo = new FileInfo();
        for (Measurement measurement : list) {
            RawFile rawFile = measurement.rawFile();
            if (rawFile == null || rawFile.file() == null) continue;
            fileInfo.totalSize += rawFile.file().length();
            RawHeader rawHeader = rawFile.header();
            int n = rawHeader.pixelWidth().value * rawHeader.frameCount().value;
            fileInfo.maxDimension = Math.max(fileInfo.maxDimension, n);
        }
        return new ReduceFromFileSize(fileInfo, 100000000, 1000000);
    }

    public static class FileInfo {
        public long totalSize = 0L;
        public int maxDimension;
    }
}

