/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.entry.analyse.model.ClassificationModel;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.model.AbstractModel;

public class RuntimeClassificationModel
extends AbstractRuntimeModel
implements Model.IClassificationModel {
    public RuntimeClassificationModel(BreezeProgress breezeProgress, Analyse analyse) {
        this(breezeProgress, analyse, (List<FactorOrDescriptor>)null);
    }

    public RuntimeClassificationModel(BreezeProgress breezeProgress, Analyse analyse, List<FactorOrDescriptor> list) {
        super(breezeProgress, analyse, list);
    }

    public RuntimeClassificationModel(BreezeProgress breezeProgress, Analyse analyse, AbstractModel abstractModel) {
        super(breezeProgress, analyse, abstractModel);
        CategoryFactor categoryFactor = analyse.getWorkflow().getCategoryFactors().getByName(analyse.getCategoryFactor().getName());
        this.setVariables(Collections.singletonList(categoryFactor));
    }

    @Override
    public void createModel(BreezeProgressManager breezeProgressManager) {
        CategoryFactor categoryFactor = this.getFactor();
        ClassificationModel.excludeNoClass(breezeProgressManager, this.dataSet, categoryFactor);
        Properties properties = new Properties();
        properties.put("rethrowexceptions", "true");
        properties.put("crossvalidation", "false");
        properties.put("maxcomponents", "0");
        properties.put("cutofflow", "0");
        properties.put("cutoffhigh", "1");
        properties.put("ycategory", categoryFactor.getName());
        this.model = this.dataSet.createModel((ProgressManager)breezeProgressManager, "pls-da", properties);
        this.model.setName(this.analyse.getUid());
        ModelProperties.setFromProperties(breezeProgressManager, this.model, this.analyse, false);
        this.model.setEnabled(true);
    }

    @Override
    public void updateSampleInclusionAndTestFlags(ProgressManager progressManager, boolean[] blArray, boolean[] blArray2) {
        super.updateSampleInclusionAndTestFlags(progressManager, blArray, blArray2);
        ClassificationModel.excludeNoClass(progressManager, this.dataSet, this.getFactor());
    }

    @Override
    protected void save(BreezeProgressManager breezeProgressManager, AbstractDataMatrix abstractDataMatrix, File file, boolean bl, boolean bl2) {
        if (abstractDataMatrix != null) {
            Properties properties = new Properties();
            properties.put("obsheader", "false");
            properties.put("header", String.valueOf(bl2));
            properties.put("classname", this.getFactor().getName());
            properties.put("classindex", this.getFactor().getClassIndexHashMap());
            abstractDataMatrix.save((ProgressManager)breezeProgressManager, file.getAbsolutePath(), "csv", null, properties);
        }
    }

    @Override
    public CategoryFactor getFactor() {
        if (this.selectedProperties != null && this.selectedProperties.size() > 0) {
            return (CategoryFactor)this.selectedProperties.get(0);
        }
        return null;
    }

    public List<CategoryFactor> getSelectedVariables() {
        CategoryFactor categoryFactor = this.getFactor();
        if (categoryFactor != null) {
            return List.of(categoryFactor);
        }
        if (!this.getAllVariables(this.segmentationLevel, null).isEmpty()) {
            return Collections.singletonList((CategoryFactor)this.getAllVariables(this.segmentationLevel, null).get(0));
        }
        return List.of();
    }

    @Override
    public List<FactorOrDescriptor> getAllVariables(int n, String string) {
        return FactorOrDescriptor.toList(this.analyse.getWorkflow().getCategoryFactors());
    }

    @Override
    public void finishAndSave(BreezeProgressManager breezeProgressManager) {
        this.analyse.getCategoryFactors().clear();
        this.analyse.getCategoryFactors().add((CategoryFactor)this.getFactor().cloneKeepId());
        this.analyse.addModelPropertiesToAnalyse(this.model);
        this.commonModelSettings.saveEvinceModel(breezeProgressManager);
        this.analyse.save(this);
    }

    @Override
    public void balanceTrainData(BreezeProgress breezeProgress, boolean bl, boolean bl2) {
        new ClassificationModel.ClassificationBalanceModel(this.dataSet, this.dataSet.getCategory(this.getFactor().getName())).performAnalysis(breezeProgress, bl, bl2);
    }
}

