/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.analyse.model.QuantificationModel;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.model.AbstractModel;

public class RuntimeQuantificationModel
extends AbstractRuntimeModel {
    public RuntimeQuantificationModel(BreezeProgress breezeProgress, Analyse analyse) {
        super(breezeProgress, analyse, (List<FactorOrDescriptor>)null);
    }

    public RuntimeQuantificationModel(BreezeProgress breezeProgress, Analyse analyse, List<FactorOrDescriptor> list) {
        super(breezeProgress, analyse, list);
    }

    public RuntimeQuantificationModel(BreezeProgress breezeProgress, Analyse analyse, AbstractModel abstractModel) {
        super(breezeProgress, analyse, abstractModel);
        Workflow workflow = analyse.getWorkflow();
        ArrayList<FactorOrDescriptor> arrayList = new ArrayList<FactorOrDescriptor>();
        for (String string : abstractModel.getVariableArray()) {
            PropertyFactor propertyFactor = workflow.getPropertyFactors().getByName(string);
            arrayList.add(propertyFactor);
        }
        this.setVariables(arrayList);
    }

    @Override
    public boolean setSegmentationLevel(BreezeProgressManager breezeProgressManager, int n, String string, Model.ModelStatus modelStatus) {
        if (super.setSegmentationLevel(breezeProgressManager, n, string, modelStatus)) {
            this.addAndInitializeUvScaleTransform(breezeProgressManager, this.dataSet);
            return true;
        }
        return false;
    }

    private void addAndInitializeUvScaleTransform(BreezeProgressManager breezeProgressManager, DataSet dataSet) {
        VariablesInfo variablesInfo = dataSet.getVarDataInfo();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
            if (innerColumnBoolean.getValueBool(i)) continue;
            arrayList.add((double)i + 1.0);
        }
        dataSet.createModification((ProgressManager)breezeProgressManager, "var", "uvscale", arrayList.toArray(new Double[0]));
    }

    @Override
    public void createModel(BreezeProgressManager breezeProgressManager) {
        VariablesInfo variablesInfo = this.dataSet.getVarDataInfo();
        InnerColumnString innerColumnString = (InnerColumnString)variablesInfo.getPrimaryColumnByType(0);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
        InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
        for (int i = 0; i < innerColumnBoolean2.getSize(); ++i) {
            if (innerColumnBoolean2.getValueBool(i)) continue;
            innerColumnBoolean.setValueBool(i, this.isVariableIncluded(innerColumnString.getValueLocal(i)));
        }
        Properties properties = new Properties();
        properties.put("rethrowexceptions", "true");
        properties.put("crossvalidation", "false");
        properties.put("maxcomponents", "0");
        this.model = this.dataSet.createModel((ProgressManager)breezeProgressManager, "pls", properties);
        this.model.setName(this.analyse.getUid());
        ModelProperties.setFromProperties(breezeProgressManager, this.model, this.analyse, false);
        this.model.setEnabled(true);
    }

    public List<FactorOrDescriptor> getSelectedVariables() {
        if (this.selectedProperties != null) {
            return this.selectedProperties;
        }
        return this.getAllVariables(this.segmentationLevel, null);
    }

    private boolean isVariableIncluded(String string) {
        for (FactorOrDescriptor factorOrDescriptor : this.selectedProperties) {
            if (!factorOrDescriptor.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<FactorOrDescriptor> getAllVariables(int n, String string) {
        Workflow workflow = this.analyse.getWorkflow();
        List<FactorOrDescriptor> list = FactorOrDescriptor.toList(workflow.getPropertyFactors());
        list.addAll(workflow.getSegmentationLevelDescriptorNodes(new SegmentationIdentifier(n, string), false));
        return list;
    }

    public List<FactorOrDescriptor> getPropertyList() {
        return this.selectedProperties;
    }

    @Override
    public void finishAndSave(BreezeProgressManager breezeProgressManager) {
        this.analyse.getPropertyFactors().clear();
        for (FactorOrDescriptor factorOrDescriptor : this.getPropertyList()) {
            this.analyse.getPropertyFactors().add((PropertyFactor)factorOrDescriptor.cloneKeepId());
        }
        this.analyse.addModelPropertiesToAnalyse(this.model);
        this.commonModelSettings.saveEvinceModel(breezeProgressManager);
        this.analyse.save(this);
    }

    @Override
    public void balanceTrainData(BreezeProgress breezeProgress, boolean bl, boolean bl2) {
        new QuantificationModel.QuantificationBalanceModel(this.dataSet, 10).performAnalysis(breezeProgress, bl, bl2);
    }

    @Override
    protected void save(BreezeProgressManager breezeProgressManager, AbstractDataMatrix abstractDataMatrix, File file, boolean bl, boolean bl2) {
        if (abstractDataMatrix != null) {
            AbstractDataMatrix abstractDataMatrix2 = bl ? this.dataSet.getMatrix(2) : this.dataSet.getMatrix(3);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Variable");
            for (int i = 0; i < abstractDataMatrix2.getN(); ++i) {
                stringBuilder.append(";");
                stringBuilder.append(abstractDataMatrix2.getValue(i, 0));
            }
            Properties properties = new Properties();
            properties.put("obsheader", "false");
            properties.put("header", String.valueOf(bl2));
            properties.put("variable", stringBuilder.toString());
            abstractDataMatrix.save((ProgressManager)breezeProgressManager, file.getAbsolutePath(), "csv", null, properties);
        }
    }
}

