/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.io.File;
import java.nio.file.Files;
import lombok.Generated;
import org.json.JSONObject;
import org.w3c.dom.Element;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.entry.analyse.model.SampleModel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;

public class RuntimeSampleModel
extends SampleModel {
    private File newOnnxFile;
    private File trainingJsonFile;
    private final AbstractRuntimeModel.RuntimeSettings runtimeSettings;

    public RuntimeSampleModel(Analyse analyse) {
        super(analyse);
        this.runtimeSettings = analyse.getSetupXmlNode() != null ? new AbstractRuntimeModel.RuntimeSettings(analyse.getSetupXmlNode()) : new AbstractRuntimeModel.RuntimeSettings();
    }

    public File getScriptFile() {
        if (this.runtimeSettings.scriptFile != null) {
            return new File(this.runtimeSettings.scriptFile);
        }
        return null;
    }

    public void setScriptFile(File file) {
        this.runtimeSettings.scriptFile = file.getAbsolutePath();
    }

    public AbstractDataMatrix getTrainingData(BreezeProgressManager breezeProgressManager) {
        int n = this.getAbstractModel().getComponentsInt();
        this.getAbstractModel().setComponents((ProgressManager)breezeProgressManager, 0);
        AbstractDataMatrix abstractDataMatrix = this.getEvinceMatrix(breezeProgressManager, "Xres");
        this.getAbstractModel().setComponents((ProgressManager)breezeProgressManager, n);
        return abstractDataMatrix;
    }

    @Override
    public void saveXml(Element element) {
        super.saveXml(element);
        if (this.trainingJsonFile != null && this.trainingJsonFile.exists()) {
            AbstractRuntimeModel.RuntimeResultList runtimeResultList = new AbstractRuntimeModel.RuntimeResultList(new JSONObject(Files.readString(this.trainingJsonFile.toPath())), BasicAnalyse.ModelType.Sample, true);
            AbstractRuntimeModel.RuntimeResult runtimeResult = runtimeResultList.results.get(0);
            runtimeResult.selected = true;
            this.runtimeSettings.method = runtimeResult.algorithmName;
            this.runtimeSettings.displayName = runtimeResult.displayName;
            this.runtimeSettings.time = (int)runtimeResult.runtimeInSeconds;
            runtimeResultList.save(element);
            this.runtimeSettings.save(element);
        }
    }

    @Generated
    public File getNewOnnxFile() {
        return this.newOnnxFile;
    }

    @Generated
    public void setNewOnnxFile(File file) {
        this.newOnnxFile = file;
    }

    @Generated
    public File getTrainingJsonFile() {
        return this.trainingJsonFile;
    }

    @Generated
    public void setTrainingJsonFile(File file) {
        this.trainingJsonFile = file;
    }
}

