/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.realtime.segmentation.SegmentationMatrix;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.image.RtObjectIdentificationHelper;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.analyse.model.CommonModelSettings;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.analyse.model.ReduceFromFileSize;
import se.prediktera.breeze.entry.analyse.model.UidIndex;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.evince.data.DataTemplatesHelper;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.evince.matrix.FrameMatrix;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.util.CompactIntegerList;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.model.AbstractModel;

public class SampleModel
implements Model {
    private final Analyse analyse;
    private Project_GUI project_GUI;
    private DataSet dataSet;
    private CommonModelSettings commonModelSettings;
    private List<Measurement> includedMeasurements;
    private AbstractModel model;
    private DataSet backgroundDataSet;
    private final ModelXmlFormat format = new ModelXmlFormat();
    private int reduce = 1;

    public SampleModel(Analyse analyse) {
        this.analyse = analyse;
    }

    public void loadDatasetWithMeasurements(BreezeProgress breezeProgress, List<Measurement> list) {
        boolean bl = this.measurementListHasChanged(this.includedMeasurements, list);
        if (this.hasValidDataSet() && !bl) {
            return;
        }
        this.includedMeasurements = list;
        if (this.dataSet != null) {
            this.dataSet.close();
        }
        this.dataSet = this.createDatasetFromMeasurements((BreezeProgressManager)breezeProgress, list);
        this.commonModelSettings = new CommonModelSettings(this.analyse, this.dataSet);
        int n = this.parseSetupReduced();
        if (!bl && n == this.reduce) {
            this.parsePixels(this.analyse.getSetupXmlNode(), this.dataSet);
        }
        this.model = this.getOrCreateModel(breezeProgress);
    }

    private int parseSetupReduced() {
        List<Node> list;
        if (this.analyse.getSetupXmlNode() != null && (list = XmlParserHelper.parseChildNodes(this.analyse.getSetupXmlNode(), "reduce")).size() == 1) {
            return RtDataFormat.toNumberInt(list.get(0).getTextContent());
        }
        return -1;
    }

    private boolean hasValidDataSet() {
        return this.dataSet != null && !this.dataSet.isCleaned();
    }

    private void parsePixels(Node node, DataSet dataSet) {
        ModelXmlFormat modelXmlFormat = new ModelXmlFormat();
        CompactIntegerList compactIntegerList = modelXmlFormat.parsePixels(node);
        if (compactIntegerList != null) {
            ObservationInfo observationInfo = dataSet.getObsDataInfo();
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(4);
            innerColumnBoolean.fillColumn(false);
            for (Integer n : compactIntegerList) {
                innerColumnBoolean.setValueBool(n.intValue(), true);
            }
        }
    }

    private DataSet createDatasetFromMeasurements(BreezeProgressManager breezeProgressManager, List<Measurement> list) {
        this.reduce = SampleModel.calculateReduceFromFileSize(this.analyse, list);
        Properties properties = new Properties();
        properties.put("reducerows", String.valueOf(this.reduce));
        properties.put("reducecolumns", String.valueOf(this.reduce));
        properties.put("replacemissing", "true");
        properties.put("spikeremoval", String.valueOf(false));
        properties.put("stdev_pvalue", String.valueOf(0.01));
        properties.put("wl_pvalue", String.valueOf(1.0E-4));
        properties.put("alignment", "square");
        properties.put("recursive", "true");
        properties.put("includerootfolder", "false");
        properties.put("forceinclude", "false");
        if (this.project_GUI == null) {
            this.project_GUI = Project_GUI.createNewProject((boolean)false, (String)this.analyse.getUid());
        }
        Case case_ = this.project_GUI.getOrCreatePrimaryCase();
        FrameMatrix frameMatrix = FrameMatrix.readReferenceOrRawFrameMatrix((BreezeProgress)breezeProgressManager, list, new FrameListFromRaw.Reduce(this.reduce));
        DataSet dataSet = case_.importCaseFromMatrix((AbstractDataMatrix)frameMatrix, this.project_GUI, (ProgressManager)breezeProgressManager, this.reduce);
        frameMatrix.initiateCaseAndDataSet(case_, dataSet, list.get(0).getRefSettings(null));
        dataSet.createModification((ProgressManager)breezeProgressManager, "var", "center");
        dataSet.setTest(Double.valueOf(1.0), null, properties);
        dataSet.excludeZeroObservationVariances();
        this.backgroundDataSet = dataSet.cloneDataSet();
        return dataSet;
    }

    public int getReduce() {
        return this.reduce;
    }

    @Override
    public AbstractModel getModel() {
        return this.model;
    }

    private boolean measurementListHasChanged(List<Measurement> list, List<Measurement> list2) {
        if (list == null || list.size() != list2.size()) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getUid().equals(list2.get(i).getUid())) continue;
            return true;
        }
        return false;
    }

    private static int calculateReduceFromFileSize(Analyse analyse, List<Measurement> list) {
        int n = analyse.getDefaultReduce();
        if (n > 0) {
            return n;
        }
        return ReduceFromFileSize.fromMeasurements(list).value();
    }

    public boolean isMeasurementIncluded(Measurement measurement) {
        if (this.includedMeasurements == null) {
            this.parseMeasurementsFromRecordGroups();
        }
        return this.includedMeasurements.contains(measurement);
    }

    public boolean hasIncludedMeasurements() {
        if (this.includedMeasurements == null) {
            return this.parseMeasurementsFromRecordGroups();
        }
        return this.includedMeasurements != null;
    }

    @Override
    public void applyChanges(ProgressManager progressManager) {
        this.dataSet.applyChanges(progressManager);
    }

    @Override
    public ModelProperties.CriticalValues getCriticalValues() {
        return new ModelProperties.CriticalValues(this.model, this.analyse);
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public List<Sample> getIncludedSampleList() {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (Measurement measurement : this.includedMeasurements) {
            if (!this.isMeasurementIncluded(measurement) || measurement.getChildCount() <= 0) continue;
            arrayList.add(measurement.getRootSample());
        }
        return arrayList;
    }

    private boolean parseMeasurementsFromRecordGroups() {
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        for (AnalyseSpectralGroup analyseSpectralGroup : MeasurementDataSource.getSortedGroups(this.analyse.getGroups())) {
            arrayList.addAll(MeasurementDataSource.getSortedMeasurements(analyseSpectralGroup));
        }
        if (this.analyse.getSetupXmlNode() != null) {
            this.includedMeasurements = new ModelXmlFormat().filterMeasurements(arrayList, this.analyse.getSetupXmlNode());
        }
        if (this.includedMeasurements == null || this.includedMeasurements.isEmpty()) {
            this.includedMeasurements = arrayList;
            return false;
        }
        return true;
    }

    @Override
    public void saveXml(Element element) {
        this.format.saveIncludedMeasurements(element, this.includedMeasurements);
        this.commonModelSettings.saveXml(element, this.model);
        this.format.savePixels(element, this.dataSet);
        XmlParserHelper.addElement((Node)element, "reduce", String.valueOf(this.reduce));
    }

    @Override
    public AbstractDataMatrix getEvinceMatrix(BreezeProgress breezeProgress, String string) {
        if (string.equals("origmatrix")) {
            return this.dataSet.getOriginalMatrix();
        }
        if (string.equals("xtraining")) {
            return this.dataSet.getMatrix(0);
        }
        if (string.startsWith("model")) {
            return this.getOrCreateModelMatrix(breezeProgress, string);
        }
        if (string.equals("background")) {
            return this.backgroundDataSet.getMatrix(0);
        }
        if (string.equals("Xres")) {
            return this.model.getMatrixByName("Xres");
        }
        if (string.equals("Xres Test")) {
            return this.model.getLocalPredictionNode().getMatrixByName("Xres Test");
        }
        throw new RuntimeException("SampleModelDataHelper: No such matrix type " + string);
    }

    protected AbstractModel getAbstractModel() {
        if (this.dataSet != null && this.analyse != null) {
            return (AbstractModel)this.dataSet.getNodeByName(this.analyse.getUid());
        }
        return null;
    }

    private AbstractDataMatrix getOrCreateModelMatrix(BreezeProgress breezeProgress, String string) {
        return DataTemplatesHelper.getMatrix(this.getOrCreateModel(breezeProgress), string);
    }

    private AbstractModel getOrCreateModel(BreezeProgress breezeProgress) {
        String string = this.analyse.getUid();
        this.model = this.getAbstractModel();
        if (this.model == null && this.dataSet != null) {
            this.model = this.dataSet.createModel((ProgressManager)((BreezeProgressManager)breezeProgress), "pca", Double.valueOf(2.0));
            if (this.model != null) {
                this.model.setName(string);
                ModelProperties.setFromProperties((BreezeProgressManager)breezeProgress, this.model, this.analyse, true);
                this.model.setEnabled(true);
            }
        }
        return this.model;
    }

    @Override
    public void updateTransformation(ModelProperties.TransformationProperties transformationProperties) {
        this.commonModelSettings.updateTransformation(transformationProperties);
    }

    @Override
    public void updateIncludedWavelengths(boolean[] blArray) {
        this.commonModelSettings.updateIncludedWavelengths(blArray);
    }

    @Override
    public HashMap<Model.Transformation, ModelProperties.TransformationProperties> getTransformations() {
        return this.commonModelSettings.getTransformations();
    }

    public int getPixelCount() {
        return this.dataSet.getMatrix(0).getN();
    }

    public RtObjectIdentificationHelper.RtIdentifiedObjectList getObjects() {
        return RtObjectIdentificationHelper.identifyAreas(this.createBinaryMatrix(), 0, 10, 0);
    }

    private SegmentationMatrix createBinaryMatrix() {
        FoldMatrix foldMatrix = new FoldMatrix(this.dataSet.getMatrix(0));
        int n = foldMatrix.getN();
        int n2 = foldMatrix.getK();
        SegmentationMatrix segmentationMatrix = new SegmentationMatrix(n, n2);
        int[] nArray = foldMatrix.getFNref();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (nArray[i * n + j] < 0) continue;
                segmentationMatrix.setValue(j, i, 1);
            }
        }
        return segmentationMatrix;
    }

    @Override
    public boolean isWavelengthIndexIncluded(int n) {
        return this.commonModelSettings.isWavelengthIndexIncluded(n);
    }

    @Override
    public float getWavelengthImportance(int n) {
        return this.commonModelSettings.getWavelengthImportance(this.model, n);
    }

    public int getWavelengthCount() {
        return this.commonModelSettings.getWavelengthCount();
    }

    public void setDcrit(boolean bl) {
        this.model.setUseDcrit(bl);
    }

    public void setHotellingT2(boolean bl) {
        this.model.setUseHotelling(bl);
    }

    @Override
    public void close() {
        if (this.dataSet != null) {
            this.dataSet.getProject_GUI().closeProjectNow();
            this.dataSet = null;
        }
    }

    @Override
    public void finishAndSave(BreezeProgressManager breezeProgressManager) {
        this.analyse.getCategoryFactors().clear();
        CategoryFactor categoryFactor = this.analyse.getCategoryFactors().add(new CategoryFactor("SampleCategory"));
        categoryFactor.addClass("Sample");
        this.analyse.addModelPropertiesToAnalyse(this.model);
        this.commonModelSettings.saveEvinceModel(breezeProgressManager);
        this.analyse.save(this);
    }

    @Override
    public Analyse getAnalyse() {
        return this.analyse;
    }

    private static class ModelXmlFormat {
        private ModelXmlFormat() {
        }

        public List<Measurement> filterMeasurements(List<Measurement> list, Node node) {
            ArrayList<UidIndex> arrayList = new ArrayList<UidIndex>();
            this.parse(node, arrayList, "sample");
            return this.filter(list, arrayList);
        }

        private List<Measurement> filter(List<Measurement> list, List<UidIndex> list2) {
            ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
            for (Measurement measurement : list) {
                if (!this.hasUid(list2, measurement.getUid())) continue;
                arrayList.add(measurement);
            }
            return arrayList;
        }

        private boolean hasUid(List<UidIndex> list, String string) {
            for (UidIndex uidIndex : list) {
                if (!uidIndex.getUid().equals(string)) continue;
                return true;
            }
            return false;
        }

        private boolean hasUidIndex(List<UidIndex> list, String string, int n) {
            for (UidIndex uidIndex : list) {
                if (!uidIndex.getUid().equals(string) || !uidIndex.hasIndex(n)) continue;
                return true;
            }
            return false;
        }

        private void parse(Node node, List<UidIndex> list, String string) {
            List<Node> list2 = XmlParserHelper.getNodeList(node, string + "s", null);
            for (Node node2 : list2) {
                List<Node> list3 = XmlParserHelper.getNodeList(node2, string, null);
                for (Node node3 : list3) {
                    String string2 = XmlParserHelper.getAttribute(node3, "uid");
                    UidIndex uidIndex = new UidIndex(string2, null);
                    list.add(uidIndex);
                    CompactIntegerList compactIntegerList = new CompactIntegerList(node3.getTextContent());
                    for (int n : compactIntegerList) {
                        uidIndex.addIndex(n);
                    }
                }
            }
        }

        private CompactIntegerList parsePixels(Node node) {
            List<Node> list = XmlParserHelper.getNodeList(node, "pixels", null);
            if (list.size() == 1) {
                return new CompactIntegerList(list.get(0).getTextContent());
            }
            return null;
        }

        private void saveIncludedMeasurements(Node node, List<Measurement> list) {
            Element element = XmlParserHelper.addElement(node, "samples");
            for (Measurement measurement : list) {
                Element element2 = XmlParserHelper.addElement(element, "sample");
                element2.setAttribute("uid", measurement.getUid());
            }
            XmlParserHelper.setAttribute((Node)element, "number", list.size());
        }

        public void savePixels(Element element, DataSet dataSet) {
            Element element2 = XmlParserHelper.addElement(element, "pixels");
            ObservationInfo observationInfo = dataSet.getObsDataInfo();
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(4);
            CompactIntegerList compactIntegerList = new CompactIntegerList();
            for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                if (!innerColumnBoolean.getValueBool(i)) continue;
                compactIntegerList.add(i);
            }
            element2.setTextContent(compactIntegerList.toString());
        }
    }
}

