/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.analyse.model;

import java.util.ArrayList;
import java.util.HashMap;
import se.prediktera.breeze.entry.measurement.Measurement;

public class UidIndex {
    private final String uid;
    private Measurement measurement;
    public ArrayList<Integer> indexList = new ArrayList();
    private String seg;

    public UidIndex(String string, String string2) {
        this.uid = string;
        this.seg = string2;
    }

    public UidIndex(Measurement measurement) {
        this.measurement = measurement;
        this.uid = measurement.getUid();
    }

    public String getUid() {
        if (this.measurement != null) {
            return this.measurement.getUid();
        }
        return this.uid;
    }

    public String getSeg() {
        return this.seg;
    }

    public void addIndex(int n) {
        this.indexList.add(n);
    }

    public void removeIndex(int n) {
        int n2 = this.indexOf(n);
        if (n2 >= 0) {
            this.indexList.remove(n2);
        }
    }

    public int getIndexSize() {
        return this.indexList.size();
    }

    public ArrayList<Integer> getIndexList() {
        return this.indexList;
    }

    public boolean hasIndex(int n) {
        return this.indexOf(n) >= 0;
    }

    private int indexOf(int n) {
        for (int i = 0; i < this.indexList.size(); ++i) {
            if (n != this.indexList.get(i)) continue;
            return i;
        }
        return -1;
    }

    public UidIndex copy() {
        UidIndex uidIndex = new UidIndex(this.uid, this.seg);
        uidIndex.indexList.addAll(this.indexList);
        return uidIndex;
    }

    public static class UidIndexSegMap {
        private final HashMap<String, UidIndex> hashMap = new HashMap();
        private UidIndex def;

        public UidIndexSegMap(UidIndexList uidIndexList, String string) {
            for (UidIndex uidIndex : uidIndexList) {
                if (!uidIndex.getUid().equals(string)) continue;
                if (uidIndex.getSeg() == null) {
                    this.def = uidIndex;
                }
                this.hashMap.put(uidIndex.getSeg(), uidIndex);
            }
        }

        public UidIndex getOrDefault(Object object) {
            UidIndex uidIndex = this.hashMap.get(object);
            if (uidIndex != null) {
                return uidIndex;
            }
            return this.def;
        }

        public void put(String string, UidIndex uidIndex) {
            this.hashMap.put(string, uidIndex);
        }
    }

    public static class UidIndexList
    extends ArrayList<UidIndex> {
        public boolean hasUidIndex(String string, String string2, int n) {
            UidIndex uidIndex = this.getUidIndex(string, string2);
            return uidIndex != null && uidIndex.hasIndex(n);
        }

        public UidIndexSegMap getUidIndexSegMap(String string) {
            return new UidIndexSegMap(this, string);
        }

        public UidIndex getUidIndex(String string, String string2) {
            for (UidIndex uidIndex : this) {
                if (!uidIndex.getUid().equals(string) || uidIndex.getSeg() != null && string2 != null && !string2.equals(uidIndex.getSeg())) continue;
                return uidIndex;
            }
            return null;
        }
    }
}

