/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.application;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.sample.TrackInformation;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.entry.application.RuntimeStreamFormat;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SamplePath;
import se.prediktera.breeze.frontend.main.play.realtime.SampleTrackRenderer;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.map.common.error.Logg;

public class RuntimeObjectFormat {
    private RuntimeObjectSegmentationLevel segmentationLevel;

    public RuntimeObjectFormat(JSONObject jSONObject, RuntimeWorkflow runtimeWorkflow) {
        JSONObject jSONObject2;
        if (jSONObject.has("ObjectFormat") && !(jSONObject2 = (JSONObject)jSONObject.get("ObjectFormat")).isNull("Id")) {
            this.segmentationLevel = new RuntimeObjectSegmentationLevel(jSONObject2, runtimeWorkflow);
        }
    }

    public RuntimeObjectSegmentationLevel getSegmentationLevel() {
        return this.segmentationLevel;
    }

    public static class RuntimeObjectSegmentationLevel {
        private final String id;
        private final String name;
        private final DescriptorTuples descriptors = new DescriptorTuples();

        public RuntimeObjectSegmentationLevel(JSONObject jSONObject, RuntimeWorkflow runtimeWorkflow) {
            this.id = jSONObject.getString("Id");
            this.name = jSONObject.getString("Name");
            for (Object e : jSONObject.getJSONArray("Descriptors")) {
                JSONObject jSONObject2 = (JSONObject)e;
                DescriptorTuple descriptorTuple = new DescriptorTuple(jSONObject2, runtimeWorkflow);
                this.descriptors.add(descriptorTuple);
                runtimeWorkflow.getDescriptors().add(descriptorTuple);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public DescriptorTuples getDescriptors() {
            return this.descriptors;
        }
    }

    public static class DescriptorValues {
        private String id;
        private int cameraId;
        private BufferedTcpStream.HeaderTime startTime;
        private float[] values;
        private int[][] selectionPath;
        private int[] centerPoint;
        private BufferedTcpStream.HeaderTime endTime;
        private long startLine;
        private long endLine;
        private Sample sample;

        public DescriptorValues(String string, int n, BufferedTcpStream.HeaderTime headerTime, Frame frame) {
            this.id = string;
            this.cameraId = n;
            this.startTime = headerTime;
            this.values = new float[frame.columns.value];
            for (int i = 0; i < frame.columns.value; ++i) {
                this.values[i] = frame.getFrameValue(0, i);
            }
            this.selectionPath = null;
            this.centerPoint = null;
        }

        public DescriptorValues(String string, int n, BufferedTcpStream.HeaderTime headerTime, BufferedTcpStream.HeaderTime headerTime2, long l, long l2, float[] fArray, int[][] nArray, int[] nArray2) {
            this.id = string;
            this.cameraId = n;
            this.startTime = headerTime;
            this.endTime = headerTime2;
            this.startLine = l;
            this.endLine = l2;
            this.values = fArray;
            this.selectionPath = nArray;
            this.centerPoint = nArray2;
        }

        public DescriptorValues(Sample sample) {
            this.sample = sample;
        }

        public String getId() {
            return this.id;
        }

        public int getCameraId() {
            return this.cameraId;
        }

        public BufferedTcpStream.HeaderTime getStartTime() {
            return this.startTime;
        }

        public BufferedTcpStream.HeaderTime getEndTime() {
            return this.endTime;
        }

        public long getStartLine() {
            return this.startLine;
        }

        public long getEndLine() {
            return this.endLine;
        }

        public float[] getValues() {
            return this.values;
        }

        public int[][] getSelectionPath() {
            return this.selectionPath;
        }

        public boolean hasSelectionPath() {
            return this.selectionPath != null;
        }

        public int[] getCenterPoint() {
            return this.centerPoint;
        }

        public Sample getSample() {
            return this.sample;
        }

        public SampleTrackRenderer.SampleTrack createSampleTrack(DescriptorTuples descriptorTuples, long l, long l2) {
            GeneralPath generalPath = SamplePath.createGeneralPath(this.selectionPath);
            return new RealtimeSampleTrack(new TrackInformation(l, l2, this.centerPoint[0], this.centerPoint[1], 0), generalPath, descriptorTuples, this.values);
        }

        public static DescriptorValues fromJSON(String string) {
            JSONObject jSONObject = new JSONObject(string);
            if (BufferedTcpStream.PrintDebug) {
                Logg.info((String)jSONObject.toString(2), (Object[])new Object[0]);
            }
            String string2 = jSONObject.getString("Id");
            int n = jSONObject.getInt("CameraId");
            BufferedTcpStream.NanoTime nanoTime = new BufferedTcpStream.NanoTime(jSONObject.getLong("StartTime"));
            BufferedTcpStream.NanoTime nanoTime2 = new BufferedTcpStream.NanoTime(jSONObject.getLong("EndTime"));
            long l = jSONObject.getLong("StartLine");
            long l2 = jSONObject.getLong("EndLine");
            JSONArray jSONArray = jSONObject.getJSONArray("Descriptors");
            float[] fArray = new float[jSONArray.length()];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = (float)jSONArray.getDouble(i);
            }
            if (jSONObject.has("Shape")) {
                JSONObject jSONObject2 = (JSONObject)jSONObject.get("Shape");
                return new DescriptorValues(string2, n, nanoTime, nanoTime2, l, l2, fArray, DescriptorValues.getBorderPath(jSONObject2, "Border"), DescriptorValues.getPath(jSONObject2, "Center")[0]);
            }
            return new DescriptorValues(string2, n, nanoTime, nanoTime2, l, l2, fArray, null, null);
        }

        private static int[][] getBorderPath(JSONObject jSONObject, String string) {
            JSONArray jSONArray = jSONObject.getJSONArray(string);
            int[][] nArray = new int[jSONArray.length()][2];
            for (int i = 0; i < nArray.length; ++i) {
                JSONArray jSONArray2 = jSONArray.getJSONArray(i);
                nArray[i][0] = jSONArray2.getInt(0);
                nArray[i][1] = jSONArray2.getInt(1);
            }
            return nArray;
        }

        private static int[][] getPath(JSONObject jSONObject, String string) {
            JSONArray jSONArray = jSONObject.getJSONArray(string);
            int[][] nArray = new int[jSONArray.length() / 2][2];
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i][0] = jSONArray.getInt(n++);
                nArray[i][1] = jSONArray.getInt(n++);
            }
            return nArray;
        }

        private static class RealtimeSampleTrack
        extends SampleTrackRenderer.SampleTrack {
            private final DescriptorTuples descriptorTuples;
            private final float[] values;

            public RealtimeSampleTrack(TrackInformation trackInformation, GeneralPath generalPath, DescriptorTuples descriptorTuples, float[] fArray) {
                super(trackInformation, generalPath);
                this.descriptorTuples = descriptorTuples;
                this.values = fArray;
            }

            @Override
            public float getAnalyseValue(String string, String string2) {
                Integer n = this.descriptorTuples.getAnalyseIndex(string, string2);
                if (n != null) {
                    return this.values[n];
                }
                return 0.0f;
            }

            @Override
            public Color getDescriptorColor(int n) {
                CategoryFactor categoryFactor;
                DescriptorTuple descriptorTuple = this.descriptorTuples.getList().get(n);
                RtAnalyse rtAnalyse = descriptorTuple.getRtAnalyse();
                if (rtAnalyse != null && (categoryFactor = rtAnalyse.getCategoryFactor()) != null) {
                    return categoryFactor.getClassByValueIdx((int)this.values[n]).getColor();
                }
                return null;
            }
        }
    }

    public static class DescriptorTuple {
        private final String analyseId;
        private final String factorId;
        private final String name;
        private final String type;
        private final RtAnalyse rtAnalyse;
        private boolean result = true;
        private boolean thumbnail;

        public DescriptorTuple(String string, String string2, String string3) {
            this.analyseId = string;
            this.factorId = string2;
            this.name = string3;
            this.type = "";
            this.rtAnalyse = null;
        }

        public DescriptorTuple(JSONObject jSONObject, RuntimeWorkflow runtimeWorkflow) {
            this.factorId = jSONObject.has("Id") ? jSONObject.getString("Id") : null;
            this.name = jSONObject.getString("Name");
            this.type = jSONObject.getString("Type");
            if (jSONObject.has("Result")) {
                this.result = jSONObject.getBoolean("Result");
            }
            if (jSONObject.has("Thumbnail")) {
                this.thumbnail = jSONObject.getBoolean("Thumbnail");
            }
            if (jSONObject.has("Analyse")) {
                this.analyseId = jSONObject.getString("Analyse");
                this.rtAnalyse = new RtAnalyse(this.analyseId, this.name, this.type.equals("Category") ? BasicAnalyse.ModelMethod.ClassificationPlsDa : BasicAnalyse.ModelMethod.QuantificationPls, runtimeWorkflow.getStudyId());
                if (this.type.equals("Property")) {
                    this.rtAnalyse.getPropertyFactors().add(new PropertyFactor(this.name, this.factorId));
                    runtimeWorkflow.getAnalyseList().addUniqueId(this.rtAnalyse);
                } else if (this.type.equals("Category")) {
                    this.rtAnalyse.getCategoryFactors().add(RuntimeStreamFormat.createCategoryFromJson(this.factorId, this.name, jSONObject));
                    runtimeWorkflow.getAnalyseList().addUniqueId(this.rtAnalyse);
                }
            } else {
                this.analyseId = null;
                this.rtAnalyse = null;
            }
        }

        public String getAnalyseId() {
            return this.analyseId;
        }

        public String getFactorId() {
            return this.factorId;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public RtAnalyse getRtAnalyse() {
            return this.rtAnalyse;
        }

        public boolean isResult() {
            return this.result;
        }

        public boolean isThumbnail() {
            return this.thumbnail;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class DescriptorTuples
    implements Iterable<DescriptorTuple> {
        private final List<DescriptorTuple> list = new ArrayList<DescriptorTuple>();
        private final HashMap<String, Integer> analyseIndexHashMap = new HashMap();

        public void add(DescriptorTuple descriptorTuple) {
            this.analyseIndexHashMap.put(descriptorTuple.getAnalyseId() + ":" + descriptorTuple.getFactorId(), this.list.size());
            this.list.add(descriptorTuple);
        }

        public List<DescriptorTuple> getList() {
            return this.list;
        }

        public int size() {
            return this.list.size();
        }

        public Integer getAnalyseIndex(String string, String string2) {
            return this.analyseIndexHashMap.get(string + ":" + string2);
        }

        @Override
        public Iterator<DescriptorTuple> iterator() {
            return this.list.iterator();
        }
    }
}

