/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.application;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;

public class RuntimeStreamFormat {
    private final PixelWidth pixelWidth;
    private final List<StreamType> streamTypes = new ArrayList<StreamType>();
    private final VisualisationNode.ColorScale colorScale;

    public RuntimeStreamFormat(JSONObject jSONObject, RuntimeWorkflow runtimeWorkflow) {
        JSONObject jSONObject2 = (JSONObject)jSONObject.get("StreamFormat");
        this.pixelWidth = jSONObject2.has("LineWidth") ? new PixelWidth(jSONObject2.getInt("LineWidth")) : null;
        this.colorScale = jSONObject2.has("ColorScale") ? new VisualisationNode.ColorScale(jSONObject2.getString("ColorScale"), jSONObject2.getBoolean("ReverseColors")) : new VisualisationNode.ColorScale("jet", false);
        JSONArray jSONArray = jSONObject2.getJSONArray("Lines");
        for (int i = 0; i < jSONArray.length(); ++i) {
            this.streamTypes.add(new PredictionLinesStreamType((JSONObject)jSONArray.get(i), runtimeWorkflow));
        }
    }

    public PixelWidth getPixelWidth() {
        return this.pixelWidth;
    }

    public VisualisationNode.ColorScale getColorScale() {
        return this.colorScale;
    }

    public List<StreamType> getStreamTypes() {
        return this.streamTypes;
    }

    public static CategoryFactor createCategoryFromJson(String string, String string2, JSONObject jSONObject) {
        CategoryFactor categoryFactor = new CategoryFactor(string2, string);
        for (Object e : jSONObject.getJSONArray("Classes")) {
            JSONObject jSONObject2 = (JSONObject)e;
            CatClass catClass = new CatClass(jSONObject2.getString("Name"), categoryFactor);
            catClass.setColor(jSONObject2.getString("Color"));
            if (jSONObject2.has("Value")) {
                catClass.setIndex(jSONObject2.getInt("Value"));
            }
            categoryFactor.addClass(catClass);
        }
        categoryFactor.sortAccordingToIndex();
        return categoryFactor;
    }

    public static class PredictionLinesStreamType
    extends StreamType {
        private String lineType;
        private RtAnalyse rtAnalyse;
        private Factor rtFactor;
        private String name;
        private boolean objectOnly;
        private int index;
        private MinMax minMax;

        public PredictionLinesStreamType() {
            super(BufferedTcpStream.HeaderType.PredictionLines);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public PredictionLinesStreamType(JSONObject jSONObject, RuntimeWorkflow runtimeWorkflow) {
            super(BufferedTcpStream.HeaderType.PredictionLines);
            this.lineType = jSONObject.getString("LineType");
            if (jSONObject.has("ObjectOnly")) {
                this.objectOnly = jSONObject.getBoolean("ObjectOnly");
            }
            if (jSONObject.has("Index")) {
                this.index = jSONObject.getInt("Index");
            }
            if (!jSONObject.isNull("Analyse")) {
                String string = jSONObject.getString("Analyse");
                String string2 = jSONObject.getString("Id");
                String string3 = jSONObject.getString("Name");
                String string4 = jSONObject.getString("Type");
                BasicAnalyse.ModelMethod modelMethod = jSONObject.has("Method") && !jSONObject.isNull("Method") ? BasicAnalyse.ModelMethod.valueOf(jSONObject.getString("Method")) : (string4.equals("Category") ? BasicAnalyse.ModelMethod.ClassificationPlsDa : BasicAnalyse.ModelMethod.QuantificationPls);
                this.rtAnalyse = (RtAnalyse)runtimeWorkflow.getAnalyseList().byId(string);
                if (this.rtAnalyse == null) {
                    this.rtAnalyse = new RtAnalyse(string, string3, modelMethod, runtimeWorkflow.getStudyId());
                    runtimeWorkflow.getAnalyseList().addUniqueId(this.rtAnalyse);
                }
                if (string4.equals("Property")) {
                    PropertyFactor propertyFactor = new PropertyFactor(string3, string2);
                    this.rtAnalyse.getPropertyFactors().add(propertyFactor);
                    if (jSONObject.has("Min") && jSONObject.has("Max")) {
                        propertyFactor.setMin((float)jSONObject.getDouble("Min"));
                        propertyFactor.setMax((float)jSONObject.getDouble("Max"));
                    }
                    this.rtFactor = propertyFactor;
                    return;
                } else {
                    if (!string4.equals("Category")) throw new RuntimeException("No such type: " + string4);
                    CategoryFactor categoryFactor = RuntimeStreamFormat.createCategoryFromJson(string2, string3, jSONObject);
                    this.rtAnalyse.getCategoryFactors().add(categoryFactor);
                    this.rtFactor = categoryFactor;
                }
                return;
            } else {
                if (jSONObject.has("Min") && jSONObject.has("Max")) {
                    this.minMax = new MinMax((float)jSONObject.getDouble("Min"), (float)jSONObject.getDouble("Max"));
                }
                this.name = jSONObject.getString("Name");
            }
        }

        @Override
        public String getLineType() {
            return this.lineType;
        }

        @Override
        public BasicAnalyse getAnalyse() {
            return this.rtAnalyse;
        }

        @Override
        public Factor getFactor() {
            return this.rtFactor;
        }

        @Override
        public MinMax getMinMax() {
            if (this.minMax != null && this.minMax.abs().floatValue() > 0.0f) {
                return this.minMax;
            }
            return super.getMinMax();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isObjectOnly() {
            return this.objectOnly;
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    public static class RawPixelLineStreamType
    extends StreamType {
        public RawPixelLineStreamType(JSONObject jSONObject) {
            super(BufferedTcpStream.HeaderType.RawPixelLine);
        }

        @Override
        public String getLineType() {
            return BufferedTcpStream.HeaderType.RawPixelLine.name();
        }

        @Override
        public String getName() {
            return "Raw";
        }
    }

    public static abstract class StreamType {
        private final BufferedTcpStream.HeaderType headerType;

        public StreamType(BufferedTcpStream.HeaderType headerType) {
            this.headerType = headerType;
        }

        public BufferedTcpStream.HeaderType getHeaderType() {
            return this.headerType;
        }

        public abstract String getLineType();

        public BasicAnalyse getAnalyse() {
            return null;
        }

        public Factor getFactor() {
            return null;
        }

        public MinMax getMinMax() {
            return new MinMax(0.0f, 255.0f);
        }

        public abstract String getName();

        public boolean isObjectOnly() {
            return false;
        }

        public int getIndex() {
            return 0;
        }
    }
}

