/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.application;

import java.awt.image.BufferedImage;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.json.JSONObject;
import se.prediktera.breeze.backend.entry.RtPredictionMode;
import se.prediktera.breeze.backend.entry.RtWorkflow;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyseList;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluationTree;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ExpressionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.realtime.variable.RtCategoryVariable;
import se.prediktera.breeze.common.realtime.variable.RtVariable;
import se.prediktera.breeze.common.realtime.variable.VariableHolder;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.application.RuntimeObjectFormat;
import se.prediktera.breeze.entry.application.RuntimeStreamFormat;
import se.prediktera.breeze.entry.application.status.StatusList;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportBreezeRuntime;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MetaInterface;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.breeze.hardware.camera.capture.RuntimeWorkflowFrameStack;
import se.prediktera.map.common.error.Logg;

public class RuntimeWorkflow
extends RtWorkflow
implements MetaInterface {
    private final RuntimeObjectFormat.DescriptorTuples descriptors = new RuntimeObjectFormat.DescriptorTuples();
    private final List<RuntimeObjectFormat.DescriptorValues> objectValues = new ArrayList<RuntimeObjectFormat.DescriptorValues>();
    private final StatusList statusList = new StatusList();
    private RuntimeStreamFormat streamFormat;
    private RuntimeObjectFormat objectFormat;
    private boolean includeChildObjects;
    private boolean useCompressedReferences;
    private List<PPExportBreezeRuntime.MandatoryRuntimeParameter> runtimeParameters = new ArrayList<PPExportBreezeRuntime.MandatoryRuntimeParameter>();
    private BufferedImage thumbnail;
    private BufferedImage smallThumbnail;

    public RuntimeWorkflow(File file) {
        super(file);
        for (DescriptorTreeNode descriptorTreeNode : this.getAnalyseTree().getDescriptorNodes()) {
            this.descriptors.add(new RuntimeObjectFormat.DescriptorTuple(descriptorTreeNode.getAnalyseUid(), descriptorTreeNode.getUid(), descriptorTreeNode.getAliasOrNodeString()));
        }
    }

    public RuntimeWorkflow(String string, String string2, String string3, String string4, String string5) {
        super(string, string2, string3, string4, string5);
    }

    public RuntimeWorkflow() {
    }

    public String getViewCreatedDate() {
        try {
            return EntryData.viewformat.format(EntryData.format.parse(this.getCreatedTime()));
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    public void addObject(RuntimeObjectFormat.DescriptorValues descriptorValues, int n) {
        if (this.objectValues.size() > n) {
            for (int i = 1; i < this.objectValues.size(); ++i) {
                this.objectValues.set(i - 1, this.objectValues.get(i));
            }
            this.objectValues.set(n, descriptorValues);
        } else {
            this.objectValues.add(descriptorValues);
        }
    }

    @Override
    public List<String> getSortedMetadataKeys() {
        return this.statusList.getSortedMetadataKeys();
    }

    @Override
    public String getMetaValue(String string) {
        return this.statusList.getMetaValue(string);
    }

    public void updateStatus(StatusList statusList) {
        this.statusList.update(statusList);
    }

    public List<RtBasicVariable> createVariables() {
        Object object;
        ArrayList<RtBasicVariable> arrayList = new ArrayList<RtBasicVariable>();
        RtCategoryVariable rtCategoryVariable = null;
        for (RuntimeStreamFormat.StreamType object2 : this.streamFormat.getStreamTypes()) {
            Object object3 = object2.getAnalyse();
            object = object2.getFactor();
            int n = object2.getIndex();
            if (object3 != null) {
                if (object instanceof CategoryFactor) {
                    rtCategoryVariable = new RtCategoryVariable(new AnalyseVariableHolder(n, (BasicAnalyse)object3), (CategoryFactor)object, ((BasicAnalyse)object3).getName(), ((BasicAnalyse)object3).getModelMethod(), object2.isObjectOnly(), (CategoryFactor)object);
                    arrayList.add(rtCategoryVariable);
                    continue;
                }
                if (!(object instanceof PropertyFactor)) continue;
                arrayList.add(new RtVariable(new AnalyseVariableHolder(n, (BasicAnalyse)object3), (PropertyFactor)object, ((Factor)object).getName(), 0, ((Factor)object).getMin(), ((Factor)object).getMax(), object2.isObjectOnly(), this.streamFormat.getColorScale()));
                continue;
            }
            MinMax minMax = object2.getMinMax();
            arrayList.add(new RtBasicVariable(new AnalyseVariableHolder(n, null), object2.getName(), minMax.min().floatValue(), minMax.max().floatValue()));
        }
        if (rtCategoryVariable != null) {
            int n = arrayList.indexOf(rtCategoryVariable);
            for (Object object3 : this.descriptors) {
                object = ((RuntimeObjectFormat.DescriptorTuple)object3).getRtAnalyse();
                if (object == null || RuntimeWorkflow.hasAnalyse(arrayList, (BasicAnalyse)object) || !((RtAnalyse)object).getModelMethod().isClassification()) continue;
                arrayList.add(new RtCategoryVariable(new AnalyseVariableHolder(n, (BasicAnalyse)object), ((BasicAnalyse)object).getCategoryFactor(), ((RtAnalyse)object).getName(), ((RtAnalyse)object).getModelMethod(), true, rtCategoryVariable.getAnalyse().getCategoryFactor()));
            }
        }
        return arrayList;
    }

    private static boolean hasAnalyse(List<RtBasicVariable> list, BasicAnalyse basicAnalyse) {
        for (RtBasicVariable rtBasicVariable : list) {
            BasicAnalyse basicAnalyse2 = rtBasicVariable.getAnalyse();
            if (basicAnalyse2 == null || !basicAnalyse.getUid().equals(basicAnalyse2.getUid())) continue;
            return true;
        }
        return false;
    }

    public List<AnalyseFactor> createDescriptorAnalyseList() {
        ArrayList<AnalyseFactor> arrayList = new ArrayList<AnalyseFactor>();
        for (RuntimeObjectFormat.DescriptorTuple descriptorTuple : this.getDescriptors()) {
            BasicAnalyseList<BasicAnalyse> basicAnalyseList = this.getAnalyseList();
            BasicAnalyse basicAnalyse = (BasicAnalyse)basicAnalyseList.byId(descriptorTuple.getAnalyseId());
            if (basicAnalyse != null) {
                Factor factor = basicAnalyse.getFactor(descriptorTuple.getFactorId());
                arrayList.add(new AnalyseFactor(basicAnalyse, factor));
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public BufferedImage getSmallThumbnail(int n, int n2) {
        if (this.smallThumbnail == null) {
            this.smallThumbnail = ImageHelper.getScaledImage(this.thumbnail, n, n2, null);
        }
        return this.smallThumbnail;
    }

    public static RuntimeWorkflow fromJSON(String string) {
        return RuntimeWorkflow.fromJSONworkflow(new JSONObject(string));
    }

    public static RuntimeWorkflow fromJSONworkflow(JSONObject jSONObject) {
        JSONObject jSONObject2;
        Object object;
        if (BufferedTcpStream.PrintDebug) {
            Logg.debug((String)jSONObject.toString(2), (Object[])new Object[0]);
        }
        RuntimeWorkflow runtimeWorkflow = new RuntimeWorkflow(jSONObject.getString("Id"), jSONObject.getString("Name"), jSONObject.getString("Description"), jSONObject.getString("CreatedTime"), jSONObject.getString("CreatedBy"));
        if (jSONObject.has("Settings")) {
            object = (JSONObject)jSONObject.get("Settings");
            runtimeWorkflow.setPredictionMode(new RtPredictionMode((JSONObject)object));
        } else if (jSONObject.has("PredictionMode")) {
            runtimeWorkflow.setPredictionMode(new RtPredictionMode(jSONObject));
        }
        if (jSONObject.has("Visualization")) {
            object = (JSONObject)jSONObject.get("Visualization");
            runtimeWorkflow.direction = object.optString("Direction", "vertical");
            runtimeWorkflow.horizontalDirection = object.optString("HorizontalDirection", "right");
            runtimeWorkflow.verticalDirection = object.optString("VerticalDirection", "up");
        }
        if (jSONObject.has("IncludeChildObjects")) {
            runtimeWorkflow.setIncludeChildObjects(jSONObject.getBoolean("IncludeChildObjects"));
        }
        if (jSONObject.has("Fields")) {
            object = jSONObject.getJSONArray("Fields");
            jSONObject2 = new ArrayList();
            for (int i = 0; i < object.length(); ++i) {
                JSONObject jSONObject3 = (JSONObject)object.get(i);
                jSONObject2.add(new PPExportBreezeRuntime.MandatoryRuntimeParameter(jSONObject3.getString("Name"), 0.0f, 0.0f, 0.0f, (float)jSONObject3.getDouble("Value"), jSONObject3.getString("Unit")));
            }
            runtimeWorkflow.setRuntimeParameters((List<PPExportBreezeRuntime.MandatoryRuntimeParameter>)jSONObject2);
        }
        if (jSONObject.has("Thumbnail") && !jSONObject.isNull("Thumbnail")) {
            runtimeWorkflow.setThumbnail(ImageHelper.base64StringToImg(jSONObject.getString("Thumbnail")));
        }
        runtimeWorkflow.setStreamFormat(new RuntimeStreamFormat(jSONObject, runtimeWorkflow));
        runtimeWorkflow.setObjectFormat(new RuntimeObjectFormat(jSONObject, runtimeWorkflow));
        if (jSONObject.has("AnalyseTree")) {
            object = new EvaluationTree();
            jSONObject2 = jSONObject.getJSONObject("AnalyseTree");
            ((EvaluationTree)object).setRoot(RuntimeWorkflow.parseAnalyseTree(jSONObject2, null));
            runtimeWorkflow.setAnalyseTree((EvaluationTree)object);
        }
        return runtimeWorkflow;
    }

    private void setRuntimeParameters(List<PPExportBreezeRuntime.MandatoryRuntimeParameter> list) {
        this.runtimeParameters = list;
    }

    private void setIncludeChildObjects(boolean bl) {
        this.includeChildObjects = bl;
    }

    private static FunctionTreeNode parseAnalyseTree(JSONObject jSONObject, FunctionTreeNode functionTreeNode) {
        Object object;
        String string = jSONObject.getString("Name");
        FunctionTreeNode functionTreeNode2 = FunctionHelper.createDefaultFunction(string);
        if (!jSONObject.isNull("Alias") && !((String)(object = jSONObject.getString("Alias"))).isEmpty()) {
            functionTreeNode2.setAlias((String)object);
        }
        if (!jSONObject.isNull("Id") && (object = jSONObject.getString("Id")) != null && functionTreeNode2 instanceof FunctionTreeNodeWithId) {
            ((FunctionTreeNodeWithId)functionTreeNode2).setUid((String)object);
        }
        object = functionTreeNode2.getFunction();
        for (Object e : jSONObject.getJSONArray("Params")) {
            ExpressionParameter expressionParameter;
            List list;
            JSONObject jSONObject2 = (JSONObject)e;
            FunctionParameter functionParameter = ((AbstractBreezeFunction)object).getParameterByName(jSONObject2.getString("Name"));
            if (functionParameter == null) continue;
            functionParameter.setValueStr(jSONObject2.getString("Value"));
            if (!(functionParameter instanceof ExpressionParameter) || (list = (expressionParameter = (ExpressionParameter)functionParameter).getExpressionLists()).size() != 1) continue;
            ((ExpressionParameter.Expression)list.getFirst()).set(functionParameter.getValueStr());
        }
        if (functionTreeNode2 instanceof DescriptorTreeNode) {
            ((DescriptorTreeNode)functionTreeNode2).setIndex(jSONObject.getInt("Index"));
        }
        for (Object e : jSONObject.getJSONArray("Nodes")) {
            functionTreeNode2.addChild(RuntimeWorkflow.parseAnalyseTree((JSONObject)e, functionTreeNode2));
        }
        return functionTreeNode2;
    }

    @Generated
    public RuntimeObjectFormat.DescriptorTuples getDescriptors() {
        return this.descriptors;
    }

    @Generated
    public List<RuntimeObjectFormat.DescriptorValues> getObjectValues() {
        return this.objectValues;
    }

    @Generated
    public void setStreamFormat(RuntimeStreamFormat runtimeStreamFormat) {
        this.streamFormat = runtimeStreamFormat;
    }

    @Generated
    public RuntimeStreamFormat getStreamFormat() {
        return this.streamFormat;
    }

    @Generated
    public void setObjectFormat(RuntimeObjectFormat runtimeObjectFormat) {
        this.objectFormat = runtimeObjectFormat;
    }

    @Generated
    public RuntimeObjectFormat getObjectFormat() {
        return this.objectFormat;
    }

    @Generated
    public boolean isIncludeChildObjects() {
        return this.includeChildObjects;
    }

    @Generated
    public boolean isUseCompressedReferences() {
        return this.useCompressedReferences;
    }

    @Generated
    public List<PPExportBreezeRuntime.MandatoryRuntimeParameter> getRuntimeParameters() {
        return this.runtimeParameters;
    }

    @Generated
    public void setThumbnail(BufferedImage bufferedImage) {
        this.thumbnail = bufferedImage;
    }

    @Generated
    public BufferedImage getThumbnail() {
        return this.thumbnail;
    }

    private static class AnalyseVariableHolder
    implements VariableHolder<RuntimeWorkflowFrameStack> {
        private final int index;
        private final BasicAnalyse analyse;

        public AnalyseVariableHolder(int n, BasicAnalyse basicAnalyse) {
            this.index = n;
            this.analyse = basicAnalyse;
        }

        @Override
        public Frame getResultFrame(RuntimeWorkflowFrameStack runtimeWorkflowFrameStack) {
            return runtimeWorkflowFrameStack.getFrame(this.index);
        }

        @Override
        public BasicAnalyse getAnalyse() {
            return this.analyse;
        }

        @Override
        public boolean isRuntime() {
            return true;
        }
    }

    public record AnalyseFactor(BasicAnalyse analyse, Factor factor) {
        public boolean isClassification() {
            return this.analyse.getModelMethod().isClassification();
        }
    }
}

