/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.application.status;

import java.awt.Color;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MetaInterface;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.Logg;

public class StatusList
implements MetaInterface,
Iterable<String> {
    private final HashMap<String, String> hashMap = new HashMap();

    @Override
    public Iterator<String> iterator() {
        return this.hashMap.keySet().iterator();
    }

    public StatusList() {
    }

    public StatusList(String string) {
        JSONObject jSONObject = new JSONObject(string);
        if (BufferedTcpStream.PrintDebug) {
            Logg.debug((String)"GetStatus", (Object[])new Object[0]);
            Logg.debug((String)jSONObject.toString(2), (Object[])new Object[0]);
        }
        for (Status status : Status.values()) {
            this.put(status.name(), jSONObject.isNull(status.name()) ? "" : jSONObject.get(status.name()).toString());
        }
    }

    public void update(StatusList statusList) {
        this.hashMap.clear();
        for (String string : statusList) {
            this.put(string, statusList.getMetaValue(string));
        }
    }

    public void put(String string, String string2) {
        this.hashMap.put(string, string2);
    }

    @Override
    public List<String> getSortedMetadataKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (String string : this) {
                arrayList.add(string);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        arrayList.sort(String::compareTo);
        return arrayList;
    }

    public float getMetaNumber(String string) {
        return (float)NiceDataFormat.toNumber((String)this.getMetaValue(string));
    }

    @Override
    public String getMetaValue(String string) {
        if (this.hashMap.containsKey(string)) {
            return this.hashMap.get(string);
        }
        return "N/A";
    }

    public boolean isIdle() {
        return this.getState().equals((Object)ServerState.Idle);
    }

    public boolean isPredicting() {
        return this.getState().equals((Object)ServerState.Predicting);
    }

    public ServerState getState() {
        return ServerState.valueOf(this.getMetaValue(Status.State.name()));
    }

    public boolean hasLoadedWorkflow() {
        return this.getWorkflowId().length() > 0;
    }

    public String getWorkflowId() {
        return this.getMetaValue(Status.WorkflowId.name());
    }

    public boolean hasInitiatedCamera() {
        return this.getCameraType().length() > 0;
    }

    public String getCameraName() {
        return this.getMetaValue(Status.CameraName.name());
    }

    public String getCameraType() {
        return this.getMetaValue(Status.CameraType.name());
    }

    public FrameRate getFrameRate() {
        return new FrameRate(this.getMetaNumber(Status.FrameRate.name()));
    }

    public IntegrationTime getIntegrationTime() {
        return new IntegrationTime(this.getMetaNumber(Status.IntegrationTime.name()));
    }

    private static enum Status {
        State,
        WorkflowId,
        CameraName,
        CameraType,
        FrameRate,
        IntegrationTime,
        Temperature,
        DarkReferenceValidTime,
        WhiteReferenceValidTime,
        LicenseExpiryDate,
        SystemTime,
        SystemTimeFormat;

    }

    public static enum ServerState {
        Idle,
        Predicting,
        CapturingMultipleFrames,
        CapturingRawPixelLines,
        Initializing,
        Stopping;


        public Color getColor() {
            return switch (this.ordinal()) {
                case 4 -> Color.yellow;
                case 1, 2, 3 -> Color.red;
                case 5 -> Color.blue;
                default -> Color.black;
            };
        }
    }

    public record CameraStatus(Camera camera, StatusList status) {
    }
}

