/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.group.BasicGroup;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflowList;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.legacy.LegacyGroupToStudyFormat;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.util.BreezeFilter;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.util.SortedFileList;
import se.prediktera.map.common.error.Logg;

public abstract class BaseWorkflowList
extends BasicWorkflowList {
    private final BreezeType type;

    public BaseWorkflowList(BreezeProgress breezeProgress, File file, BreezeType breezeType, boolean bl) {
        this.type = breezeType;
        List<File> list = new SortedFileList.SortedFolderList(file).getFiles();
        breezeProgress.setMaximumAndReset(list.size());
        for (File file2 : list) {
            try {
                try {
                    Workflow workflow = new Workflow(file2, null, bl);
                    Workflow workflow2 = this.byId(workflow.getUid());
                    if (workflow2 != null) {
                        String string = String.valueOf((Object)breezeType) + " workflow \"" + workflow2.getName() + "\" and \"" + workflow.getName() + "\" has the same id (" + workflow.getUid() + ")";
                        Logg.warn((String)string, (Object[])new Object[0]);
                        workflow.getEntryData().setUid(UniqueUID.getUniqueId());
                        workflow.save();
                    }
                    this.add(workflow);
                    breezeProgress.incStep();
                }
                catch (XmlParserHelper.XmlFileNotFoundException xmlFileNotFoundException) {
                    Logg.warn((String)"Could not parse workflow in folder {}", (Object[])new Object[]{file2});
                }
                catch (XmlParserHelper.XmlInvalidRootNodeException xmlInvalidRootNodeException) {
                    if (BaseWorkflowList.isGroupNodeName(xmlInvalidRootNodeException.nodeName()) && breezeType == BreezeType.Project) {
                        this.add(LegacyGroupToStudyFormat.moveLegacyGroupIntoNewStudy(file2));
                        continue;
                    }
                    throw xmlInvalidRootNodeException;
                }
            }
            catch (XmlParserHelper.XmlParseException xmlParseException) {
                throw xmlParseException;
            }
            catch (Exception exception) {
                throw new RuntimeException("Error parsing in workflow: " + file2.getAbsolutePath() + (String)(exception.getMessage() != null ? "\n\n" + exception.getMessage() : ""), exception);
            }
        }
        ListHelper.sortEntriesByDate(this);
    }

    @Override
    public Workflow byId(String string) {
        return (Workflow)super.byId(string);
    }

    private static boolean isGroupNodeName(String string) {
        return string.equals("group") || string.equals("design");
    }

    public List<BasicWorkflow> getSortedList() {
        ArrayList<BasicWorkflow> arrayList = new ArrayList<BasicWorkflow>(this);
        arrayList.sort((basicWorkflow, basicWorkflow2) -> basicWorkflow.getName().compareToIgnoreCase(basicWorkflow2.getName()));
        return arrayList;
    }

    public Collection<BasicWorkflow> workflowsAssociatedToAnalyse(Analyse analyse) {
        ArrayList<BasicWorkflow> arrayList = new ArrayList<BasicWorkflow>();
        for (BasicWorkflow basicWorkflow : this) {
            if (!this.workflowsAssociatedToAnalyse(basicWorkflow.getAnalyseTree().getRoot(), analyse)) continue;
            arrayList.add(basicWorkflow);
        }
        return arrayList;
    }

    private boolean workflowsAssociatedToAnalyse(FunctionTreeNode functionTreeNode, Analyse analyse) {
        if (analyse.getUid().equals(functionTreeNode.getAnalyseUid())) {
            return true;
        }
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            if (!this.workflowsAssociatedToAnalyse(functionTreeNode2, analyse)) continue;
            return true;
        }
        return false;
    }

    public List<BasicWorkflow> filter(BreezeFilter breezeFilter) {
        return this.stream().filter(breezeFilter::matches).collect(Collectors.toList());
    }

    public Measurement getMeasurementFromFolder(File file) {
        String string = file.getName();
        File file2 = file.getParentFile();
        if (file2 != null && new File(file2, "group.xml").exists()) {
            String string2 = file2.getName();
            File file3 = file2.getParentFile();
            if (file3 != null && new File(file3, "workflow.xml").exists()) {
                String string3 = file3.getName();
                File file4 = file3.getParentFile();
                if (file4 != null && file4.getName().equals(this.type.getFolderName())) {
                    return this.getMeasurement(string, string2, string3);
                }
            }
        }
        return null;
    }

    private Measurement getMeasurement(String string, String string2, String string3) {
        for (BasicWorkflow basicWorkflow : this) {
            if (!basicWorkflow.getName().equals(string3)) continue;
            for (BasicGroup basicGroup : ((Workflow)basicWorkflow).getChildList()) {
                Group group = (Group)basicGroup;
                if (!group.getName().equals(string2)) continue;
                for (Measurement measurement : group.getChildList()) {
                    if (!measurement.getName().equals(string)) continue;
                    return measurement;
                }
            }
            return null;
        }
        return null;
    }
}

