/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.cache;

import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BasicMasterCache;
import se.prediktera.breeze.common.entry.analyse.RtAnalyseList;
import se.prediktera.breeze.common.entry.factor.FactorCache;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.AnalyseList;
import se.prediktera.breeze.entry.cache.StudyList;
import se.prediktera.breeze.entry.cache.WorkflowList;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.update.UpdateHelper;

public class BreezeMasterCache
implements BasicMasterCache.MasterCacheInterface {
    private AnalyseList analyseList;
    private RtAnalyseList rtAnalyseList;
    private StudyList studyList;
    private WorkflowList workflowList;
    private final FactorCache factorCache = FactorCache.getInstance();

    public static BreezeMasterCache getInstance() {
        return (BreezeMasterCache)BreezeMasterCache.getInstanceLocal();
    }

    public static boolean isInstanceMasterCache() {
        return BreezeMasterCache.getInstanceLocal() instanceof BreezeMasterCache;
    }

    public static BasicMasterCache.MasterCacheInterface getInstanceLocal() {
        BasicMasterCache.MasterCacheInterface masterCacheInterface = BasicMasterCache.getInstance().getMasterCacheInterface();
        if (masterCacheInterface == null) {
            masterCacheInterface = new BreezeMasterCache();
            BreezeMasterCache.setMasterCache(masterCacheInterface);
        }
        return masterCacheInterface;
    }

    public static void setMasterCache(BasicMasterCache.MasterCacheInterface masterCacheInterface) {
        BasicMasterCache.getInstance().setMasterCacheInterface(masterCacheInterface);
    }

    public static void reloadInstance() {
        BreezeMasterCache.clearInstance();
        BreezeMasterCache.getInstance();
    }

    public static void clearInstance() {
        BasicMasterCache.clearInstance();
        FactorCache.clearInstance();
    }

    public void clearAnalyseList() {
        this.analyseList = null;
        this.rtAnalyseList = null;
    }

    public void clearAllList() {
        this.analyseList = null;
        this.rtAnalyseList = null;
        this.studyList = null;
        this.workflowList = null;
    }

    @Override
    public AnalyseList getAnalyseList() {
        if (this.analyseList == null) {
            if (UpdateHelper.Product.isRunningProductEvince()) {
                this.analyseList = new AnalyseList();
            } else {
                try {
                    this.analyseList = new AnalyseList(WorkspaceManager.getInstance().getWorkspace());
                }
                catch (WorkspaceManager.WorkspacePermissionException workspacePermissionException) {
                    this.analyseList = new AnalyseList();
                }
            }
        }
        return this.analyseList;
    }

    public static RtAnalyseList getRtAnalyseListOrNull() {
        if (BreezeMasterCache.isInstanceMasterCache()) {
            return BreezeMasterCache.getInstance().getRtAnalyseList();
        }
        return null;
    }

    @Override
    public RtAnalyseList getRtAnalyseList() {
        if (this.rtAnalyseList == null) {
            this.rtAnalyseList = new RtAnalyseList();
        }
        return this.rtAnalyseList;
    }

    @Override
    public StudyList getStudyList() {
        return this.getStudyList(BreezeProgressManager.createEmpty(), true);
    }

    public StudyList getStudyList(BreezeProgress breezeProgress, boolean bl) {
        if (this.studyList == null) {
            this.studyList = new StudyList(breezeProgress, bl);
        }
        return this.studyList;
    }

    @Override
    public WorkflowList getWorkflowList() {
        if (this.workflowList == null) {
            this.workflowList = new WorkflowList();
        }
        return this.workflowList;
    }

    public FactorCache getFactorCache() {
        return this.factorCache;
    }

    public static class MockBreezeMasterCache
    extends BreezeMasterCache {
        private final AnalyseList analyseList = new AnalyseList();

        @Override
        public AnalyseList getAnalyseList() {
            return this.analyseList;
        }
    }
}

