/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.comment;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;

public class Comment
implements BasicTreeInterface {
    private String textContent;
    private Date createdDate;
    private String createdBy;

    public Comment() {
        this("NA", "NA", "NA");
    }

    public Comment(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("value")) {
                this.textContent = nodeList.item(i).getTextContent();
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("createddate")) {
                this.parseSimpleCreatedDate(nodeList.item(i).getTextContent());
                continue;
            }
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase("createdby")) continue;
            this.createdBy = nodeList.item(i).getTextContent();
        }
    }

    public Comment(String string) {
        this.textContent = string;
        this.createdDate = new Date();
        this.createdBy = BreezeProperties.getInstance().getLoginUser().getUsername();
    }

    public Comment(String string, String string2, String string3) {
        this.textContent = string;
        this.parseSimpleCreatedDate(string2);
        this.createdBy = string3;
    }

    public String getName() {
        return this.getTextContent();
    }

    public String getSimpleCreatedDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        if (this.createdDate == null) {
            return "NA";
        }
        return simpleDateFormat.format(this.createdDate);
    }

    public void parseSimpleCreatedDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            this.createdDate = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            this.createdDate = new Date();
        }
    }

    public void setCreatedDate(String string) {
        this.parseSimpleCreatedDate(string);
    }

    public String toString() {
        return this.getTextContent();
    }

    @Generated
    public String getTextContent() {
        return this.textContent;
    }

    @Generated
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public void setTextContent(String string) {
        this.textContent = string;
    }

    @Generated
    public void setCreatedBy(String string) {
        this.createdBy = string;
    }
}

