/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.factor;

import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;

public class SampleVariableValueParser {
    public static void parseVariables(FactorHolder factorHolder, Node node, Sample sample) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equalsIgnoreCase("qualitative")) {
                SampleVariableValueParser.parseCategory(factorHolder, node2, sample);
                continue;
            }
            if (!string.equalsIgnoreCase("quantitative")) continue;
            SampleVariableValueParser.parseProperty(factorHolder, node2, sample);
        }
    }

    private static void parseCategory(FactorHolder factorHolder, Node node, Sample sample) {
        CategoryFactor categoryFactor = (CategoryFactor)SampleVariableValueParser.parseFactor(factorHolder, node, Factor.Type.Category);
        for (Node node2 : XmlParserHelper.getNodeList(node, "class")) {
            String string = node2.getTextContent();
            if (string.length() > 0) {
                String string2 = XmlParserHelper.getAttribute(node2, "id", string);
                CatClass catClass = categoryFactor.getClassByUid(string2);
                if (catClass == null) {
                    catClass = categoryFactor.addClass(string);
                }
                sample.getSampleValues().setValue(categoryFactor, catClass.getValueIdx());
                continue;
            }
            sample.getSampleValues().removeValue(categoryFactor);
        }
    }

    private static void parseProperty(FactorHolder factorHolder, Node node, Sample sample) {
        PropertyFactor propertyFactor = (PropertyFactor)SampleVariableValueParser.parseFactor(factorHolder, node, Factor.Type.Property);
        for (Node node2 : XmlParserHelper.getNodeList(node, "value")) {
            propertyFactor.setValue(node2.getTextContent(), sample);
        }
    }

    private static Factor parseFactor(FactorHolder factorHolder, Node node, Factor.Type type) {
        Factor factor = factorHolder.getFactorByUid(XmlParserHelper.getAttribute(node, "id"));
        if (factor == null) {
            return SampleVariableValueParser.addFactor(factorHolder, type, node.getAttributes());
        }
        return factor;
    }

    private static Factor addFactor(FactorHolder factorHolder, Factor.Type type, NamedNodeMap namedNodeMap) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Factor.Type.Category -> {
                CategoryFactor var3_3 = new CategoryFactor(namedNodeMap);
                var3_3.addNoClass("-", Color.red);
                yield factorHolder.getCategoryFactors().add(var3_3);
            }
            case Factor.Type.Property -> factorHolder.getPropertyFactors().add(new PropertyFactor(namedNodeMap));
        };
    }

    public static void createSampleVariablesNode(Node node, Sample sample, Workflow workflow) {
        Object object;
        Object object2;
        Element element = XmlParserHelper.addElement(node, "variables");
        CategoryList categoryList = workflow.getCategoryFactors();
        for (int i = 0; i < categoryList.size(); ++i) {
            CategoryFactor categoryFactor = categoryList.get(i);
            object2 = XmlParserHelper.addElement(element, "qualitative");
            object2.setAttribute("id", categoryFactor.getUid());
            object2.setAttribute("name", categoryFactor.getName());
            object = categoryFactor;
            CatClass catClass = ((CategoryFactor)object).getClass(sample);
            if (catClass != null) {
                Element element2 = XmlParserHelper.addElement((Node)object2, "class", catClass.getName());
                element2.setAttribute("id", catClass.getUid());
                continue;
            }
            XmlParserHelper.addElement((Node)object2, "class", "-");
        }
        PropertyList propertyList = workflow.getPropertyFactors();
        for (int i = 0; i < propertyList.size(); ++i) {
            object2 = propertyList.get(i);
            object = XmlParserHelper.addElement(element, "quantitative");
            object.setAttribute("id", ((Factor)object2).getUid());
            object.setAttribute("name", ((Factor)object2).getName());
            object.setAttribute("unit", ((PropertyFactor)object2).getUnit());
            XmlParserHelper.addElement((Node)object, "value", ((Factor)object2).getStringValue(sample));
        }
    }
}

